/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirits;

import com.sammy.malum.common.items.SpiritItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;

public class MalumSpiritType {
    public final Color color;
    public final String identifier;
    protected Supplier<Item> splinterItem;
    public boolean isCompound;
    public ArrayList<SpiritCountTest> tests = new ArrayList();

    public MalumSpiritType(String identifier, Color color, RegistryObject<Item> splinterItem) {
        this.identifier = identifier;
        this.color = color;
        this.splinterItem = splinterItem;
    }

    public SpiritItem splinterItem() {
        return (SpiritItem)this.splinterItem.get();
    }

    public int spiritCount(LivingEntity entity) {
        int count = 0;
        for (SpiritCountTest test : this.tests) {
            if (!test.predicate.test(entity)) continue;
            if (test.important) {
                return test.value;
            }
            if (test.value <= count) continue;
            count = test.value;
        }
        return count;
    }

    public MalumSpiritType setCompound() {
        this.isCompound = true;
        return this;
    }

    public MalumSpiritType addTest(int value, Predicate<LivingEntity> predicate) {
        this.tests.add(new SpiritCountTest(value, predicate));
        return this;
    }

    public MalumSpiritType addTest(int value, CreatureAttribute attribute) {
        this.tests.add(new SpiritCountTest(value, e -> e.func_70668_bt().equals(attribute)));
        return this;
    }

    public MalumSpiritType addTest(int value, String name) {
        this.tests.add(new SpiritCountTest(value, e -> e.func_200600_R().getRegistryName().func_110623_a().equals(name)).setImportant(true));
        return this;
    }

    public <U> MalumSpiritType addTest(int value, Class<U> clazz, boolean important) {
        this.tests.add(new SpiritCountTest(value, clazz::isInstance).setImportant(important));
        return this;
    }

    public <U> MalumSpiritType addTest(int value, Class<? extends U> ... clazzes) {
        this.tests.add(new SpiritCountTest(value, e -> {
            for (Class clazz : clazzes) {
                if (!clazz.isInstance(e)) continue;
                return true;
            }
            return false;
        }));
        return this;
    }

    public static class SpiritCountTest {
        public int value;
        public Predicate<LivingEntity> predicate;
        public boolean important;

        public SpiritCountTest(int value, Predicate<LivingEntity> predicate) {
            this.value = value;
            this.predicate = predicate;
        }

        public SpiritCountTest setImportant(boolean important) {
            this.important = important;
            return this;
        }
    }
}

