/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirits;

import com.mojang.datafixers.util.Pair;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.entities.spirit.SpiritItemEntity;
import com.sammy.malum.common.items.equipment.curios.MalumCurioItem;
import com.sammy.malum.common.items.tools.spirittools.ISpiritTool;
import com.sammy.malum.core.init.MalumEntities;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.enchantments.MalumEnchantments;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.init.particles.MalumParticles;
import com.sammy.malum.core.modcontent.MalumSpiritTypes;
import com.sammy.malum.core.systems.particles.ParticleManager;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SpiritHelper {
    public static DamageSource voodooDamageSource() {
        return new DamageSource("voodoo").func_82726_p();
    }

    public static DamageSource voodooDamageSource(Entity entity) {
        return new EntityDamageSource("voodoo", entity).func_82726_p();
    }

    public static void causeVoodooDamage(LivingEntity attacker, LivingEntity target, float amount) {
        target.func_70097_a(SpiritHelper.voodooDamageSource((Entity)attacker), amount);
    }

    public static void harvestSpirit(String spirit, LivingEntity player) {
        ArrayList<Pair<String, Integer>> spirits = new ArrayList<Pair<String, Integer>>();
        spirits.add(new Pair((Object)spirit, (Object)1));
        SpiritHelper.harvestSpirit(spirits, player);
    }

    public static void summonSpirits(LivingEntity target, LivingEntity attacker, ItemStack harvestStack) {
        Optional<MalumCurioItem> firstModifier;
        if (!(harvestStack.func_77973_b() instanceof ISpiritTool)) {
            return;
        }
        if (target instanceof PlayerEntity) {
            return;
        }
        ArrayList<ItemStack> spirits = SpiritHelper.entitySpirits(target);
        if (spirits.isEmpty()) {
            return;
        }
        ISpiritTool tool = (ISpiritTool)harvestStack.func_77973_b();
        ArrayList<MalumCurioItem> equippedMalumCurios = MalumHelper.equippedMalumCurios(attacker);
        int plunder = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)MalumEnchantments.SPIRIT_PLUNDER.get()), (ItemStack)harvestStack) + tool.spiritBonus(target);
        for (MalumCurioItem item : equippedMalumCurios) {
            plunder += item.spiritYieldBonus();
        }
        if (plunder > 0) {
            for (int i = 0; i < plunder; ++i) {
                int random = attacker.field_70170_p.field_73012_v.nextInt(spirits.size());
                spirits.get(random).func_190917_f(1);
            }
        }
        if ((firstModifier = equippedMalumCurios.stream().filter(s -> !s.spiritReplacementStack(ItemStack.field_190927_a).equals(ItemStack.field_190927_a)).findFirst()).isPresent()) {
            ArrayList<ItemStack> newSpirits = new ArrayList<ItemStack>();
            for (ItemStack stack : spirits) {
                newSpirits.add(firstModifier.get().spiritReplacementStack(stack));
            }
            spirits = newSpirits;
        }
        if (attacker.field_70170_p.field_73012_v.nextFloat() < 0.002f) {
            spirits.add(new ItemStack((IItemProvider)MalumItems.COMICALLY_LARGE_TOPHAT.get()));
        }
        SpiritHelper.summonSpirits(spirits, target, attacker);
    }

    public static void summonSpirits(LivingEntity target) {
        ArrayList<ItemStack> spirits = SpiritHelper.entitySpirits(target);
        if (!spirits.isEmpty()) {
            SpiritHelper.summonSpirits(spirits, target, null);
        }
    }

    public static void summonSpirits(ArrayList<ItemStack> spirits, LivingEntity target, LivingEntity attacker) {
        if (attacker == null) {
            attacker = target.field_70170_p.func_190525_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 8.0, e -> true);
        }
        float speed = 0.2f + 0.5f / (float)(SpiritHelper.totalSpirits(target) + 1);
        target.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), MalumSounds.SPIRIT_HARVEST, target.func_184176_by(), 1.0f, 0.9f + target.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        for (ItemStack stack : spirits) {
            int j;
            int count = stack.func_190916_E();
            if (count == 0) continue;
            if (attacker == null) {
                for (j = 0; j < count; ++j) {
                    ItemEntity itemEntity = new ItemEntity(target.field_70170_p, target.func_226282_d_(1.0), target.func_226279_cv_(), target.func_226287_g_(1.0), stack.func_77973_b().func_190903_i());
                    target.field_70170_p.func_217376_c((Entity)itemEntity);
                    stack.func_190918_g(1);
                }
                continue;
            }
            for (j = 0; j < count; ++j) {
                SpiritItemEntity essenceEntity = new SpiritItemEntity((EntityType<? extends ProjectileItemEntity>)((EntityType)MalumEntities.SPIRIT_ESSENCE.get()), target.field_70170_p);
                essenceEntity.func_213293_j(MathHelper.func_151240_a((Random)MalumMod.RANDOM, (float)(-speed), (float)speed), MathHelper.func_151240_a((Random)MalumMod.RANDOM, (float)0.05f, (float)0.05f), MathHelper.func_151240_a((Random)MalumMod.RANDOM, (float)(-speed), (float)speed));
                essenceEntity.func_70107_b(target.func_213303_ch().field_72450_a, target.func_213303_ch().field_72448_b + (double)(target.func_213302_cg() / 2.0f), target.func_213303_ch().field_72449_c);
                essenceEntity.setData(stack.func_77973_b().func_190903_i(), attacker.func_110124_au());
                target.field_70170_p.func_217376_c((Entity)essenceEntity);
                stack.func_190918_g(1);
            }
        }
    }

    public static void harvestSpirit(ArrayList<Pair<String, Integer>> spirits, LivingEntity attacker) {
        for (int i = 0; i < spirits.size(); ++i) {
            String spirit = (String)spirits.get(i).getFirst();
            int count = (Integer)spirits.get(i).getSecond();
            if (count == 0) continue;
            MalumSpiritType spiritType = SpiritHelper.figureOutType(spirit);
            MalumHelper.giveItemToEntity(new ItemStack((IItemProvider)spiritType.splinterItem(), count), attacker);
            spirits.set(i, (Pair<String, Integer>)Pair.of((Object)spirit, (Object)0));
        }
    }

    public static MalumSpiritType figureOutType(String spirit) {
        if (spirit.equals("holy")) {
            return MalumSpiritTypes.SACRED_SPIRIT;
        }
        ArrayList type = (ArrayList)MalumSpiritTypes.SPIRITS.stream().filter(s -> s.identifier.equals(spirit)).collect(Collectors.toList());
        if (type.isEmpty()) {
            throw new RuntimeException("Somehow, an invalid spirit identifier was found. 'Why?' is a good question my friend. Incorrect identifier: " + spirit);
        }
        return (MalumSpiritType)type.get(0);
    }

    public static int totalSpirits(LivingEntity entity) {
        return SpiritHelper.entitySpirits(entity).stream().mapToInt(ItemStack::func_190916_E).sum();
    }

    public static ArrayList<ItemStack> entitySpirits(LivingEntity entity) {
        ArrayList<ItemStack> spirits = new ArrayList<ItemStack>();
        for (MalumSpiritType type : MalumSpiritTypes.SPIRITS) {
            int count = type.spiritCount(entity);
            if (count == 0) continue;
            spirits.add(new ItemStack((IItemProvider)type.splinterItem(), count));
        }
        return spirits;
    }

    public static void spiritParticles(World world, double x, double y, double z, Color color) {
        Random rand = world.field_73012_v;
        ParticleManager.create(MalumParticles.TWINKLE_PARTICLE).setAlpha(0.18f, 0.0f).setLifetime(10 + rand.nextInt(4)).setScale(0.3f + rand.nextFloat() * 0.1f, 0.0f).setColor(color, color.darker()).randomOffset(0.05f).enableNoClip().randomVelocity(0.02f, 0.02f).repeat(world, x, y, z, 1);
        ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(20 + rand.nextInt(4)).setSpin(MathHelper.func_151240_a((Random)rand, (float)0.05f, (float)0.1f)).setScale(0.2f + rand.nextFloat() * 0.05f, 0.0f).setColor(color, color.darker()).randomOffset(0.1f).enableNoClip().randomVelocity(0.02f, 0.02f).repeat(world, x, y, z, 1);
        ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.2f, 0.0f).setLifetime(10 + rand.nextInt(2)).setSpin(MathHelper.func_151240_a((Random)rand, (float)0.05f, (float)0.1f)).setScale(0.15f + rand.nextFloat() * 0.05f, 0.0f).setColor(color, color.darker()).enableNoClip().randomVelocity(0.01f, 0.01f).repeat(world, x, y, z, 1);
    }
}

