/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.network;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.core.init.particles.MalumParticles;
import com.sammy.malum.core.systems.particles.ParticleManager;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.core.systems.spirits.SpiritHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PacketEffects {
    public static void altarConsumeParticles(ItemStack stack, ArrayList<String> spirits, double posX, double posY, double posZ, double altarPosX, double altarPosY, double altarPosZ) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ArrayList<MalumSpiritType> types = new ArrayList<MalumSpiritType>();
        for (String string : spirits) {
            types.add(SpiritHelper.figureOutType(string));
        }
        for (int i = 0; i < 10; ++i) {
            float itemPosX = (float)(posX + (double)MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.1f, (float)0.1f));
            float itemPosY = (float)(posY + (double)MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.1f, (float)0.1f));
            float itemPosZ = (float)(posZ + (double)MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.1f, (float)0.1f));
            float velocityX = MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.02f, (float)0.02f);
            float velocityY = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.01f, (float)0.04f);
            float velocityZ = MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.02f, (float)0.02f);
            world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), (double)itemPosX, (double)itemPosY, (double)itemPosZ, (double)velocityX, (double)velocityY, (double)velocityZ);
        }
        for (MalumSpiritType type : types) {
            Color color = type.color;
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(60).setScale(0.4f, 0.0f).setColor(color, color.darker()).randomOffset(0.25, 0.1f).randomVelocity(0.004f, 0.004f).enableNoClip().repeat((World)world, posX, posY, posZ, 12);
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.05f, 0.0f).setLifetime(30).setScale(0.2f, 0.0f).setColor(color, color.darker()).randomOffset(0.05f, 0.05f).randomVelocity(0.002f, 0.002f).enableNoClip().repeat((World)world, posX, posY, posZ, 8);
            Vector3d velocity = new Vector3d(posX, posY, posZ).func_178786_a(altarPosX, altarPosY, altarPosZ).func_72432_b().func_186678_a((double)-0.05f);
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.15f, 0.0f).setLifetime(40).setScale(0.3f, 0.0f).randomOffset(0.15f).randomVelocity(0.005f, 0.005f).setColor(color, color.darker()).addVelocity(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c).enableNoClip().repeat((World)world, posX, posY, posZ, 36);
        }
    }

    public static void altarCraftParticles(ArrayList<String> spirits, double posX, double posY, double posZ) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ArrayList<MalumSpiritType> types = new ArrayList<MalumSpiritType>();
        for (String string : spirits) {
            types.add(SpiritHelper.figureOutType(string));
        }
        for (MalumSpiritType type : types) {
            Color color = type.color;
            ParticleManager.create(MalumParticles.TWINKLE_PARTICLE).setAlpha(0.6f, 0.0f).setLifetime(80).setScale(0.15f, 0.0f).setColor(color, color.darker()).randomOffset(0.1f).addVelocity(0.0, 0.13f, 0.0).randomVelocity(0.03f, 0.08f).enableGravity().repeat((World)world, posX, posY, posZ, 24);
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(60).setScale(0.4f, 0.0f).setColor(color, color.darker()).randomOffset(0.25, 0.1f).randomVelocity(0.004f, 0.004f).enableNoClip().repeat((World)world, posX, posY, posZ, 12);
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.05f, 0.0f).setLifetime(30).setScale(0.2f, 0.0f).setColor(color, color.darker()).randomOffset(0.05f, 0.05f).randomVelocity(0.002f, 0.002f).enableNoClip().repeat((World)world, posX, posY, posZ, 8);
        }
    }

    public static void spiritEngrave(String spirit, BlockPos pos) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MalumSpiritType type = SpiritHelper.figureOutType(spirit);
        Color color = MalumHelper.brighter(type.color, 3);
        ParticleManager.create(MalumParticles.SMOKE_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(15).setSpin(0.2f).setScale(0.5f, 0.0f).setColor(color, color).enableNoClip().randomOffset(0.3f, 0.3f).randomVelocity(0.001f, 0.001f).evenlyRepeatEdges((World)world, pos, 4);
        PacketEffects.totemBlockParticles(spirit, pos, true);
    }

    public static void totemBlockParticles(String spirit, BlockPos pos, boolean success) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MalumSpiritType type = SpiritHelper.figureOutType(spirit);
        Color color = type.color;
        if (!success) {
            color = color.darker();
        }
        ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.05f, 0.0f).setLifetime(20).setSpin(0.2f).setScale(0.2f, 0.0f).setColor(color, color).enableNoClip().randomOffset(0.1f, 0.1f).randomVelocity(0.001f, 0.001f).evenlyRepeatEdges((World)world, pos, 40);
        ParticleManager.create(MalumParticles.SMOKE_PARTICLE).setAlpha(0.025f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.4f, 0.0f).setColor(color, color).randomOffset(0.2f).enableNoClip().randomVelocity(0.001f, 0.001f).evenlyRepeatEdges((World)world, pos, 60);
    }

    public static void totemParticles(ArrayList<String> spirits, BlockPos pos, boolean success) {
        for (int i = 0; i < spirits.size(); ++i) {
            PacketEffects.totemBlockParticles(spirits.get(i), pos.func_177981_b(1 + i), success);
        }
    }

    public static void upwardsBlockParticles(String spirit, BlockPos pos) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MalumSpiritType type = SpiritHelper.figureOutType(spirit);
        Color color = type.color;
        ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.05f, 0.0f).setLifetime(20).setSpin(0.2f).setScale(0.2f, 0.0f).setColor(color, color).enableNoClip().randomOffset(0.1f, 0.1f).randomVelocity(0.001f, 0.001f).addVelocity(0.0, 0.02f, 0.0).evenlyRepeatEdges((World)world, pos, 40);
        ParticleManager.create(MalumParticles.SMOKE_PARTICLE).setAlpha(0.025f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.4f, 0.0f).setColor(color, color).randomOffset(0.2f).enableNoClip().randomVelocity(0.001f, 0.001f).addVelocity(0.0, 0.02f, 0.0).evenlyRepeatEdges((World)world, pos, 60);
    }

    public static void upwardsBlockParticles(ArrayList<String> spirits, BlockPos pos) {
        for (String spirit : spirits) {
            PacketEffects.upwardsBlockParticles(spirit, pos);
        }
    }

    public static void altBurstParticles(String spirit, Vector3d pos, float multiplier) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MalumSpiritType type = SpiritHelper.figureOutType(spirit);
        Color color = type.color;
        ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.1f * multiplier, 0.0f).setLifetime(10).setSpin(0.4f).setScale(0.3f, 0.0f).setColor(color, color.darker()).enableNoClip().randomOffset(0.2f, 0.2f).randomVelocity(0.01f, 0.01f).repeat((World)world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 12);
        ParticleManager.create(MalumParticles.SMOKE_PARTICLE).setAlpha(0.05f * multiplier, 0.0f).setLifetime(20).setSpin(0.1f).setScale(0.4f, 0.0f).setColor(color, color.darker()).randomOffset(0.4f).enableNoClip().randomVelocity(0.025f, 0.025f).repeat((World)world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 20);
    }

    public static void altBurstParticles(ArrayList<String> spirits, Vector3d pos) {
        for (String spirit : spirits) {
            PacketEffects.altBurstParticles(spirit, pos, 1.0f / (float)spirits.size());
        }
    }

    public static void burstParticles(String spirit, Vector3d pos, float multiplier) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MalumSpiritType type = SpiritHelper.figureOutType(spirit);
        Color color = type.color;
        ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.1f * multiplier, 0.0f).setLifetime(10).setSpin(0.4f).setScale(0.4f, 0.0f).setColor(color, color.darker()).enableNoClip().randomOffset(0.2f, 0.2f).randomVelocity(0.01f, 0.01f).repeat((World)world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 12);
        ParticleManager.create(MalumParticles.SMOKE_PARTICLE).setAlpha(0.05f * multiplier, 0.0f).setLifetime(20).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, color.darker()).randomOffset(0.4f).enableNoClip().randomVelocity(0.025f, 0.025f).repeat((World)world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 20);
    }

    public static void burstParticles(ArrayList<String> spirits, Vector3d pos) {
        for (String spirit : spirits) {
            PacketEffects.burstParticles(spirit, pos, 1.0f / (float)spirits.size());
        }
    }
}

