/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.network.packets.particle;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.network.PacketEffects;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpwardsFromBlockParticlesPacket {
    ArrayList<String> spirits;
    int posX;
    int posY;
    int posZ;

    public static UpwardsFromBlockParticlesPacket fromSpirits(int posX, int posY, int posZ, MalumSpiritType ... spirits) {
        return UpwardsFromBlockParticlesPacket.fromSpirits(posX, posY, posZ, MalumHelper.toArrayList(spirits));
    }

    public static UpwardsFromBlockParticlesPacket fromSpirits(int posX, int posY, int posZ, ArrayList<MalumSpiritType> spirits) {
        ArrayList<String> strings = new ArrayList<String>();
        for (MalumSpiritType type : spirits) {
            strings.add(type.identifier);
        }
        return new UpwardsFromBlockParticlesPacket(strings, posX, posY, posZ);
    }

    public UpwardsFromBlockParticlesPacket(ArrayList<String> spirits, int posX, int posY, int posZ) {
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static UpwardsFromBlockParticlesPacket decode(PacketBuffer buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.func_218666_n());
        }
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        return new UpwardsFromBlockParticlesPacket(spirits, posX, posY, posZ);
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.func_180714_a(string);
        }
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
    }

    public void whenThisPacketIsReceived(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketEffects.upwardsBlockParticles(this.spirits, new BlockPos(this.posX, this.posY, this.posZ)));
        context.get().setPacketHandled(true);
    }
}

