/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.network.packets.particle.altar;

import com.sammy.malum.core.systems.recipes.SpiritIngredient;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.network.PacketEffects;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpiritAltarConsumeParticlePacket {
    ItemStack stack;
    ArrayList<String> spirits;
    double posX;
    double posY;
    double posZ;
    double altarPosX;
    double altarPosY;
    double altarPosZ;

    public static SpiritAltarConsumeParticlePacket fromIngredients(ItemStack stack, ArrayList<SpiritIngredient> spiritIngredients, double posX, double posY, double posZ, double altarPosX, double altarPosY, double altarPosZ) {
        ArrayList<String> spirits = new ArrayList<String>();
        for (SpiritIngredient ingredient : spiritIngredients) {
            spirits.add(ingredient.type.identifier);
        }
        return new SpiritAltarConsumeParticlePacket(stack, spirits, posX, posY, posZ, altarPosX, altarPosY, altarPosZ);
    }

    public static SpiritAltarConsumeParticlePacket fromSpirits(ItemStack stack, ArrayList<MalumSpiritType> spiritTypes, double posX, double posY, double posZ, double altarPosX, double altarPosY, double altarPosZ) {
        ArrayList<String> spirits = new ArrayList<String>();
        for (MalumSpiritType spirit : spiritTypes) {
            spirits.add(spirit.identifier);
        }
        return new SpiritAltarConsumeParticlePacket(stack, spirits, posX, posY, posZ, altarPosX, altarPosY, altarPosZ);
    }

    public SpiritAltarConsumeParticlePacket(ItemStack stack, ArrayList<String> spirits, double posX, double posY, double posZ, double altarPosX, double altarPosY, double altarPosZ) {
        this.stack = stack;
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.altarPosX = altarPosX;
        this.altarPosY = altarPosY;
        this.altarPosZ = altarPosZ;
    }

    public static SpiritAltarConsumeParticlePacket decode(PacketBuffer buf) {
        ItemStack stack = buf.func_150791_c();
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.func_218666_n());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double altarPosX = buf.readDouble();
        double altarPosY = buf.readDouble();
        double altarPosZ = buf.readDouble();
        return new SpiritAltarConsumeParticlePacket(stack, spirits, posX, posY, posZ, altarPosX, altarPosY, altarPosZ);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.func_180714_a(string);
        }
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.altarPosX);
        buf.writeDouble(this.altarPosY);
        buf.writeDouble(this.altarPosZ);
    }

    public void whenThisPacketIsReceived(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketEffects.altarConsumeParticles(this.stack, this.spirits, this.posX, this.posY, this.posZ, this.altarPosX, this.altarPosY, this.altarPosZ));
        context.get().setPacketHandled(true);
    }
}

