/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.measurements.ItemRegistry;
import com.mrbysco.measurements.client.MeasurementBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientHandler {
    private static final List<MeasurementBox> boxList = new ArrayList<MeasurementBox>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K) {
            RayTraceResult rayHit;
            MeasurementBox lastBox;
            PlayerEntity player = event.player;
            if (player.func_184614_ca().func_77973_b() != ItemRegistry.TAPE_MEASURE_ITEM.get()) {
                return;
            }
            if (boxList.size() > 0 && !(lastBox = boxList.get(boxList.size() - 1)).isFinished() && (rayHit = Minecraft.func_71410_x().field_71476_x) != null && rayHit.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockHitResult = (BlockRayTraceResult)rayHit;
                lastBox.setBlockEnd(new BlockPos((Vector3i)blockHitResult.func_216350_a()));
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.func_184614_ca().func_77973_b() != ItemRegistry.TAPE_MEASURE_ITEM.get()) {
            return;
        }
        RegistryKey currentDimension = player.field_70170_p.func_234923_W_();
        Minecraft minecraft = Minecraft.func_71410_x();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        MatrixStack matrixStack = event.getMatrixStack();
        RenderTypeBuffers renderTypeBuffer = minecraft.func_228019_au_();
        ActiveRenderInfo camera = minecraft.field_71460_t.func_215316_n();
        boxList.forEach(box -> box.render((RegistryKey<World>)currentDimension, matrixStack, renderTypeBuffer, camera, projectionMatrix));
    }

    public static ActionResultType addBox(PlayerEntity playerEntity, BlockRayTraceResult hitResult) {
        if (playerEntity.func_225608_bj_()) {
            ClientHandler.undo();
            return ActionResultType.FAIL;
        }
        BlockPos block = hitResult.func_216350_a();
        if (boxList.size() > 0) {
            MeasurementBox lastBox = boxList.get(boxList.size() - 1);
            if (lastBox.isFinished()) {
                MeasurementBox box = new MeasurementBox(block, (RegistryKey<World>)playerEntity.field_70170_p.func_234923_W_());
                boxList.add(box);
            } else {
                lastBox.setBlockEnd(block);
                lastBox.setFinished();
            }
        } else {
            MeasurementBox box = new MeasurementBox(block, (RegistryKey<World>)playerEntity.field_70170_p.func_234923_W_());
            boxList.add(box);
        }
        return ActionResultType.FAIL;
    }

    public static void undo() {
        if (boxList.size() > 0) {
            boxList.remove(boxList.size() - 1);
        }
    }

    public static void clear() {
        boxList.clear();
    }
}

