/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrbysco.measurements.client.LineRenderType;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MeasurementBox {
    private final BlockPos startPos;
    private BlockPos endPos;
    public AxisAlignedBB box;
    private final RegistryKey<World> dimensionKey;
    private boolean finished;
    private final DyeColor color;

    MeasurementBox(BlockPos block, RegistryKey<World> dimensionKey) {
        this.startPos = block;
        this.endPos = block;
        this.dimensionKey = dimensionKey;
        this.finished = false;
        this.color = DyeColor.YELLOW;
        this.setBoundingBox();
    }

    private void setBoundingBox() {
        int ax = this.startPos.func_177958_n();
        int ay = this.startPos.func_177956_o();
        int az = this.startPos.func_177952_p();
        int bx = this.endPos.func_177958_n();
        int by = this.endPos.func_177956_o();
        int bz = this.endPos.func_177952_p();
        this.box = new AxisAlignedBB((double)Math.min(ax, bx), (double)Math.min(ay, by), (double)Math.min(az, bz), (double)(Math.max(ax, bx) + 1), (double)(Math.max(ay, by) + 1), (double)(Math.max(az, bz) + 1));
    }

    public void setBlockEnd(BlockPos blockEnd) {
        this.endPos = blockEnd;
        this.setBoundingBox();
    }

    public void render(RegistryKey<World> currentDimensionKey, MatrixStack matrixStack, RenderTypeBuffers buffer, ActiveRenderInfo renderInfo, Matrix4f projection) {
        if (!this.dimensionKey.func_240901_a_().equals((Object)currentDimensionKey.func_240901_a_())) {
            return;
        }
        float[] color = this.color.func_193349_f();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        float a = 0.95f;
        Vector3d pos = renderInfo.func_216785_c();
        double distance = this.box.func_189972_c().func_72438_d(pos);
        float lineWidth = 2.0f;
        if (distance > 48.0) {
            lineWidth = 1.0f;
        }
        matrixStack.func_227860_a_();
        IVertexBuilder builder = buffer.func_228487_b_().getBuffer(LineRenderType.lineRenderType(lineWidth));
        matrixStack.func_227861_a_(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)builder, (AxisAlignedBB)this.box, (float)r, (float)g, (float)b, (float)0.95f);
        matrixStack.func_227865_b_();
        this.drawLength(matrixStack, buffer, renderInfo, projection);
    }

    private void drawLength(MatrixStack matrixStack, RenderTypeBuffers buffers, ActiveRenderInfo renderInfo, Matrix4f projection) {
        int lengthX = (int)this.box.func_216364_b();
        int lengthY = (int)this.box.func_216360_c();
        int lengthZ = (int)this.box.func_216362_d();
        Vector3d pos = renderInfo.func_216785_c();
        ClippingHelper clippingHelper = new ClippingHelper(matrixStack.func_227866_c_().func_227870_a_(), projection);
        clippingHelper.func_228952_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        AxisAlignedBB boxT = this.box.func_186662_g((double)0.08f);
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72338_b, boxT.field_72339_c, boxT.field_72340_a, boxT.field_72338_b, boxT.field_72334_f), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72337_e, boxT.field_72339_c, boxT.field_72340_a, boxT.field_72337_e, boxT.field_72334_f), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72336_d, boxT.field_72338_b, boxT.field_72339_c, boxT.field_72336_d, boxT.field_72338_b, boxT.field_72334_f), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72336_d, boxT.field_72337_e, boxT.field_72339_c, boxT.field_72336_d, boxT.field_72337_e, boxT.field_72334_f), pos, clippingHelper));
        Collections.sort(lines);
        Vector3d lineZ = ((Line)lines.get((int)0)).line.func_189972_c();
        lines.clear();
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72338_b, boxT.field_72339_c, boxT.field_72340_a, boxT.field_72337_e, boxT.field_72339_c), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72338_b, boxT.field_72334_f, boxT.field_72340_a, boxT.field_72337_e, boxT.field_72334_f), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72336_d, boxT.field_72338_b, boxT.field_72339_c, boxT.field_72336_d, boxT.field_72337_e, boxT.field_72339_c), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72336_d, boxT.field_72338_b, boxT.field_72334_f, boxT.field_72336_d, boxT.field_72337_e, boxT.field_72334_f), pos, clippingHelper));
        Collections.sort(lines);
        Vector3d lineY = ((Line)lines.get((int)0)).line.func_189972_c();
        lines.clear();
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72338_b, boxT.field_72339_c, boxT.field_72336_d, boxT.field_72338_b, boxT.field_72339_c), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72338_b, boxT.field_72334_f, boxT.field_72336_d, boxT.field_72338_b, boxT.field_72334_f), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72337_e, boxT.field_72339_c, boxT.field_72336_d, boxT.field_72337_e, boxT.field_72339_c), pos, clippingHelper));
        lines.add(new Line(new AxisAlignedBB(boxT.field_72340_a, boxT.field_72337_e, boxT.field_72334_f, boxT.field_72336_d, boxT.field_72337_e, boxT.field_72334_f), pos, clippingHelper));
        Collections.sort(lines);
        Vector3d lineX = ((Line)lines.get((int)0)).line.func_189972_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c);
        this.drawText(matrixStack, buffers, renderInfo, new Vector3d(lineX.field_72450_a, lineX.field_72448_b, lineX.field_72449_c), String.valueOf(lengthX));
        this.drawText(matrixStack, buffers, renderInfo, new Vector3d(lineY.field_72450_a, lineY.field_72448_b, lineY.field_72449_c), String.valueOf(lengthY));
        this.drawText(matrixStack, buffers, renderInfo, new Vector3d(lineZ.field_72450_a, lineZ.field_72448_b, lineZ.field_72449_c), String.valueOf(lengthZ));
        matrixStack.func_227865_b_();
    }

    private void drawText(MatrixStack matrixStack, RenderTypeBuffers buffers, ActiveRenderInfo renderInfo, Vector3d pos, String length) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float size = 0.02f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(pos.field_72450_a, pos.field_72448_b + 0.09999999776482582, pos.field_72449_c);
        matrixStack.func_227863_a_(renderInfo.func_227995_f_());
        matrixStack.func_227862_a_(-0.02f, -0.02f, -0.02f);
        matrixStack.func_227861_a_((double)((float)(-font.func_78256_a(length)) / 2.0f), 0.0, 0.0);
        font.func_228079_a_(length, 0.0f, 0.0f, this.color.func_218388_g(), true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffers.func_228490_d_(), true, this.color.getColorValue(), 0xF000F0);
        matrixStack.func_227865_b_();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    private static class Line
    implements Comparable<Line> {
        AxisAlignedBB line;
        boolean isVisible;
        double distance;

        Line(AxisAlignedBB line, Vector3d pos, ClippingHelper clippingHelper) {
            this.line = line;
            this.isVisible = clippingHelper.func_228957_a_(line);
            this.distance = line.func_189972_c().func_72438_d(pos);
        }

        @Override
        public int compareTo(Line l) {
            if (this.isVisible) {
                return l.isVisible ? Double.compare(this.distance, l.distance) : -1;
            }
            return l.isVisible ? 1 : 0;
        }
    }
}

