/*
 * Decompiled with CFR 0.152.
 */
package com.akoimeexx.mimics.entity;

import com.akoimeexx.mimics.inventory.TieredInventory;
import com.akoimeexx.mimics.screen.MimicScreenHandler;
import com.akoimeexx.mimics.screen.MimicScreenHandlerTypes;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_4801;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import org.jetbrains.annotations.Nullable;

public class MimicEntity
extends class_1321
implements class_5354,
class_3908 {
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(MimicEntity.class, (class_2941)class_2943.field_13327);
    private static final class_4801 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)60);
    @Nullable
    protected static final class_2940<String> FOOD_ITEM = class_2945.method_12791(MimicEntity.class, (class_2941)class_2943.field_13326);
    protected static final class_2940<Integer> TIER = class_2945.method_12791(MimicEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> EXPERIENCE = class_2945.method_12791(MimicEntity.class, (class_2941)class_2943.field_13327);
    private TieredInventory inventory;
    private UUID targetUuid;

    protected MimicEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 15;
        this.method_6173(false);
        this.method_5952(true);
        this.setTier(4);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANGER_TIME, (Object)0);
        this.field_6011.method_12784(FOOD_ITEM, null);
        this.field_6011.method_12784(TIER, (Object)1);
        this.field_6011.method_12784(EXPERIENCE, (Object)0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1359((class_1308)this, 0.5f));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(5, (class_1352)new EatItemGoal());
        this.field_6201.method_6277(8, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f, true));
        this.field_6201.method_6277(9, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((MimicEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    public void method_5749(class_2487 tag) {
        String food;
        super.method_5749(tag);
        this.method_29512((class_3218)this.field_6002, tag);
        if (tag.method_10545("Food") && (food = tag.method_10558("Food")) != null && food.trim() != "") {
            this.setFoodItem(food);
        }
        this.setGainedExperience(tag.method_10550("Experience"));
        this.setTier(tag.method_10550("Tier"));
        this.inventory.fromTag(tag);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.method_29517(tag);
        if (this.getFoodItem() != null && this.getFoodItem().trim() != "") {
            tag.method_10582("Food", this.getFoodItem());
        }
        tag.method_10569("Experience", this.getGainedExperience());
        tag.method_10569("Tier", this.getTier());
        this.inventory.toTag(tag);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        MimicScreenHandler handler;
        switch (this.getTier()) {
            case 2: {
                handler = new MimicScreenHandler(MimicScreenHandlerTypes.MIMIC_SCREEN_HANDLER_9x3, syncId, playerInventory, this, 3);
                break;
            }
            case 3: {
                handler = new MimicScreenHandler(MimicScreenHandlerTypes.MIMIC_SCREEN_HANDLER_9x4, syncId, playerInventory, this, 4);
                break;
            }
            case 4: {
                handler = new MimicScreenHandler(MimicScreenHandlerTypes.MIMIC_SCREEN_HANDLER_9x5, syncId, playerInventory, this, 5);
                break;
            }
            case 5: {
                handler = new MimicScreenHandler(MimicScreenHandlerTypes.MIMIC_SCREEN_HANDLER_9x6, syncId, playerInventory, this, 6);
                break;
            }
            default: {
                handler = new MimicScreenHandler(MimicScreenHandlerTypes.MIMIC_SCREEN_HANDLER_9x2, syncId, playerInventory, this, 2);
            }
        }
        return handler;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int ticks) {
        this.field_6011.method_12778(ANGER_TIME, (Object)ticks);
    }

    public UUID method_29508() {
        return this.targetUuid;
    }

    public void method_29513(UUID uuid) {
        this.targetUuid = uuid;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_24503(this.field_5974));
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_5753() {
        return this.getTier() == 5 ? true : super.method_5753();
    }

    public boolean method_20820(class_1799 stack) {
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    private void eatItemEntity(class_1542 item) {
        if (item != null) {
            int points = Math.max(1, 64 / item.method_6983().method_7914() * item.method_6983().method_7947());
            this.method_6025(points / 8);
            if (this.getTier() < 5) {
                this.setGainedExperience(this.getGainedExperience() + points);
            }
            if (this.getGainedExperience() >= this.getExperiencetoNextTier() && this.getTier() < 5) {
                this.setTier(this.getTier() + 1);
                this.setGainedExperience(0);
            }
            this.method_5783(class_3417.field_19149, 0.15f, 1.0f);
        }
    }

    private int getExperiencetoNextTier() {
        int i = 128;
        return i * Math.max(1, this.getTier());
    }

    @Nullable
    public String getFoodItem() {
        String id = (String)this.field_6011.method_12789(FOOD_ITEM);
        return id != null && id.trim() != "" ? id : null;
    }

    public void setFoodItem(@Nullable String id) {
        this.field_6011.method_12778(FOOD_ITEM, id != null && id.trim() != "" ? id : null);
    }

    public int getGainedExperience() {
        return (Integer)this.field_6011.method_12789(EXPERIENCE);
    }

    public void setGainedExperience(int experience) {
        this.field_6011.method_12778(EXPERIENCE, (Object)experience);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.field_6002.field_9236) {
            return this.method_6171((class_1309)player) || this.method_6181() || !this.method_6181() && !this.method_29511() ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (!this.method_6181() && !this.method_29511()) {
            this.method_29513(player.method_5667());
            this.method_29509();
        } else if (this.method_6181() && this.method_6139().equals(player.method_5667())) {
            if (player.method_5715() && ((class_3222)player).method_5998(hand).method_7960()) {
                class_1799 stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960("mimics:mimic")), 1);
                class_2487 data = new class_2487();
                this.method_5652(data);
                class_2487 itemData = new class_2487();
                itemData.method_10566("MimicData", (class_2520)data);
                stack.method_7980(itemData);
                player.method_6122(hand, stack);
                this.method_5650();
                return class_1269.field_5812;
            }
            player.method_17355((class_3908)this);
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public TieredInventory getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return 9 + 9 * this.getTier();
    }

    public boolean canPlayerUse(class_1657 player) {
        return !this.field_5988 && player.method_5858((class_1297)this) <= 64.0;
    }

    private class_238 getItemDetectionRange() {
        return this.method_5829().method_1009(16.0, 8.0, 16.0);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_15053, 0.15f, 1.0f);
    }

    public void method_5650() {
        if (!this.field_6002.field_9236 && this.field_6272) {
            class_1264.method_5452((class_1937)this.field_6002, (class_1297)this, (class_1263)this.inventory);
        }
        super.method_5650();
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.setTier(1);
        } else {
            this.setTier(4);
        }
    }

    public int getTier() {
        return (Integer)this.field_6011.method_12789(TIER);
    }

    public void setTier(int tier) {
        this.field_6011.method_12778(TIER, (Object)Math.max(1, Math.min(5, tier)));
        TieredInventory i = new TieredInventory(9, 9, this.getTier());
        if (this.inventory != null) {
            for (int index = 0; index < this.inventory.method_5439(); ++index) {
                i.addToInventory(this.inventory.method_5438(index));
            }
        }
        this.inventory = i;
    }

    public void method_5865(class_1297 passenger) {
        super.method_5865(passenger);
        passenger.method_5814(passenger.method_23317(), passenger.method_23318() - 0.175, passenger.method_23321());
        if (passenger instanceof class_1321) {
            ((class_1321)passenger).method_24346(true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.4f * this.method_5751()), 0.0);
    }

    public static class_5132.class_5133 createMimicAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23718, 0.2).method_26868(class_5134.field_23721, 10.0);
    }

    class EatItemGoal
    extends class_1352 {
        public EatItemGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!MimicEntity.this.method_5936()) {
                return false;
            }
            List list = MimicEntity.this.field_6002.method_8390(class_1542.class, MimicEntity.this.getItemDetectionRange(), itemEntity -> this.isValidTarget((class_1542)itemEntity));
            if (!list.isEmpty()) {
                for (class_1542 item : list) {
                    if (!MimicEntity.this.method_6057((class_1297)item) || !MimicEntity.this.inventory.canInsert(item.method_6983())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isValidTarget(class_1542 target) {
            return !target.method_6977() && target.method_5805() && (!MimicEntity.this.method_6181() || target.method_6978() == null || target.method_6978().equals(MimicEntity.this.method_6139()));
        }

        public void method_6269() {
            List list = MimicEntity.this.field_6002.method_8390(class_1542.class, MimicEntity.this.getItemDetectionRange(), itemEntity -> this.isValidTarget((class_1542)itemEntity));
            if (!list.isEmpty()) {
                class_1542 target = null;
                for (class_1542 item : list) {
                    if (!MimicEntity.this.method_6057((class_1297)item) || !MimicEntity.this.inventory.canInsert(item.method_6983())) continue;
                    target = item;
                    break;
                }
                if (target != null) {
                    MimicEntity.this.method_5942().method_6335(target, (double)1.2f);
                }
            }
        }

        public void method_6268() {
            List list = MimicEntity.this.field_6002.method_8390(class_1542.class, MimicEntity.this.method_5829().method_1009(1.0, 8.0, 1.0), itemEntity -> this.isValidTarget((class_1542)itemEntity));
            if (!list.isEmpty()) {
                for (class_1542 item : list) {
                    if (item.method_6983().method_7909().toString() == MimicEntity.this.getFoodItem()) {
                        MimicEntity.this.eatItemEntity(item);
                        item.method_5768();
                        continue;
                    }
                    if (!MimicEntity.this.inventory.canInsert(item.method_6983())) continue;
                    MimicEntity.this.inventory.addToInventory(item.method_6983());
                    item.method_5768();
                }
            } else {
                list = MimicEntity.this.field_6002.method_8390(class_1542.class, MimicEntity.this.getItemDetectionRange(), itemEntity -> this.isValidTarget((class_1542)itemEntity));
                if (!list.isEmpty()) {
                    class_1542 target = null;
                    for (class_1542 item : list) {
                        if (!MimicEntity.this.method_6057((class_1297)item) || !MimicEntity.this.inventory.canInsert(item.method_6983())) continue;
                        target = item;
                        break;
                    }
                    if (target != null) {
                        MimicEntity.this.method_5942().method_6335(target, (double)1.2f);
                    }
                }
            }
        }
    }
}

