/*
 * Decompiled with CFR 0.152.
 */
package com.akoimeexx.mimics.inventory;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;

public class TieredInventory
implements class_1263 {
    private int base;
    private int slotsPerTier;
    private int tier;
    private class_2371<class_1799> inventory;
    private List<class_1265> listeners;

    public TieredInventory() {
        this(9);
    }

    public TieredInventory(int base) {
        this(base, base);
    }

    public TieredInventory(int base, int slotsPerTier) {
        this(base, slotsPerTier, 0);
    }

    public TieredInventory(int base, int slotsPerTier, int currentTier) {
        this.base = base;
        this.slotsPerTier = slotsPerTier;
        this.tier = currentTier;
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    }

    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    public int method_5439() {
        return this.base + this.slotsPerTier * this.getTier();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator iterator = this.inventory.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)iterator.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.method_5439() ? (class_1799)this.inventory.get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.inventory.set(slot, (Object)class_1799.field_8037);
        this.method_5431();
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public void method_5431() {
        if (this.listeners != null) {
            for (class_1265 listener : this.listeners) {
                listener.method_5453((class_1263)this);
            }
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    private boolean canCombine(class_1799 comparator, class_1799 comparand) {
        return comparator.method_7909() == comparand.method_7909() && class_1799.method_7975((class_1799)comparator, (class_1799)comparand);
    }

    public boolean canInsert(class_1799 stack) {
        boolean b = false;
        Iterator iterator = this.inventory.iterator();
        while (iterator.hasNext() && !b) {
            class_1799 itemStack = (class_1799)iterator.next();
            b = itemStack.method_7960() || this.canCombine(itemStack, stack) && itemStack.method_7947() < itemStack.method_7914();
        }
        return b;
    }

    public void addToInventory(class_1799 stack) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (this.canCombine(itemStack, stack)) {
                this.transfer(stack, itemStack);
                if (!stack.method_7960()) continue;
                this.method_5431();
                return;
            }
            if (!itemStack.method_7960()) continue;
            this.method_5447(i, stack.method_7972());
            stack.method_7939(0);
            this.method_5431();
            return;
        }
    }

    private void transfer(class_1799 source, class_1799 target) {
        int transferAmount = Math.min(source.method_7947(), Math.min(this.method_5444(), target.method_7914()) - target.method_7947());
        if (transferAmount > 0) {
            target.method_7933(transferAmount);
            source.method_7934(transferAmount);
            this.method_5431();
        }
    }

    public class_1799 removeItem(class_1792 item, int count) {
        class_1799 targetItems = new class_1799((class_1935)item, 0);
        for (int i = this.method_5439() - 1; i >= 0; --i) {
            class_1799 inventoryStack = this.method_5438(i);
            if (!inventoryStack.method_7909().equals(item)) continue;
            int j = count - targetItems.method_7947();
            class_1799 itemStack3 = inventoryStack.method_7971(j);
            targetItems.method_7933(itemStack3.method_7947());
            if (targetItems.method_7947() == count) break;
        }
        if (!targetItems.method_7960()) {
            this.method_5431();
        }
        return targetItems;
    }

    public void addListener(class_1265 listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(class_1265 listener) {
        this.listeners.remove(listener);
    }

    public void fromTag(class_2487 tag) {
        class_1262.method_5429((class_2487)tag, this.inventory);
    }

    public void toTag(class_2487 tag) {
        if (this.inventory != null) {
            class_1262.method_5426((class_2487)tag, this.inventory);
        }
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        if (tier >= 0) {
            this.tier = tier;
            this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
    }
}

