/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.api;

import com.miskatonicmysteries.api.interfaces.Affiliated;
import com.miskatonicmysteries.api.interfaces.Ascendant;
import com.miskatonicmysteries.api.interfaces.MalleableAffiliated;
import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.Blessing;
import com.miskatonicmysteries.common.feature.world.MMDimensionalWorldState;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMCriteria;
import com.miskatonicmysteries.common.registry.MMRegistries;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MiskatonicMysteriesAPI {
    public static final class_2941<Affiliation> AFFILIATION_TRACKER = new class_2941<Affiliation>(){

        public void write(class_2540 packetByteBuf, Affiliation affiliation) {
            packetByteBuf.method_10812(affiliation.getId());
        }

        public Affiliation read(class_2540 packetByteBuf) {
            class_2960 id = packetByteBuf.method_10810();
            return MMRegistries.AFFILIATIONS.method_10235().contains(id) ? (Affiliation)MMRegistries.AFFILIATIONS.method_10223(id) : MMAffiliations.NONE;
        }

        public Affiliation copy(Affiliation affiliation) {
            return affiliation;
        }
    };

    public static Affiliation getNonNullAffiliation(Object obj, boolean apparent) {
        return Affiliated.of(obj).map(affiliated -> affiliated.getAffiliation(apparent)).orElse(MMAffiliations.NONE);
    }

    public static Affiliation getApparentAffiliationFromEquipment(@Nullable class_1799 exclude, class_1657 player) {
        class_1263 trinkets = TrinketsApi.getTrinketsInventory((class_1657)player);
        for (int i = 0; i < trinkets.method_5439(); ++i) {
            class_1799 stack = trinkets.method_5438(i);
            if (stack.equals(exclude) || !(stack.method_7909() instanceof Affiliated)) continue;
            return ((Affiliated)stack.method_7909()).getAffiliation(true);
        }
        return MMAffiliations.NONE;
    }

    public static void resetProgress(class_1657 player) {
        if (player.field_6002 instanceof class_3218) {
            Sanity.of(player).ifPresent(sanity -> {
                sanity.getSanityCapExpansions().keySet().forEach(sanity::removeSanityCapExpansion);
                sanity.setSanity(sanity.getMaxSanity(), true);
                sanity.setShocked(true);
                sanity.syncSanityData();
            });
            Ascendant.of(player).ifPresent(ascendant -> {
                ascendant.setAscensionStage(0);
                ascendant.getBlessings().clear();
                ascendant.syncBlessingData();
            });
            SpellCaster.of(player).ifPresent(caster -> {
                caster.getSpells().clear();
                caster.getLearnedMediums().clear();
                caster.getLearnedEffects().clear();
                caster.setMaxSpells(3);
                caster.setPowerPool(0);
                caster.syncSpellData();
            });
            MalleableAffiliated.of(player).ifPresent(malleableAffiliated -> {
                malleableAffiliated.setAffiliation(MMAffiliations.NONE, true);
                malleableAffiliated.setAffiliation(MMAffiliations.NONE, false);
            });
        }
    }

    public static boolean hasBlessing(Ascendant ascendant, Blessing blessing) {
        return ascendant.getBlessings().contains(blessing);
    }

    public static boolean levelUp(class_1657 player, int stage, Affiliation affiliation) {
        Optional<Ascendant> ascendant = Ascendant.of(player);
        Optional<MalleableAffiliated> affiliated = MalleableAffiliated.of(player);
        if (ascendant.isPresent() && affiliated.isPresent() && MiskatonicMysteriesAPI.canLevelUp(ascendant.get(), affiliated.get(), stage, affiliation)) {
            ascendant.ifPresent(a -> a.setAscensionStage(stage));
            affiliated.ifPresent(a -> a.setAffiliation(affiliation, false));
            SpellCaster.of(player).ifPresent(caster -> {
                caster.setMaxSpells(caster.getMaxSpells() + player.method_6051().nextInt(2));
                caster.setPowerPool(caster.getPowerPool() + 1 + player.method_6051().nextInt(2));
            });
            if (player instanceof class_3222) {
                MMCriteria.LEVEL_UP.trigger((class_3222)player, affiliation, stage);
            }
            return true;
        }
        return false;
    }

    public static boolean canLevelUp(Ascendant ascendant, Affiliated affiliated, int stage, Affiliation affiliation) {
        if (ascendant.getAscensionStage() < stage - 1 || ascendant.getAscensionStage() >= stage) {
            return false;
        }
        return affiliated.getAffiliation(false) == affiliation || stage - 1 <= 0;
    }

    public static int getAscensionStage(Object object) {
        Optional<Ascendant> ascendant = Ascendant.of(object);
        return ascendant.map(Ascendant::getAscensionStage).orElse(0);
    }

    public static void guaranteeSpellPower(int power, SpellCaster caster) {
        if (caster.getPowerPool() < power) {
            caster.setPowerPool(power);
        }
    }

    public static boolean isDefiniteAffiliated(Object object) {
        return Affiliated.of(object).isPresent() && Affiliated.of(object).get().getAffiliation(false) != MMAffiliations.NONE && Affiliated.of(object).get().isSupernatural();
    }

    public static boolean isImmuneToYellowSign(class_1309 entity) {
        return MiskatonicMysteriesAPI.getNonNullAffiliation(entity, false).equals(MMAffiliations.HASTUR) && (!(entity instanceof class_1657) || MiskatonicMysteriesAPI.getAscensionStage(entity) >= 2);
    }

    public static boolean grantBlessing(class_1657 player, Affiliation affiliation) {
        Blessing blessingGranted;
        Ascendant ascendant = Ascendant.of(player).get();
        if (ascendant.getBlessings().size() < 3 && (blessingGranted = affiliation.findRandomBlessing((class_1309)player, ascendant)) != null) {
            ascendant.addBlessing(blessingGranted);
            ascendant.syncBlessingData();
            player.method_7353((class_2561)new class_2588("message.miskatonicmysteries.new_blessing", new Object[]{new class_2588(blessingGranted.getTranslationString())}), true);
            return true;
        }
        return false;
    }

    public static boolean isWardingMarkNearby(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            return MMDimensionalWorldState.get((class_3218)world).isMarkNear(pos, 24);
        }
        return false;
    }
}

