/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.api.item;

import com.miskatonicmysteries.common.block.Shootable;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMSounds;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5251;

public abstract class GunItem
extends class_1792 {
    public GunItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!this.canUse(user)) {
            if (world.field_9236) {
                user.method_7353((class_2561)new class_2588("message.miskatonicmysteries.heavy_gun.needs_offhand"), true);
            }
            return class_1271.method_22431((Object)stack);
        }
        if (user.method_5715()) {
            GunItem.setLoading(stack, true);
            user.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        if (!GunItem.isLoading(stack) && GunItem.isLoaded(stack)) {
            this.shoot(world, (class_1309)user, stack);
            stack.method_7956(1, (class_1309)user, playerEntity -> playerEntity.method_20236(hand));
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)new class_2588(GunItem.isLoaded(stack) ? "tooltip.miskatonicmysteries.gun_loaded" : "tooltip.miskatonicmysteries.gun_not_loaded", new Object[]{stack.method_7969().method_10550("Shots"), this.getMaxShots()}).method_10862(class_2583.field_24360.method_27703(GunItem.isLoaded(stack) ? class_5251.method_27717((int)65280) : class_5251.method_27717((int)0xFF0000))));
        tooltip.add((class_2561)new class_2588("tooltip.miskatonicmysteries.gun_tip_load").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        super.method_7851(stack, world, tooltip, context);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        return GunItem.isLoading(stack) ? this.loadGun(stack, world, user) : stack;
    }

    public static boolean isLoading(class_1799 stack) {
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
            stack.method_7969().method_10556("Loading", false);
            return false;
        }
        return stack.method_7969().method_10577("Loading");
    }

    public static class_1799 setLoading(class_1799 stack, boolean loading) {
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        stack.method_7969().method_10556("Loading", loading);
        return stack;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        stack.method_7969().method_10556("Loading", false);
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public class_1799 loadGun(class_1799 stack, class_1937 world, class_1309 user) {
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        int generatedShots = user instanceof class_1657 && !((class_1657)user).method_7337() ? this.loadBullets((class_1657)user, stack.method_7969().method_10550("Shots")) : this.getMaxShots();
        stack.method_7969().method_10569("Shots", generatedShots);
        GunItem.setLoading(stack, false);
        if (user instanceof class_1657) {
            ((class_1657)user).method_7357().method_7906((class_1792)this, this.getLoadingTime());
        }
        return stack;
    }

    private int loadBullets(class_1657 user, int startCount) {
        class_1799 stack = new class_1799((class_1935)MMObjects.BULLET);
        int bullets = startCount;
        for (int i = 0; i < this.getMaxShots() - startCount; ++i) {
            int slot = user.field_7514.method_7395(stack);
            if (slot < 0) continue;
            user.field_7514.method_5438(slot).method_7934(1);
            ++bullets;
        }
        return bullets;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public abstract int getMaxShots();

    private boolean canUse(class_1657 entity) {
        return !this.isHeavy() || entity.method_6079().method_7960();
    }

    public void shoot(class_1937 world, class_1309 player, class_1799 stack) {
        class_243 vec3d = player.method_5836(1.0f);
        class_243 vec3d2 = player.method_5828(1.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * (double)this.getMaxDistance(), vec3d2.field_1351 * (double)this.getMaxDistance(), vec3d2.field_1350 * (double)this.getMaxDistance());
        class_3965 blockHit = world.method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        double distance = Math.pow(this.getMaxDistance(), 2.0);
        class_3966 hit = class_1675.method_18077((class_1937)world, (class_1297)player, (class_243)vec3d, (class_243)vec3d3, (class_238)player.method_5829().method_18804(vec3d2.method_1021(distance)).method_1009(1.0, 1.0, 1.0), target -> !target.method_7325() && target.method_5863());
        class_2338 blockPos = new class_2338(blockHit.method_17784());
        if (world.method_8320(blockPos).method_26204() instanceof Shootable) {
            ((Shootable)world.method_8320(blockPos).method_26204()).onShot(world, blockPos, player);
        }
        if (hit != null && hit.method_17782() != null && blockHit.method_24801((class_1297)player) > hit.method_17782().method_5858((class_1297)player)) {
            hit.method_17782().method_5643((class_1282)new class_1285("miskatonicmysteries.gun", (class_1297)player), (float)this.getDamage());
            if (world.field_9236) {
                for (int i = 0; i < 4; ++i) {
                    world.method_8406((class_2394)class_2398.field_11251, hit.method_17784().field_1352 + world.field_9229.nextGaussian() / 20.0, hit.method_17784().field_1351 + world.field_9229.nextGaussian() / 20.0, hit.method_17784().field_1350 + world.field_9229.nextGaussian() / 20.0, 0.0, 0.0, 0.0);
                }
            }
        }
        GunItem.setLoading(stack, false);
        stack.method_7969().method_10569("Shots", stack.method_7969().method_10550("Shots") - 1);
        world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), MMSounds.GUN_SHOT, class_3419.field_15248, 0.6f, 1.0f / (field_8005.nextFloat() * 0.2f + (this.isHeavy() ? 1.0f : 0.5f)));
        if (player instanceof class_1657) {
            ((class_1657)player).method_7357().method_7906((class_1792)this, this.getCooldown());
            ((class_1657)player).method_7259(class_3468.field_15372.method_14956((Object)this));
        }
    }

    public static boolean isLoaded(class_1799 stack) {
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        return stack.method_7969().method_10550("Shots") > 0;
    }

    public abstract boolean isHeavy();

    public int method_7881(class_1799 stack) {
        return GunItem.isLoading(stack) ? this.getLoadingTime() : 10;
    }

    public abstract int getLoadingTime();

    public abstract int getCooldown();

    public abstract int getDamage();

    public abstract int getMaxDistance();
}

