/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.api.item;

import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.interfaces.Affiliated;
import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.common.handler.InsanityHandler;
import com.miskatonicmysteries.common.registry.MMSpellEffects;
import com.miskatonicmysteries.common.registry.MMSpellMediums;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class MMBookItem
extends class_1792
implements Affiliated {
    private final class_2960 id;
    private final Affiliation affiliation;
    private final boolean special;

    public MMBookItem(class_2960 id, Affiliation affiliation, boolean special, class_1792.class_1793 settings) {
        super(settings);
        this.id = id;
        this.affiliation = affiliation;
        this.special = special;
    }

    public Book getBook() {
        return (Book)BookRegistry.INSTANCE.books.get(this.id);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        Book book = this.getBook();
        if (player instanceof class_3222) {
            SpellCaster.of(player).ifPresent(caster -> {
                caster.learnMedium(MMSpellMediums.SELF);
                caster.learnEffect(MMSpellEffects.IGNITE);
                MiskatonicMysteriesAPI.guaranteeSpellPower(2, caster);
            });
            if (this.special && !InsanityHandler.hasSanityCapExpansion(player, "readBook")) {
                Sanity.of(player).ifPresent(sanity -> sanity.addSanityCapExpansion("readBook", -10));
            }
            PatchouliAPI.get().openBookGUI((class_3222)player, book.id);
            class_3414 sfx = PatchouliSounds.getSound((class_2960)book.openSound, (class_3414)PatchouliSounds.book_open);
            player.method_5783(sfx, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return class_1271.method_22427((Object)player.method_5998(hand));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        Book book = this.getBook();
        if (book != null && book.contents != null) {
            tooltip.add((class_2561)book.getSubtitle().method_27692(class_124.field_1080));
        }
        if (stack.method_7969() != null && stack.method_7969().method_10545("Knowledge")) {
            tooltip.add((class_2561)new class_2588("knowledge.contains").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            stack.method_7969().method_10554("Knowledge", 8).forEach(s -> tooltip.add((class_2561)new class_2588("knowledge." + s.method_10714())));
        }
    }

    public static class_1799 addKnowledge(String knowledge, class_1799 stack) {
        if (stack.method_7969() == null) {
            stack.method_7980(new class_2487());
        }
        if (!stack.method_7969().method_10545("Knowledge")) {
            stack.method_7969().method_10566("Knowledge", (class_2520)new class_2499());
        }
        stack.method_7969().method_10554("Knowledge", 8).add((Object)class_2519.method_23256((String)knowledge));
        return stack;
    }

    public static boolean hasKnowledge(String knowledge, class_1799 book) {
        return book.method_7969() != null && book.method_7969().method_10545("Knowledge") && book.method_7969().method_10554("Knowledge", 8).stream().anyMatch(tag -> tag.method_10714().equals(knowledge));
    }

    @Override
    public Affiliation getAffiliation(boolean apparent) {
        return this.affiliation;
    }

    @Override
    public boolean isSupernatural() {
        return this.special;
    }
}

