/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.client.compat.rei.entry;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.fractions.Fraction;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class SimpleOctagramEntry
extends RecipeEntry {
    private static final Comparator<EntryStack> ENTRY_COMPARATOR = Comparator.comparingLong(Object::hashCode);
    private List<Slot> inputWidgets;

    protected SimpleOctagramEntry(List<List<EntryStack>> input) {
        this.inputWidgets = SimpleOctagramEntry.simplify(input).stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)stacks).disableBackground().disableHighlight().disableTooltips()).collect(Collectors.toList());
    }

    private static List<List<EntryStack>> simplify(List<List<EntryStack>> original) {
        LinkedHashMap inputCounter = Maps.newLinkedHashMap();
        original.stream().collect(Collectors.groupingBy(stacks -> CollectionUtils.mapAndMax((List)stacks, EntryStack::getAccurateAmount, Fraction::compareTo).orElse(Fraction.empty()))).forEach((fraction, value) -> {
            if (!fraction.equals((Object)Fraction.empty())) {
                value.forEach(stackList -> {
                    List stacks = inputCounter.keySet().stream().filter(s -> SimpleOctagramEntry.equalsList(stackList, s)).findFirst().orElse((List)stackList);
                    AtomicReference reference = inputCounter.computeIfAbsent(stacks, s -> new AtomicReference<Fraction>(Fraction.empty()));
                    reference.set(((Fraction)reference.get()).add(fraction));
                });
            }
        });
        return inputCounter.entrySet().stream().map(entry -> CollectionUtils.map((List)((List)entry.getKey()), stack -> {
            EntryStack s = stack.copy();
            s.setAmount((Fraction)((AtomicReference)entry.getValue()).get());
            return s;
        })).collect(Collectors.toList());
    }

    public static RecipeEntry from(Supplier<List<List<EntryStack>>> input) {
        return SimpleOctagramEntry.from(input.get());
    }

    public static RecipeEntry from(List<List<EntryStack>> input) {
        return new SimpleOctagramEntry(input);
    }

    public static boolean equalsList(List<EntryStack> list_1, List<EntryStack> list_2) {
        List stacks_2;
        List stacks_1 = list_1.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2 = list_2.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList()))) {
            return true;
        }
        if (stacks_1.size() != stacks_2.size()) {
            return false;
        }
        for (int i = 0; i < stacks_1.size(); ++i) {
            if (((EntryStack)stacks_1.get(i)).equalsIgnoreTagsAndAmount((EntryStack)stacks_2.get(i))) continue;
            return false;
        }
        return true;
    }

    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        int xx = bounds.x + 4;
        int yy = bounds.y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (Slot entryWidget : this.inputWidgets) {
            entryWidget.setZ(this.getZ() + 50);
            entryWidget.getBounds().setLocation(xx, yy);
            entryWidget.method_25394(matrices, mouseX, mouseY, delta);
            xx += 18;
            if (++j < itemsPerLine) continue;
            yy += 18;
            xx = bounds.x + 4;
            j = 0;
        }
    }

    @Nullable
    public Tooltip getTooltip(Point point) {
        for (Slot widget : this.inputWidgets) {
            if (!widget.containsMouse(point)) continue;
            return widget.getCurrentTooltip(point);
        }
        return null;
    }

    public int getHeight() {
        return 4 + this.getItemsHeight() * 18;
    }

    public int getItemsHeight() {
        return class_3532.method_15386((float)((float)this.inputWidgets.size() / (float)this.getItemsPerLine()));
    }

    public int getItemsPerLine() {
        return 4;
    }
}

