/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.client.gui;

import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.registry.SpellEffect;
import com.miskatonicmysteries.api.registry.SpellMedium;
import com.miskatonicmysteries.client.gui.widget.CombinedSpellWidget;
import com.miskatonicmysteries.client.gui.widget.MediumComponentWidget;
import com.miskatonicmysteries.client.gui.widget.SpellComponentWidget;
import com.miskatonicmysteries.client.gui.widget.SpellPowerWidget;
import com.miskatonicmysteries.common.feature.spell.Spell;
import com.miskatonicmysteries.common.handler.networking.packet.SyncSpellCasterDataPacket;
import com.miskatonicmysteries.common.registry.MMSpellMediums;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_333;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class EditSpellScreen
extends class_437 {
    public static final class_2960 BOOK_TEXTURE = new class_2960("miskatonicmysteries", "textures/gui/spellbook.png");
    public Spell[] spells;
    public SpellCaster user;
    public final List<SpellEffect> learnedEffects = new ArrayList<SpellEffect>();
    public final Set<SpellMedium> learnedMediums = new HashSet<SpellMedium>();
    public MediumComponentWidget selectedMedium;
    public SpellComponentWidget selectedEffect;
    public int power = -1;
    public int availablePower;

    public EditSpellScreen(SpellCaster player) {
        super(class_333.field_18967);
        this.user = player;
        this.learnedEffects.addAll(this.user.getLearnedEffects());
        this.learnedMediums.addAll(this.user.getLearnedMediums());
        this.spells = new Spell[player.getMaxSpells()];
        for (int i = 0; i < player.getMaxSpells(); ++i) {
            if (i >= player.getSpells().size()) continue;
            this.spells[i] = player.getSpells().get(i);
        }
        this.updateAvailablePower();
    }

    public void method_25419() {
        this.user.getSpells().clear();
        for (int i = 0; i < this.spells.length; ++i) {
            this.user.getSpells().add(i, this.spells[i]);
        }
        SyncSpellCasterDataPacket.send(true, (class_1657)class_310.method_1551().field_1724, this.user);
        super.method_25419();
    }

    public void updateAvailablePower() {
        this.availablePower = this.user.getPowerPool();
        for (Spell spell : this.spells) {
            if (spell == null) continue;
            this.availablePower -= spell.intensity + 1;
            if (this.availablePower >= 0) continue;
            this.clearSpells();
        }
    }

    public void clearSpells() {
        Arrays.fill(this.spells, null);
    }

    protected void method_25426() {
        int i;
        for (i = 0; i < this.user.getMaxSpells(); ++i) {
            this.method_25411(new CombinedSpellWidget((this.field_22789 - 192) / 4 + 254, 48 + 20 * i, i, this));
        }
        for (i = 0; i < this.learnedEffects.size(); ++i) {
            this.method_25411(new SpellComponentWidget((this.field_22789 - 192) / 4 + 30 * (i % 4), 64 + 30 * (i / 4), this.learnedEffects.get(i), this));
        }
        this.method_25411(new MediumComponentWidget((this.field_22789 - 192) / 4 + 128, 82, MMSpellMediums.SELF, this));
        this.method_25411(new MediumComponentWidget((this.field_22789 - 192) / 4 + 140 + 64, 82, MMSpellMediums.PROJECTILE, this));
        this.method_25411(new MediumComponentWidget((this.field_22789 - 192) / 4 + 138, 130, MMSpellMediums.BOLT, this));
        this.method_25411(new MediumComponentWidget((this.field_22789 - 192) / 4 + 130 + 64, 130, MMSpellMediums.GROUP, this));
        this.method_25411(new MediumComponentWidget((this.field_22789 - 192) / 4 + 134 + 32, 62, MMSpellMediums.VISION, this));
        this.method_25411(new SpellPowerWidget((this.field_22789 - 192) / 4 + 134, 166, 0, this));
        this.method_25411(new SpellPowerWidget((this.field_22789 - 192) / 4 + 134 + 32, 166, 1, this));
        this.method_25411(new SpellPowerWidget((this.field_22789 - 192) / 4 + 134 + 64, 166, 2, this));
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.method_25395(null);
        class_327 textRenderer = class_310.method_1551().field_1772;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_22787.method_1531().method_22813(BOOK_TEXTURE);
        EditSpellScreen.method_25290((class_4587)matrices, (int)((this.field_22789 - 192) / 4 - 16), (int)32, (float)0.0f, (float)0.0f, (int)270, (int)180, (int)512, (int)256);
        EditSpellScreen.method_25290((class_4587)matrices, (int)((this.field_22789 - 192) / 4 + 134 + 31), (int)100, (float)174.0f, (float)204.0f, (int)34, (int)34, (int)512, (int)256);
        EditSpellScreen.method_25290((class_4587)matrices, (int)((this.field_22789 - 192) / 4 + 134 + 32), (int)100, (float)242.0f, (float)204.0f, (int)34, (int)34, (int)512, (int)256);
        float powerPercentage = (float)this.availablePower / (float)this.user.getMaxSpells();
        matrices.method_22903();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)powerPercentage);
        EditSpellScreen.method_25290((class_4587)matrices, (int)((this.field_22789 - 192) / 4 + 134 + 31), (int)100, (float)208.0f, (float)204.0f, (int)34, (int)34, (int)512, (int)256);
        matrices.method_22909();
        EditSpellScreen.drawCenteredText(textRenderer, matrices, (class_2561)new class_2588("miskatonicmysteries.gui.spell_effects"), (this.field_22789 - 192) / 4 + 58, 48, 0x111111);
        EditSpellScreen.drawCenteredText(textRenderer, matrices, (class_2561)new class_2588("miskatonicmysteries.gui.spell_mediums"), (this.field_22789 - 192) / 4 + 184, 48, 0x111111);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public static void drawCenteredText(class_327 renderer, class_4587 stack, class_2561 text, int x, int y, int color) {
        class_5481 orderedText = text.method_30937();
        renderer.method_27528(stack, orderedText, (float)(x - renderer.method_30880(orderedText) / 2), (float)y, color);
    }
}

