/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.client.gui.hud;

import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.client.gui.HUDHandler;
import com.miskatonicmysteries.common.feature.spell.Spell;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class SpellHUD
extends class_332 {
    private float lastMouseX;
    private float lastMouseY;
    private float mouseX;
    private float mouseY;
    public int scaledWidth;
    public int scaledHeight;
    private class_310 client;
    public List<Spell> renderedSpells = new ArrayList<Spell>();
    public static final int RADIUS = 32;
    private double angle = -1.0;
    public Spell selectedSpell;
    public float currentSpellProgress;
    public int absentTicks;

    public void init(class_310 client) {
        this.scaledWidth = client.method_22683().method_4486();
        this.scaledHeight = client.method_22683().method_4502();
        this.client = client;
        this.renderedSpells.clear();
        SpellCaster.of(client.field_1724).ifPresent(caster -> {
            for (Spell spell : caster.getSpells()) {
                if (spell == null) continue;
                this.renderedSpells.add(spell);
            }
        });
        this.mouseX = (float)(client.field_1729.method_1603() * (double)this.scaledWidth / (double)client.method_22683().method_4480());
        this.mouseY = (float)(client.field_1729.method_1604() * (double)this.scaledHeight / (double)client.method_22683().method_4507());
        this.angle = -1.0;
        this.selectedSpell = null;
    }

    public void tick() {
        this.lastMouseX = this.mouseX;
        this.lastMouseY = this.mouseY;
        this.mouseX = (int)(this.client.field_1729.method_1603() * (double)this.scaledWidth / (double)this.client.method_22683().method_4480());
        this.mouseY = (int)(this.client.field_1729.method_1604() * (double)this.scaledHeight / (double)this.client.method_22683().method_4507());
        class_241 directionVector = new class_241(this.mouseX - this.lastMouseX, this.mouseY - this.lastMouseY);
        if (Math.abs(directionVector.field_1343) > 0.5f || Math.abs(directionVector.field_1342) > 0.5f) {
            this.angle = Math.toDegrees(Math.atan2(0.0f - directionVector.field_1342, -1.0f - directionVector.field_1343)) - 180.0;
            if (this.angle < 0.0) {
                this.angle += 360.0;
            }
            this.absentTicks = 0;
        } else if (++this.absentTicks > 10) {
            this.angle = -1.0;
        }
    }

    public void render(class_4587 matrixStack, float tickDelta) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        matrixStack.method_22904((double)((float)this.scaledWidth / 2.0f), (double)((float)this.scaledHeight / 2.0f), 0.0);
        if (this.renderedSpells.size() > 1) {
            double angleSize = 360.0f / (float)this.renderedSpells.size();
            for (int i = 0; i < this.renderedSpells.size(); ++i) {
                Spell renderedSpell = this.renderedSpells.get(i);
                if (renderedSpell == null) continue;
                matrixStack.method_22903();
                double angle = ((double)i * angleSize + 360.0) % 360.0 - 90.0;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                double angleRad = Math.toRadians(angle);
                double x = Math.cos(angleRad) * 32.0;
                double y = Math.sin(angleRad) * 32.0;
                if (this.isSelected(angle)) {
                    this.selectedSpell = renderedSpell;
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                this.renderSpellIcon(x, y, matrixStack, renderedSpell);
                matrixStack.method_22909();
            }
        } else if (this.renderedSpells.size() == 1) {
            this.selectedSpell = this.renderedSpells.get(0);
            HUDHandler.selectionActive = false;
        }
    }

    public void renderSpellIcon(double x, double y, class_4587 matrixStack, Spell spell) {
        matrixStack.method_22904(x, y, 0.0);
        this.client.method_1531().method_22813(spell.effect.getTextureLocation());
        SpellHUD.method_25290((class_4587)matrixStack, (int)-9, (int)-9, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    public boolean isSelected(double angleDeg) {
        if (this.angle < 0.0) {
            return false;
        }
        if (this.renderedSpells.size() <= 1) {
            return true;
        }
        double distance = Math.abs(angleDeg - this.angle);
        return distance < (double)(360.0f / (float)this.renderedSpells.size() / 2.0f) && distance < 90.0;
    }
}

