/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ladysnake.satin.api.util.RenderLayerHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;

@Environment(value=EnvType.CLIENT)
public class RenderHelper
extends class_1921 {
    public static final List<class_1921> PORTAL_LAYERS = IntStream.range(1, 17).mapToObj(class_1921::method_23574).collect(Collectors.toList());
    public static final class_4668.class_4685 AURA_TRANSPARENCY = new class_4668.class_4685("miskatonicmysteries:aura_transparency", () -> {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22518);
        RenderSystem.disableLighting();
    }, () -> {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final class_1921.class_4688 TRANSPARENCY_PARAMS = class_1921.class_4688.method_23598().method_23612(new class_4668.class_4681(false)).method_23613(field_21377).method_23605(new class_4668.class_4673(true)).method_23615(new class_4668.class_4685("miskatonicmysteries:translucency", () -> {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22523);
    }, () -> {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).method_23608(new class_4668.class_4676(true)).method_23617(true);
    public static final class_1921.class_4688 AURA_PARAMS = class_1921.class_4688.method_23598().method_23612(new class_4668.class_4681(false)).method_23613(field_21377).method_23605(new class_4668.class_4673(true)).method_23615(AURA_TRANSPARENCY).method_23602(class_4668.field_21372).method_23608(new class_4668.class_4676(true)).method_23617(true);
    public static final class_1921 AURA_LAYER = class_1921.method_24049((String)"miskatonicmysteries:aura_layer", (class_293)class_290.field_20888, (int)7, (int)128, (boolean)true, (boolean)true, (class_1921.class_4688)AURA_PARAMS);
    public static final class_1921 TRANSPARENCY_LAYER = class_1921.method_24049((String)"miskatonicmysteries:transparent", (class_293)class_290.field_20888, (int)7, (int)128, (boolean)true, (boolean)true, (class_1921.class_4688)TRANSPARENCY_PARAMS);
    public static final class_1921 BOLT_LAYER = class_1921.method_24049((String)"miskatonicmysteries:bolt", (class_293)class_290.field_1576, (int)7, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)RenderLayerHelper.copyPhaseParameters((class_1921)RenderHelper.method_23593(), builder -> builder.method_23615(AURA_TRANSPARENCY)));

    public RenderHelper(String name, class_293 vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static class_1921 getAuraGlowLayer() {
        return AURA_LAYER;
    }

    public static class_1921 getTransparency() {
        return TRANSPARENCY_LAYER;
    }

    public static class_1921 getBoltLayer() {
        return BOLT_LAYER;
    }

    public static class_1921 getEnergyTentacleLayer(class_2960 texture) {
        class_4668.class_4685 TRANSPARENCY = new class_4668.class_4685("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22518, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22523);
            RenderSystem.disableLighting();
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        class_1921.class_4688 multiPhaseParameters = class_1921.class_4688.method_23598().method_23613(new class_4668.class_4683(texture, false, false)).method_23615(TRANSPARENCY).method_23605(field_21387).method_23602(field_21372).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23617(true);
        return RenderHelper.method_24049((String)"miskatonicmysteries:energy_tentacle", (class_293)class_290.field_1580, (int)7, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)multiPhaseParameters);
    }

    public static void renderTexturedPlane(float size, class_1058 sprite, class_4587 matrices, class_4588 buffer, int light, int overlay, float[] rgba) {
        class_1159 mat = matrices.method_23760().method_23761();
        buffer.method_22918(mat, 0.0f, 0.0f, size).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_22913(sprite.method_4594(), sprite.method_4575()).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, size, 0.0f, size).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_22913(sprite.method_4577(), sprite.method_4575()).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, size, 0.0f, 0.0f).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_22913(sprite.method_4577(), sprite.method_4593()).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, 0.0f, 0.0f, 0.0f).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_22913(sprite.method_4594(), sprite.method_4593()).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
    }

    public static void renderFullPortal(class_4184 camera, class_1937 world, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers, float size, float[] rgb) {
        matrices.method_22903();
        double distance = pos.method_19770((class_2374)camera.method_19326(), true);
        int renderDepth = RenderHelper.getDepthFromDistance(distance);
        class_1159 matrix4f = matrices.method_23760().method_23761();
        for (int i = 0; i < renderDepth; ++i) {
            RenderHelper.renderPortalLayer(i, world, matrix4f, vertexConsumers, size, rgb);
        }
        matrices.method_22909();
    }

    public static void renderPortalLayer(int layer, class_1937 world, class_1159 matrix4f, class_4597 vertexConsumers, float size, float[] rgb) {
        RenderHelper.renderPortalLayer(layer, world, matrix4f, vertexConsumers, size, size, rgb);
    }

    public static void renderPortalLayer(int layer, class_1937 world, class_1159 matrix4f, class_4597 vertexConsumers, float sizeX, float sizeY, float[] rgb) {
        float colorFactor = 2.0f / (float)(18 - layer);
        float r = (world.field_9229.nextFloat() * 0.5f + rgb[0]) * colorFactor;
        float g = (world.field_9229.nextFloat() * 0.5f + rgb[1]) * colorFactor;
        float b = (world.field_9229.nextFloat() * 0.5f + rgb[2]) * colorFactor;
        class_4588 vertexConsumer = vertexConsumers.getBuffer(PORTAL_LAYERS.get(layer));
        vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, sizeY).method_22915(r, g, b, rgb[3]).method_1344();
        vertexConsumer.method_22918(matrix4f, sizeX, 0.0f, sizeY).method_22915(r, g, b, rgb[3]).method_1344();
        vertexConsumer.method_22918(matrix4f, sizeX, 0.0f, 0.0f).method_22915(r, g, b, rgb[3]).method_1344();
        vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, rgb[3]).method_1344();
    }

    public static void renderModelAsPortal(class_4597 provider, class_4587 matrices, int light, int overlay, class_3879 model, float[] rgb, float alpha, Random random, int layer) {
        model.method_2828(matrices, provider.getBuffer(PORTAL_LAYERS.get(layer)), light, overlay, rgb[0], rgb[1], rgb[2], alpha);
    }

    public static int getDepthFromDistance(double distance) {
        if (distance > 36864.0) {
            return 1;
        }
        if (distance > 25600.0) {
            return 3;
        }
        if (distance > 16384.0) {
            return 5;
        }
        if (distance > 9216.0) {
            return 7;
        }
        if (distance > 4096.0) {
            return 9;
        }
        if (distance > 1024.0) {
            return 11;
        }
        if (distance > 576.0) {
            return 13;
        }
        return distance > 256.0 ? 14 : 15;
    }
}

