/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.client.render;

import com.miskatonicmysteries.api.block.OctagramBlock;
import com.miskatonicmysteries.api.block.StatueBlock;
import com.miskatonicmysteries.api.item.armor.CultistArmor;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.client.model.armor.HasturMaskModel;
import com.miskatonicmysteries.client.model.armor.ShubAlternateMaskModel;
import com.miskatonicmysteries.client.model.armor.ShubMaskModel;
import com.miskatonicmysteries.client.model.block.CthulhuStatueModel;
import com.miskatonicmysteries.client.model.block.HasturStatueModel;
import com.miskatonicmysteries.client.model.block.ShubStatueModel;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.block.blockentity.StatueBlockEntity;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMObjects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderingRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.minecraft.class_1059;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4730;
import net.minecraft.class_562;
import net.minecraft.class_572;
import net.minecraft.class_828;

@Environment(value=EnvType.CLIENT)
public class ResourceHandler {
    public static final class_4730 DEFAULT_OCTAGRAM = new class_4730(class_1059.field_5275, new class_2960("miskatonicmysteries", "block/octagram/generic_octagram"));
    public static final class_4730 DEFAULT_OCTAGRAM_MASK = new class_4730(class_1059.field_5275, new class_2960("miskatonicmysteries", "block/octagram/mask/octagram_mask"));
    public static final class_4730 AURA_SPRITE = new class_4730(class_1059.field_5275, new class_2960("miskatonicmysteries", "misc/aura"));
    public static final class_4730 TOTAL_DARK = new class_4730(class_1059.field_5275, new class_2960("miskatonicmysteries", "misc/total_dark"));
    public static final HasturStatueModel HASTUR_STATUE_MODEL = new HasturStatueModel();
    public static final Map<class_1792, class_4730> BOOK_SPRITES = new HashMap<class_1792, class_4730>();
    public static final Map<OctagramBlock, class_4730> OCTAGRAM_SPRITES = new HashMap<OctagramBlock, class_4730>();
    public static final Map<OctagramBlock, class_4730> OCTAGRAM_MASKS = new HashMap<OctagramBlock, class_4730>();
    public static final Map<Affiliation, class_3879> STATUE_MODELS = new HashMap<Affiliation, class_3879>();
    public static final Map<StatueBlock, class_4730> STATUE_SPRITES = new HashMap<StatueBlock, class_4730>();
    public static final Map<class_1792, class_3879> MASK_MODELS = new HashMap<class_1792, class_3879>();

    public static void init() {
        ClientSpriteRegistryCallback.registerBlockAtlas((spriteAtlasTexture, registry) -> {
            registry.register(new class_2960("miskatonicmysteries", "misc/book_necronomicon"));
            registry.register(new class_2960("miskatonicmysteries", "misc/aura"));
            registry.register(new class_2960("miskatonicmysteries", "block/octagram/mask/hastur_octagram_mask"));
            registry.register(new class_2960("miskatonicmysteries", "block/octagram/mask/shub_octagram_mask"));
            registry.register(new class_2960("miskatonicmysteries", "block/octagram/mask/cthulhu_octagram_mask"));
        });
        ResourceHandler.addBookTextureFor(MMObjects.NECRONOMICON, new class_2960("miskatonicmysteries", "misc/book_necronomicon"));
        ResourceHandler.addOctagramTextureFor(MMObjects.CTHULHU_OCTAGRAM, new class_2960("miskatonicmysteries", "block/octagram/cthulhu_octagram"), new class_2960("miskatonicmysteries", "block/octagram/mask/cthulhu_octagram_mask"));
        ResourceHandler.addOctagramTextureFor(MMObjects.HASTUR_OCTAGRAM, new class_2960("miskatonicmysteries", "block/octagram/hastur_octagram"), new class_2960("miskatonicmysteries", "block/octagram/mask/hastur_octagram_mask"));
        ResourceHandler.addOctagramTextureFor(MMObjects.SHUB_OCTAGRAM, new class_2960("miskatonicmysteries", "block/octagram/shub_octagram"), new class_2960("miskatonicmysteries", "block/octagram/mask/shub_octagram_mask"));
        ResourceHandler.addStatueModelFor(MMAffiliations.CTHULHU, new CthulhuStatueModel());
        ResourceHandler.addStatueModelFor(MMAffiliations.HASTUR, new HasturStatueModel());
        ResourceHandler.addStatueModelFor(MMAffiliations.SHUB, new ShubStatueModel());
        ResourceHandler.addStatueTextureFor(MMObjects.CTHULHU_STATUE_GOLD, new class_2960("miskatonicmysteries", "block/statue/cthulhu_statue_gold"));
        ResourceHandler.addStatueTextureFor(MMObjects.CTHULHU_STATUE_MOSSY, new class_2960("miskatonicmysteries", "block/statue/cthulhu_statue_mossy"));
        ResourceHandler.addStatueTextureFor(MMObjects.CTHULHU_STATUE_PRISMARINE, new class_2960("miskatonicmysteries", "block/statue/cthulhu_statue_prismarine"));
        ResourceHandler.addStatueTextureFor(MMObjects.CTHULHU_STATUE_STONE, new class_2960("miskatonicmysteries", "block/statue/cthulhu_statue_stone"));
        ResourceHandler.addStatueTextureFor(MMObjects.HASTUR_STATUE_GOLD, new class_2960("miskatonicmysteries", "block/statue/hastur_statue_gold"));
        ResourceHandler.addStatueTextureFor(MMObjects.HASTUR_STATUE_MOSSY, new class_2960("miskatonicmysteries", "block/statue/hastur_statue_mossy"));
        ResourceHandler.addStatueTextureFor(MMObjects.HASTUR_STATUE_TERRACOTTA, new class_2960("miskatonicmysteries", "block/statue/hastur_statue_terracotta"));
        ResourceHandler.addStatueTextureFor(MMObjects.HASTUR_STATUE_STONE, new class_2960("miskatonicmysteries", "block/statue/hastur_statue_stone"));
        ResourceHandler.addStatueTextureFor(MMObjects.SHUB_STATUE_GOLD, new class_2960("miskatonicmysteries", "block/statue/shub_statue_gold"));
        ResourceHandler.addStatueTextureFor(MMObjects.SHUB_STATUE_MOSSY, new class_2960("miskatonicmysteries", "block/statue/shub_statue_mossy"));
        ResourceHandler.addStatueTextureFor(MMObjects.SHUB_STATUE_BLACKSTONE, new class_2960("miskatonicmysteries", "block/statue/shub_statue_blackstone"));
        ResourceHandler.addStatueTextureFor(MMObjects.SHUB_STATUE_STONE, new class_2960("miskatonicmysteries", "block/statue/shub_statue_stone"));
        ResourceHandler.addMaskModel(MMObjects.ELEGANT_MASK, new HasturMaskModel());
        ResourceHandler.addMaskModel(MMObjects.FERAL_MASK, new ShubMaskModel());
        ResourceHandler.addMaskModel(MMObjects.WILD_MASK, new ShubAlternateMaskModel());
        List armors = class_2378.field_11142.method_10220().filter(i -> i instanceof CultistArmor && class_2378.field_11142.method_10221(i).method_12836().equals("miskatonicmysteries")).collect(Collectors.toList());
        ArmorRenderingRegistry.ModelProvider p = (entity, stack, slot, original) -> ((CultistArmor)stack.method_7909()).getArmorModel(entity, stack, slot, (class_572<class_1309>)original);
        ArmorRenderingRegistry.registerModel((ArmorRenderingRegistry.ModelProvider)p, armors);
        ArmorRenderingRegistry.TextureProvider t = (entity, stack, slot, secondLayer, suffix, original) -> ((CultistArmor)stack.method_7909()).getArmorTexture(stack, slot);
        ArmorRenderingRegistry.registerTexture((ArmorRenderingRegistry.TextureProvider)t, armors);
    }

    public static void addBookTextureFor(class_1792 item, class_2960 texture) {
        BOOK_SPRITES.put(item, new class_4730(class_1059.field_5275, texture));
    }

    public static void addOctagramTextureFor(OctagramBlock octagram, class_2960 texture, class_2960 maskTexture) {
        OCTAGRAM_SPRITES.put(octagram, new class_4730(class_1059.field_5275, texture));
        OCTAGRAM_MASKS.put(octagram, new class_4730(class_1059.field_5275, maskTexture));
    }

    public static void addStatueModelFor(Affiliation affiliation, class_3879 model) {
        STATUE_MODELS.put(affiliation, model);
    }

    public static void addStatueTextureFor(StatueBlock statue, class_2960 texture) {
        STATUE_SPRITES.put(statue, new class_4730(class_1059.field_5275, texture));
    }

    public static void addMaskModel(class_1792 mask, class_3879 model) {
        MASK_MODELS.put(mask, model);
    }

    public static class_4730 getBookTextureFor(class_1799 stack) {
        return BOOK_SPRITES.getOrDefault(stack.method_7909(), class_828.field_4369);
    }

    public static class_4730 getOctagramTextureFor(OctagramBlockEntity octagram) {
        return OCTAGRAM_SPRITES.getOrDefault(octagram.method_10997().method_8320(octagram.method_11016()).method_26204(), DEFAULT_OCTAGRAM);
    }

    public static class_4730 getOctagramMaskTextureFor(OctagramBlockEntity octagram) {
        return OCTAGRAM_MASKS.getOrDefault(octagram.method_10997().method_8320(octagram.method_11016()).method_26204(), DEFAULT_OCTAGRAM_MASK);
    }

    public static class_3879 getStatueModelFor(StatueBlockEntity statue) {
        return STATUE_MODELS.getOrDefault(statue.getAffiliation(false), (class_3879)new class_562());
    }

    public static class_4730 getStatueTextureFor(StatueBlockEntity statue) {
        return STATUE_SPRITES.getOrDefault(statue.method_10997().method_8320(statue.method_11016()).method_26204(), new class_4730(class_1059.field_5275, new class_2960("")));
    }

    public static class_3879 getMaskModel(class_1792 mask) {
        return MASK_MODELS.getOrDefault(mask, (class_3879)new class_562());
    }

    public static class_4730 getMatchingOctagramTexture(Affiliation affiliation) {
        if (affiliation == null || affiliation == MMAffiliations.NONE) {
            return DEFAULT_OCTAGRAM;
        }
        for (OctagramBlock octagramBlock : OCTAGRAM_SPRITES.keySet()) {
            if (!affiliation.equals(octagramBlock.getAffiliation(false))) continue;
            return OCTAGRAM_SPRITES.get(octagramBlock);
        }
        return DEFAULT_OCTAGRAM;
    }
}

