/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.block.blockentity;

import com.miskatonicmysteries.api.block.OctagramBlock;
import com.miskatonicmysteries.api.interfaces.Affiliated;
import com.miskatonicmysteries.api.item.MMBookItem;
import com.miskatonicmysteries.api.item.armor.CultistArmor;
import com.miskatonicmysteries.api.item.trinkets.MaskTrinketItem;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.Rite;
import com.miskatonicmysteries.common.MiskatonicMysteries;
import com.miskatonicmysteries.common.block.blockentity.AltarBlockEntity;
import com.miskatonicmysteries.common.block.blockentity.BaseBlockEntity;
import com.miskatonicmysteries.common.block.blockentity.ImplementedBlockEntityInventory;
import com.miskatonicmysteries.common.handler.ProtagonistHandler;
import com.miskatonicmysteries.common.item.IncantationYogItem;
import com.miskatonicmysteries.common.registry.MMCriteria;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMRegistries;
import com.miskatonicmysteries.common.util.Constants;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class OctagramBlockEntity
extends BaseBlockEntity
implements ImplementedBlockEntityInventory,
Affiliated,
class_3000 {
    private final class_2371<class_1799> ITEMS = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    public int tickCount;
    public boolean permanentRiteActive;
    public Rite currentRite = null;
    public UUID originalCaster = null;
    public Pair<class_2960, class_2338> boundPos = null;
    public boolean triggered;
    public class_1297 targetedEntity = null;
    private byte octagramFlags;

    public OctagramBlockEntity() {
        super(MMObjects.OCTAGRAM_BLOCK_ENTITY_TYPE);
    }

    public void setFlag(int index, boolean value) {
        this.octagramFlags = value ? (byte)(this.octagramFlags | 1 << index) : (byte)(this.octagramFlags & ~(1 << index));
        this.method_5431();
    }

    public boolean getFlag(int index) {
        return (this.octagramFlags & 1 << index) != 0;
    }

    public class_2487 method_11007(class_2487 tag) {
        class_1262.method_5426((class_2487)tag, this.ITEMS);
        tag.method_10569("TickCount", this.tickCount);
        if (this.currentRite != null) {
            tag.method_10582("Rite", this.currentRite.getId().toString());
        }
        tag.method_10556("PermanentRite", this.permanentRiteActive);
        if (this.originalCaster != null) {
            tag.method_25927("PlayerUUID", this.originalCaster);
        }
        if (this.boundPos != null) {
            tag.method_10582("ConnectedDimension", ((class_2960)this.boundPos.getFirst()).toString());
            tag.method_10544("ConnectedPosition", ((class_2338)this.boundPos.getSecond()).method_10063());
        }
        tag.method_10556("Triggered", this.triggered);
        tag.method_10567("Flags", this.octagramFlags);
        return super.method_11007(tag);
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        this.ITEMS.clear();
        class_1262.method_5429((class_2487)tag, this.ITEMS);
        this.tickCount = tag.method_10550("TickCount");
        this.currentRite = tag.method_10545("Rite") ? (Rite)MMRegistries.RITES.method_10223(new class_2960(tag.method_10558("Rite"))) : null;
        this.permanentRiteActive = tag.method_10577("PermanentRite");
        this.originalCaster = tag.method_10545("PlayerUUID") ? tag.method_25926("PlayerUUID") : null;
        this.boundPos = tag.method_10545("ConnectedDimension") ? new Pair((Object)new class_2960(tag.method_10558("ConnectedDimension")), (Object)class_2338.method_10092((long)tag.method_10537("ConnectedPosition"))) : null;
        this.triggered = tag.method_10577("Triggered");
        this.octagramFlags = tag.method_10571("Flags");
        super.method_11014(state, tag);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (this.currentRite != null && !this.permanentRiteActive && !this.currentRite.shouldContinue(this)) {
            this.currentRite.onCancelled(this);
            this.tickCount = 0;
            this.currentRite = null;
        }
    }

    public int method_5444() {
        return 1;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.ITEMS;
    }

    public void method_16896() {
        if (this.currentRite != null) {
            if (this.currentRite.shouldContinue(this)) {
                this.currentRite.tick(this);
                if (this.currentRite.isFinished(this)) {
                    if (this.getOriginalCaster() instanceof class_3222) {
                        MMCriteria.RITE_CAST.trigger((class_3222)this.getOriginalCaster(), this.currentRite);
                    }
                    this.handleInvestigators();
                    if (this.currentRite.isPermanent(this)) {
                        this.permanentRiteActive = true;
                        this.currentRite.onFinished(this);
                    } else {
                        this.currentRite.onFinished(this);
                        this.tickCount = 0;
                        this.currentRite = null;
                        this.targetedEntity = null;
                        this.setFlag(0, false);
                    }
                    if (!this.field_11863.field_9236) {
                        this.sync();
                    }
                }
            } else {
                this.currentRite.onCancelled(this);
                this.originalCaster = null;
                this.currentRite = null;
                this.setFlag(0, false);
                if (!this.field_11863.field_9236) {
                    this.sync();
                }
            }
            this.method_5431();
        }
    }

    private void handleInvestigators() {
        class_1657 caster = this.getOriginalCaster();
        if (caster != null && !this.field_11863.field_9236 && this.field_11863.field_9229.nextFloat() < this.currentRite.getInvestigatorChance()) {
            float subtlety = 0.0f;
            if (MiskatonicMysteries.config.entities.subtlety) {
                for (class_2338 blockPos : class_2338.method_25996((class_2338)this.field_11867, (int)8, (int)8, (int)8)) {
                    class_2248 block = this.field_11863.method_8320(blockPos).method_26204();
                    if (block.method_9525(Constants.Tags.SUBTLE_BLOCKS)) {
                        subtlety += 0.05f;
                    } else if (block.method_9525(Constants.Tags.SUSPICIOUS_BLOCKS)) {
                        subtlety -= 0.05f;
                    }
                    if (!(subtlety >= 0.35f)) continue;
                    break;
                }
                subtlety = (float)((double)subtlety + (this.field_11863.method_23886() ? (double)0.15f : -0.1));
                subtlety += MaskTrinketItem.getMask(caster).method_7960() ? 0.0f : 0.15f;
                for (class_1799 armor : caster.method_5661()) {
                    if (!(armor.method_7909() instanceof CultistArmor)) continue;
                    subtlety += 0.1f;
                }
                subtlety = Math.min(subtlety, 0.8f);
            } else {
                subtlety = 0.25f;
            }
            if (this.field_11863.field_9229.nextFloat() > subtlety) {
                ProtagonistHandler.spawnProtagonist((class_3218)this.field_11863, caster);
            }
        }
    }

    public class_1657 getOriginalCaster() {
        return this.field_11863 != null && this.originalCaster != null ? this.field_11863.method_18470(this.originalCaster) : null;
    }

    public void setOriginalCaster(class_1657 player) {
        if (this.currentRite == null || this.originalCaster == null) {
            this.originalCaster = player.method_5667();
        }
    }

    @Override
    public Affiliation getAffiliation(boolean apparent) {
        return this.method_11010().method_26204() instanceof OctagramBlock ? ((OctagramBlock)this.field_11863.method_8320(this.field_11867).method_26204()).getAffiliation(true) : null;
    }

    @Override
    public boolean isSupernatural() {
        return this.method_11010().method_26204() instanceof OctagramBlock && ((OctagramBlock)this.field_11863.method_8320(this.field_11867).method_26204()).isSupernatural();
    }

    @Override
    public void method_5448() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.method_5438(i).method_7909().method_7857()) {
                this.method_5447(i, new class_1799((class_1935)this.method_5438(i).method_7909().method_7858()));
                continue;
            }
            if (!this.method_5438(i).method_7960() && this.method_5438(i).method_7909().method_7855(Constants.Tags.RITE_TOOLS)) {
                if (!(this.method_5438(i).method_7909() instanceof IncantationYogItem)) continue;
                IncantationYogItem.clear(this.method_5438(i));
                continue;
            }
            this.method_5447(i, class_1799.field_8037);
        }
    }

    public class_243 getSummoningPos() {
        return new class_243((double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.25f), (double)((float)this.field_11867.method_10260() + 0.5f));
    }

    public class_238 getSelectionBox() {
        return new class_238(this.field_11867.method_10069(-1, -1, -1), this.field_11867.method_10069(2, 2, 2));
    }

    public class_2338 getBoundPos() {
        return this.boundPos != null && class_1937.method_25953((class_2338)((class_2338)this.boundPos.getSecond())) ? (class_2338)this.boundPos.getSecond() : null;
    }

    public class_3218 getBoundDimension() {
        return this.boundPos != null && !this.field_11863.field_9236 ? this.field_11863.method_8503().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((class_2960)this.boundPos.getFirst()))) : null;
    }

    public void bind(class_1937 world, class_2338 pos) {
        this.boundPos = new Pair((Object)world.method_27983().method_29177(), (Object)pos);
    }

    public boolean doesNearestAltarHaveKnowledge(String knowledge) {
        if (knowledge.isEmpty()) {
            return true;
        }
        for (class_2338 blockPos : class_2338.method_25996((class_2338)this.field_11867, (int)8, (int)8, (int)8)) {
            class_2586 entity = this.field_11863.method_8321(blockPos);
            if (!(entity instanceof AltarBlockEntity) || !MMBookItem.hasKnowledge(knowledge, ((AltarBlockEntity)entity).method_5438(0))) continue;
            return true;
        }
        return false;
    }
}

