/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.block.blockentity.energy;

import com.miskatonicmysteries.api.interfaces.Resonating;
import com.miskatonicmysteries.client.sound.ResonatorSound;
import com.miskatonicmysteries.common.block.blockentity.BaseBlockEntity;
import com.miskatonicmysteries.common.entity.PhantasmaEntity;
import com.miskatonicmysteries.common.registry.MMEntities;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMParticles;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3000;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import team.reborn.energy.EnergySide;
import team.reborn.energy.EnergyStorage;
import team.reborn.energy.EnergyTier;

public class ResonatorBlockEntity
extends BaseBlockEntity
implements class_3000,
EnergyStorage {
    private static final int MAX_STORED_POWER = 3200;
    private static final int MAX_RADIUS = 16;
    private float radius;
    public float intensity;
    private double energy;
    public int ticksRan;
    private static final int MAX_EFFECTIVE_RUNTIME = 1200;

    public ResonatorBlockEntity() {
        super(MMObjects.RESONATOR_BLOCK_ENTITY_TYPE);
    }

    public class_2487 method_11007(class_2487 tag) {
        tag.method_10548("Radius", this.radius);
        tag.method_10548("Intensity", this.intensity);
        tag.method_10549("Energy", this.energy);
        tag.method_10569("TickCount", this.ticksRan);
        return super.method_11007(tag);
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        this.radius = tag.method_10583("Radius");
        this.intensity = tag.method_10583("Intensity");
        this.energy = tag.method_10574("Energy");
        this.ticksRan = tag.method_10550("TickCount");
        super.method_11014(state, tag);
    }

    public void method_16896() {
        boolean powered = this.isPowered();
        if (powered) {
            this.radius = 16.0f * this.intensity;
            ++this.ticksRan;
            if (this.energy < 16.0) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false)));
            } else {
                this.energy -= 16.0;
                if (this.intensity < 1.0f) {
                    this.intensity += 5.0E-4f;
                }
                if (this.field_11863.field_9236) {
                    ResonatorBlockEntity.handleSound(this);
                    this.field_11863.method_8406((class_2394)MMParticles.AMBIENT, (double)((float)this.field_11867.method_10263() + 0.5f) + this.field_11863.field_9229.nextGaussian() * (double)this.radius, (double)((float)this.field_11867.method_10264() + 0.5f) + this.field_11863.field_9229.nextGaussian() * (double)this.radius, (double)((float)this.field_11867.method_10260() + 0.5f) + this.field_11863.field_9229.nextGaussian() * (double)this.radius, 0.75, 0.0, 1.0);
                }
                if (this.ticksRan > 600 && this.ticksRan % 240 == 0) {
                    this.spawnPhantasm();
                }
                List affectedEntities = this.field_11863.method_8390(class_1297.class, this.getSelectionBox(), entity -> entity instanceof Resonating);
                for (class_1297 affectedEntity : affectedEntities) {
                    Resonating.of(affectedEntity).ifPresent(resonating -> {
                        float targetIntensity = this.getIntensityFromDistance(affectedEntity);
                        if (resonating.getResonance() < targetIntensity) {
                            resonating.setResonance(resonating.getResonance() + targetIntensity / 100.0f + 0.01f);
                        }
                    });
                }
                this.method_5431();
            }
        } else if (this.intensity > 0.0f || this.ticksRan > 0) {
            --this.ticksRan;
            this.intensity -= 0.001f;
            this.method_5431();
        }
    }

    private void spawnPhantasm() {
        for (int i = 0; i < 10; ++i) {
            class_243 pos = new class_243((double)this.method_11016().method_10263() + this.field_11863.field_9229.nextGaussian() * (double)(this.radius - 3.0f), (double)this.method_11016().method_10264() + this.field_11863.field_9229.nextGaussian() * (double)(this.radius - 7.0f), (double)this.method_11016().method_10260() + this.field_11863.field_9229.nextGaussian() * (double)(this.radius - 3.0f));
            if (!this.field_11863.method_8320(new class_2338(pos)).method_26212((class_1922)this.field_11863, new class_2338(pos)) || !(this.field_11863 instanceof class_3218)) continue;
            PhantasmaEntity phantasma = this.field_11863.method_8409().nextBoolean() ? (PhantasmaEntity)MMEntities.ABERRATION.method_5883(this.field_11863) : (PhantasmaEntity)MMEntities.PHANTASMA.method_5883(this.field_11863);
            phantasma.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), this.field_11863.field_9229.nextInt(360), 0.0f);
            phantasma.method_5943((class_5425)((class_3218)this.field_11863), this.field_11863.method_8404(phantasma.method_24515()), class_3730.field_16469, null, null);
            phantasma.setResonance(0.01f);
            this.field_11863.method_8649((class_1297)phantasma);
            return;
        }
    }

    private float getIntensityFromDistance(class_1297 affectedEntity) {
        double distance = Math.sqrt(affectedEntity.method_5649((double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.75f), (double)((float)this.field_11867.method_10260() + 0.5f)));
        float densityFactor = this.ticksRan > 1200 ? 1.0f : (float)Math.min(distance / (double)(this.ticksRan / 1200), 1.0);
        return 1.0f - this.intensity * (densityFactor / this.radius);
    }

    public boolean isPowered() {
        return (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12484);
    }

    public class_238 getSelectionBox() {
        return new class_238(this.field_11867, this.field_11867.method_10069(1, 1, 1)).method_1014((double)this.radius);
    }

    public double getStored(EnergySide face) {
        return this.energy;
    }

    public void setStored(double amount) {
        this.energy = amount;
    }

    public double getMaxStoredPower() {
        return 3200.0;
    }

    public EnergyTier getTier() {
        return EnergyTier.LOW;
    }

    public double getMaxInput(EnergySide side) {
        return side != EnergySide.UP ? (double)EnergyTier.LOW.getMaxInput() : 0.0;
    }

    public double getMaxOutput(EnergySide side) {
        return 0.0;
    }

    @Environment(value=EnvType.CLIENT)
    public static void handleSound(ResonatorBlockEntity resonator) {
        ResonatorSound.createSound(resonator.method_11016());
    }
}

