/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.entity;

import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.item.GunItem;
import com.miskatonicmysteries.common.MiskatonicMysteries;
import com.miskatonicmysteries.common.entity.ai.GunAttackGoal;
import com.miskatonicmysteries.common.entity.ai.MobBowAttackGoal;
import com.miskatonicmysteries.common.entity.ai.MobCrossbowAttackGoal;
import com.miskatonicmysteries.common.handler.AdvancementHandler;
import com.miskatonicmysteries.common.handler.ProtagonistHandler;
import com.miskatonicmysteries.common.registry.MMEntities;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMParticles;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_4050;
import net.minecraft.class_4255;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class ProtagonistEntity
extends class_1314
implements class_1603,
class_3745 {
    protected static final Map<AbstractMap.SimpleEntry<class_1304, class_1799>, Integer> ARMOR_MAP = new HashMap<AbstractMap.SimpleEntry<class_1304, class_1799>, Integer>();
    protected static final Map<class_1799, Integer> WEAPON_MAP = new HashMap<class_1799, Integer>();
    protected static final Map<class_1799, Integer> ALT_WEAPON_MAP = new HashMap<class_1799, Integer>();
    protected static final Map<Integer, class_1322> MODIFIER_MAP = new HashMap<Integer, class_1322>();
    private static final class_1322 DEFAULT_MOD = new class_1322("210caf3b-c286-4142-98d1-136e8b59b1b1", 0.0, class_1322.class_1323.field_6328);
    protected static final class_2940<Boolean> LOADING = class_2945.method_12791(ProtagonistEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> VARIANT = class_2945.method_12791(ProtagonistEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> STAGE = class_2945.method_12791(ProtagonistEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Optional<UUID>> TARGET_UUID = class_2945.method_12791(ProtagonistEntity.class, (class_2941)class_2943.field_13313);
    public class_1799 alternateWeapon = class_1799.field_8037;

    public ProtagonistEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 0;
        ((class_1409)this.method_5942()).method_6363(true);
        this.method_5942().method_6354(true);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(STAGE, (Object)0);
        this.field_6011.method_12784(LOADING, (Object)false);
        this.field_6011.method_12784(TARGET_UUID, Optional.empty());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_4255((class_1308)this, false));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new SwitchWeaponsGoal(this));
        this.field_6201.method_6277(3, (class_1352)new GunAttackGoal((class_1308)this));
        this.field_6201.method_6277(3, new MobBowAttackGoal<ProtagonistEntity>(this, 1.2f, 20, 24.0f));
        this.field_6201.method_6277(3, new MobCrossbowAttackGoal<ProtagonistEntity>(this, 1.4f, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.2, false));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 12.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{ProtagonistEntity.class}));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, true, MiskatonicMysteriesAPI::isDefiniteAffiliated));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, true, player -> this.getTargetUUID().isPresent() && player.method_5667().equals(this.getTargetUUID().get()) || Sanity.of(player).isPresent() && Sanity.of(player).get().getSanity() <= MiskatonicMysteries.config.entities.protagonistAggressionThreshold));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1588.class, 5, true, true, mob -> !(mob instanceof ProtagonistEntity) && !(mob instanceof class_1548)));
        super.method_5959();
    }

    public void removeAfterTargetKill() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.field_6002.method_8406((class_2394)MMParticles.FLAME, this.method_23317() + this.field_5974.nextGaussian() * (double)this.method_18377((class_4050)class_4050.field_18076).field_18067, this.method_23318() + (double)(this.field_5974.nextFloat() * this.method_18377((class_4050)class_4050.field_18076).field_18068), this.method_23321() + this.field_5974.nextGaussian() * (double)this.method_18377((class_4050)class_4050.field_18076).field_18067, 1.0, 0.0, 0.0);
        }
        for (i = 0; i < 15; ++i) {
            this.field_6002.method_8406((class_2394)class_2398.field_11237, this.method_23317() + this.field_5974.nextGaussian() * (double)this.method_18377((class_4050)class_4050.field_18076).field_18067, this.method_23318() + (double)(this.field_5974.nextFloat() * this.method_18377((class_4050)class_4050.field_18076).field_18068), this.method_23321() + this.field_5974.nextGaussian() * (double)this.method_18377((class_4050)class_4050.field_18076).field_18067, 0.0, 0.0, 0.0);
        }
        ProtagonistHandler.removeProtagonist(this.field_6002, this);
        this.method_5650();
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.method_5952(true);
        if (spawnReason != class_3730.field_16467) {
            this.field_6011.method_12778(VARIANT, (Object)this.field_5974.nextInt(4));
            this.field_6011.method_12778(STAGE, (Object)this.field_5974.nextInt(4));
        }
        this.method_5964(difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public void method_6078(class_1282 source) {
        if (!this.field_6002.field_9236 && this.getTargetUUID().isPresent() && this.getStage() < 3) {
            this.field_6002.method_8421((class_1297)this, (byte)10);
        }
        super.method_6078(source);
    }

    protected void method_6108() {
        if (this.getTargetUUID().isPresent() && this.getStage() < 3) {
            if ((this.method_6065() instanceof class_1657 || this.method_6065() instanceof class_1321 && this.getTargetUUID().isPresent() && this.getTargetUUID().get().equals(((class_1321)this.method_6065()).method_6139())) && !this.field_6002.field_9236) {
                ProtagonistHandler.levelProtagonist(this.field_6002, this);
            }
            this.method_5650();
        } else {
            if (!this.field_6002.field_9236) {
                if (this.getTargetUUID().isPresent() && this.method_6065() instanceof class_3222) {
                    try {
                        AdvancementHandler.grantAdvancement(new class_2960("miskatonicmysteries", "misc/true_villain"), "truly_kill_protagonist", (class_3222)this.method_6065());
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                }
                ProtagonistHandler.removeProtagonist(this.field_6002, this);
            }
            ++this.field_6213;
            if (this.field_6213 == 40) {
                this.method_5650();
                for (int i = 0; i < 20; ++i) {
                    double d = this.field_5974.nextGaussian() * 0.02;
                    double e = this.field_5974.nextGaussian() * 0.02;
                    double f = this.field_5974.nextGaussian() * 0.02;
                    this.field_6002.method_8406((class_2394)class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d, e, f);
                }
            }
        }
    }

    protected boolean method_5955(class_1799 newStack, class_1799 oldStack) {
        return oldStack.method_7960() && (this.isValidRangedItem(newStack.method_7909()) || newStack.method_7909() instanceof class_1829);
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
    }

    protected void method_5964(class_1266 difficulty) {
        super.method_5964(difficulty);
        ARMOR_MAP.keySet().stream().filter(e -> this.getStage() >= ARMOR_MAP.get(e)).sorted(Comparator.comparingInt(ARMOR_MAP::get).reversed()).forEachOrdered(entry -> {
            if (!this.method_6084((class_1304)entry.getKey()) && this.field_5974.nextFloat() < 0.75f) {
                this.method_5673((class_1304)entry.getKey(), (class_1799)entry.getValue());
            }
        });
        WEAPON_MAP.keySet().stream().filter(stack -> this.getStage() >= WEAPON_MAP.get(stack)).sorted(Comparator.comparingInt(WEAPON_MAP::get).reversed()).forEachOrdered(stack -> {
            if (this.method_5998(class_1268.field_5808).method_7960() && this.field_5974.nextFloat() < 0.7f) {
                this.method_6122(class_1268.field_5808, (class_1799)stack);
            }
        });
        if (this.method_5998(class_1268.field_5808).method_7960()) {
            this.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8371));
        }
        ALT_WEAPON_MAP.keySet().stream().filter(stack -> this.getStage() >= ALT_WEAPON_MAP.get(stack)).sorted(Comparator.comparingInt(ALT_WEAPON_MAP::get).reversed()).forEachOrdered(stack -> {
            if (this.alternateWeapon.method_7960() && this.field_5974.nextFloat() < 0.6f) {
                this.alternateWeapon = stack;
            }
        });
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        super.method_5673(slot, stack);
    }

    public void method_6007() {
        this.method_6119();
        super.method_6007();
    }

    public void method_5650() {
        if (!this.field_6002.field_9236 && this.getTargetUUID().isPresent()) {
            ProtagonistHandler.setSpawnState(this, false);
        }
        super.method_5650();
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public int getStage() {
        return (Integer)this.field_6011.method_12789(STAGE);
    }

    public void setStage(int stage) {
        this.field_6011.method_12778(STAGE, (Object)stage);
    }

    @Nullable
    public class_1657 getTargetPlayer() {
        return this.getTargetUUID().isPresent() ? this.field_6002.method_18470(this.getTargetUUID().get()) : null;
    }

    public void setTargetUUID(UUID targetUUID) {
        this.field_6011.method_12778(TARGET_UUID, Optional.of(targetUUID));
    }

    public Optional<UUID> getTargetUUID() {
        return (Optional)this.field_6011.method_12789(TARGET_UUID);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant());
        tag.method_10569("Stage", this.getStage());
        class_2487 alternateWeaponTag = new class_2487();
        this.alternateWeapon.method_7953(alternateWeaponTag);
        tag.method_10566("AlternateWeapon", (class_2520)alternateWeaponTag);
        tag.method_10556("Charging", ((Boolean)this.field_6011.method_12789(LOADING)).booleanValue());
        if (this.getTargetUUID().isPresent()) {
            tag.method_25927("PlayerUUID", this.getTargetUUID().get());
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(VARIANT, (Object)tag.method_10550("Variant"));
        this.setStage(tag.method_10550("Stage"));
        this.alternateWeapon = class_1799.method_7915((class_2487)((class_2487)tag.method_10580("AlternateWeapon")));
        this.method_7110(tag.method_10577("Charging"));
        if (tag.method_10545("PlayerUUID")) {
            this.setTargetUUID(tag.method_25926("PlayerUUID"));
        }
    }

    public void switchWeapons() {
        if (!this.alternateWeapon.method_7960()) {
            class_1799 stack = this.method_6047();
            this.method_6122(class_1268.field_5808, this.alternateWeapon);
            this.alternateWeapon = stack;
        }
    }

    private boolean isValidRangedItem(class_1792 item) {
        return item instanceof GunItem || item instanceof class_1811;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 itemStack = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102)));
        class_1665 persistentProjectileEntity = class_1675.method_18813((class_1309)this, (class_1799)itemStack, (float)pullProgress);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = class_3532.method_15368((double)(d * d + f * f));
        persistentProjectileEntity.method_7485(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14600, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)persistentProjectileEntity);
    }

    public void method_7110(boolean charging) {
        this.field_6011.method_12778(LOADING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(LOADING);
    }

    public void method_18811(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        this.method_24652((class_1309)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void method_24651() {
    }

    public boolean method_17326() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 10) {
            int i;
            for (i = 0; i < 10; ++i) {
                this.field_6002.method_8406((class_2394)MMParticles.FLAME, this.method_23317() + this.field_5974.nextGaussian() * (double)MMEntities.PROTAGONIST.method_17685(), this.method_23318() + (double)(this.field_5974.nextFloat() * MMEntities.PROTAGONIST.method_17686()), this.method_23321() + this.field_5974.nextGaussian() * (double)MMEntities.PROTAGONIST.method_17685(), 1.0, 0.0, 0.0);
            }
            for (i = 0; i < 15; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11237, this.method_23317() + this.field_5974.nextGaussian() * (double)MMEntities.PROTAGONIST.method_17685(), this.method_23318() + (double)(this.field_5974.nextFloat() * MMEntities.PROTAGONIST.method_17686()), this.method_23321() + this.field_5974.nextGaussian() * (double)MMEntities.PROTAGONIST.method_17685(), 0.0, 0.0, 0.0);
            }
        } else {
            super.method_5711(status);
        }
    }

    public void setData(ProtagonistData data) {
        this.setStage(data.level);
        this.field_6011.method_12778(VARIANT, (Object)data.skin);
        this.method_5996(class_5134.field_23716).method_26837(MODIFIER_MAP.getOrDefault(data.level, DEFAULT_MOD));
    }

    static {
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8873)), 0);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8218)), 0);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8523)), 1);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8396)), 1);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8058)), 2);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8348)), 2);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6174, new class_1799((class_1935)class_1802.field_22028)), 3);
        ARMOR_MAP.put(new AbstractMap.SimpleEntry<class_1304, class_1799>(class_1304.field_6172, new class_1799((class_1935)class_1802.field_22029)), 3);
        WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_8371), 0);
        WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_8475), 0);
        WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_8802), 2);
        WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_8556), 2);
        WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_22022), 3);
        WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_22025), 3);
        ALT_WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_8102), 0);
        ALT_WEAPON_MAP.put(new class_1799((class_1935)class_1802.field_8399), 1);
        ALT_WEAPON_MAP.put(new class_1799((class_1935)MMObjects.REVOLVER), 2);
        ALT_WEAPON_MAP.put(new class_1799((class_1935)MMObjects.RIFLE), 3);
        MODIFIER_MAP.put(0, DEFAULT_MOD);
        MODIFIER_MAP.put(1, new class_1322("8dd16ced-6e54-4f36-85a6-2fa9db05f08a", 5.0, class_1322.class_1323.field_6328));
        MODIFIER_MAP.put(2, new class_1322("abddf77b-7875-42cb-afd1-a90dd15c6174", 10.0, class_1322.class_1323.field_6328));
        MODIFIER_MAP.put(3, new class_1322("4b41f63d-4a31-48be-ac60-cea6e8a4e955", 15.0, class_1322.class_1323.field_6328));
    }

    public static class ProtagonistData {
        public int level;
        public int skin;
        public boolean spawned;

        public ProtagonistData(int level, int skin, boolean spawned) {
            this.level = level;
            this.skin = skin;
            this.spawned = spawned;
        }

        public void toTag(class_2487 compoundTag) {
            compoundTag.method_10569("Stage", this.level);
            compoundTag.method_10569("Variant", this.skin);
            compoundTag.method_10556("Spawned", this.spawned);
        }

        public static ProtagonistData fromTag(class_2487 compoundTag) {
            return new ProtagonistData(compoundTag.method_10550("Stage"), compoundTag.method_10550("Variant"), compoundTag.method_10577("Spawned"));
        }
    }

    public static class SwitchWeaponsGoal
    extends class_1352 {
        private final ProtagonistEntity protagonist;

        public SwitchWeaponsGoal(ProtagonistEntity protagonist) {
            this.protagonist = protagonist;
        }

        public boolean method_6264() {
            return this.protagonist.method_5968() != null && this.shouldSwitchWeapon();
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6269() {
            super.method_6269();
            this.protagonist.switchWeapons();
        }

        private boolean shouldSwitchWeapon() {
            if (this.protagonist.method_6047().method_7960()) {
                return true;
            }
            if (this.protagonist.isValidRangedItem(this.protagonist.method_6047().method_7909())) {
                return this.protagonist.alternateWeapon.method_7909() instanceof class_1829 && this.protagonist.method_5739((class_1297)this.protagonist.method_5968()) < 4.0f;
            }
            return this.protagonist.method_5739((class_1297)this.protagonist.method_5968()) > 4.0f && this.protagonist.isValidRangedItem(this.protagonist.alternateWeapon.method_7909());
        }
    }
}

