/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.entity;

import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.interfaces.Affiliated;
import com.miskatonicmysteries.api.interfaces.Ascendant;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.SpellEffect;
import com.miskatonicmysteries.api.registry.SpellMedium;
import com.miskatonicmysteries.common.entity.CastingMob;
import com.miskatonicmysteries.common.entity.ai.CastSpellGoal;
import com.miskatonicmysteries.common.feature.spell.Spell;
import com.miskatonicmysteries.common.handler.ascension.HasturAscensionHandler;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.EffectParticlePacket;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.VisionPacket;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMParticles;
import com.miskatonicmysteries.common.registry.MMSpellEffects;
import com.miskatonicmysteries.common.registry.MMSpellMediums;
import com.miskatonicmysteries.common.util.Util;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1409;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4255;
import net.minecraft.class_5425;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TatteredPrinceEntity
extends class_1314
implements IAnimatable,
Affiliated,
CastingMob {
    private final class_3213 bossBar;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected static final class_2940<Integer> CASTING_TIME_LEFT = class_2945.method_12791(TatteredPrinceEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> BLESSING_TIME = class_2945.method_12791(TatteredPrinceEntity.class, (class_2941)class_2943.field_13327);
    @Nullable
    public Spell currentSpell;
    public class_1309 blessTarget;

    public TatteredPrinceEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795);
        ((class_1409)this.method_5942()).method_6363(true);
        this.method_5942().method_6354(true);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CASTING_TIME_LEFT, (Object)0);
        this.field_6011.method_12784(BLESSING_TIME, (Object)0);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!player.field_6002.field_9236 && this.getBlessingTicks() <= 0 && MiskatonicMysteriesAPI.canLevelUp(Ascendant.of(player).get(), Affiliated.of(player).get(), 2, this.getAffiliation(false))) {
            class_243 pos = Util.getYawRelativePos(this.method_19538().method_1031(0.0, 2.0, 0.0), 2.5, this.field_6031, 0.0f);
            class_243 motionVec = new class_243(pos.field_1352 - player.method_23317(), pos.field_1351 - player.method_23318(), pos.field_1350 - player.method_23321());
            if (motionVec.method_1033() < 4.0) {
                this.setBlessTarget((class_1309)player);
                this.field_6011.method_12778(BLESSING_TIME, (Object)0);
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_5849) {
            return false;
        }
        if (this.method_5655()) {
            return true;
        }
        return damageSource != class_1282.field_5846 && damageSource != class_1282.field_5869 && damageSource.method_5529() == null;
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.method_6510()) {
            this.method_6025(1.0f);
        }
        if (this.isCasting() && this.currentSpell != null && !this.field_6002.field_9236) {
            EffectParticlePacket.send(this);
            if (this.method_5968() == null) {
                this.setCastTime(0);
            }
        }
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5773() {
        if (this.field_6002.field_9236 && this.getBlessingTicks() > 0) {
            class_243 pos = Util.getYawRelativePos(this.method_19538(), 2.5, this.field_6031, 0.0f);
            this.field_6002.method_8406((class_2394)MMParticles.AMBIENT, pos.field_1352 + this.field_5974.nextGaussian() * 1.5, pos.field_1351 + 2.0 + (double)(this.field_5974.nextFloat() * 1.5f), pos.field_1350 + this.field_5974.nextGaussian() * 1.5, 1.0, (double)this.field_5974.nextFloat(), 0.0);
        }
        super.method_5773();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_4255((class_1308)this, false));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new BlessGoal());
        this.field_6201.method_6277(3, new CastSpellGoal<TatteredPrinceEntity>(this));
        this.field_6201.method_6277(4, (class_1352)new SwingAtTargetGoal());
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 12.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{TatteredPrinceEntity.class}));
        super.method_5959();
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return world.method_8390(TatteredPrinceEntity.class, this.method_5829().method_1009(50.0, 50.0, 50.0), null).size() < 1;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 20.0f, this::animationPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement_controller", 20.0f, this::movementAnimationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public <P extends IAnimatable> PlayState animationPredicate(AnimationEvent<P> event) {
        if (this.getBlessingTicks() > 100) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("bless", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.method_6055(1.0f) > 0.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack_melee", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.getCastTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack_yeet_loop", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking_upper", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("body_idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public <P extends IAnimatable> PlayState movementAnimationPredicate(AnimationEvent<P> event) {
        boolean isMoving;
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean bl = isMoving = !(limbSwingAmount > -0.4f) || !(limbSwingAmount < 0.4f);
        if (isMoving) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking_lower", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("tentacle_idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public void method_6007() {
        int maxProgress = 40;
        int hitTick = 20;
        if (this.field_6252) {
            ++this.field_6279;
            if (this.field_6279 == hitTick && this.method_5968() != null) {
                this.method_6121((class_1297)this.method_5968());
            }
            if (this.field_6279 >= maxProgress) {
                this.field_6279 = 0;
                this.field_6252 = false;
            }
        } else {
            this.field_6279 = 0;
        }
        this.field_6251 = (float)this.field_6279 / (float)maxProgress;
        super.method_6007();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Casting", this.getCastTime());
        if (this.currentSpell != null) {
            class_2487 spell = this.currentSpell.toTag(new class_2487());
            tag.method_10566("Spell", (class_2520)spell);
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        if (tag.method_10545("Spell")) {
            this.currentSpell = Spell.fromTag((class_2487)tag.method_10580("Spell"));
        }
        this.setCastTime(tag.method_10550("Casting"));
    }

    @Override
    public void setCastTime(int castTime) {
        this.field_6011.method_12778(CASTING_TIME_LEFT, (Object)castTime);
    }

    @Override
    public int getCastTime() {
        return (Integer)this.field_6011.method_12789(CASTING_TIME_LEFT);
    }

    @Override
    public boolean isCasting() {
        return (Integer)this.field_6011.method_12789(CASTING_TIME_LEFT) > 0;
    }

    @Override
    @Nullable
    public Spell getCurrentSpell() {
        return this.currentSpell;
    }

    @Override
    public void setCurrentSpell(@Nullable Spell currentSpell) {
        this.currentSpell = currentSpell;
    }

    @Override
    public Spell selectSpell() {
        SpellMedium medium = MMSpellMediums.BOLT;
        SpellEffect effect = MMSpellEffects.DAMAGE;
        return new Spell(medium, effect, 2 + this.field_6002.field_9229.nextInt(3));
    }

    public void setBlessTarget(class_1309 blessTarget) {
        this.blessTarget = blessTarget;
    }

    @Nullable
    public class_1309 getBlessTarget() {
        return this.blessTarget;
    }

    public void startBlessing() {
        this.field_6011.method_12778(BLESSING_TIME, (Object)204);
    }

    public void decreaseBlessingTicks() {
        this.field_6011.method_12778(BLESSING_TIME, (Object)(this.getBlessingTicks() - 1));
    }

    public int getBlessingTicks() {
        return (Integer)this.field_6011.method_12789(BLESSING_TIME);
    }

    @Override
    public Affiliation getAffiliation(boolean apparent) {
        return MMAffiliations.HASTUR;
    }

    @Override
    public boolean isSupernatural() {
        return true;
    }

    public class SwingAtTargetGoal
    extends class_1352 {
        private int updateCountdownTicks;

        public SwingAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return TatteredPrinceEntity.this.method_5968() != null;
        }

        public boolean method_6266() {
            if (!this.method_6264()) {
                return false;
            }
            class_1309 target = TatteredPrinceEntity.this.method_5968();
            return !(target instanceof class_1657) || !target.method_7325() && !((class_1657)target).method_7337();
        }

        public void method_6269() {
            TatteredPrinceEntity.this.method_19540(true);
            this.updateCountdownTicks = 0;
        }

        public void method_6270() {
            class_1309 livingEntity = TatteredPrinceEntity.this.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                TatteredPrinceEntity.this.method_5980(null);
            }
            TatteredPrinceEntity.this.method_19540(false);
            TatteredPrinceEntity.this.method_5942().method_6340();
        }

        public void method_6268() {
            class_1309 target = TatteredPrinceEntity.this.method_5968();
            double d = TatteredPrinceEntity.this.method_5858((class_1297)target);
            this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
            if (TatteredPrinceEntity.this.method_6057((class_1297)target) && this.updateCountdownTicks <= 0 || TatteredPrinceEntity.this.method_5858((class_1297)target) >= 1.0 || TatteredPrinceEntity.this.method_6051().nextFloat() < 0.05f) {
                this.updateCountdownTicks = 4 + TatteredPrinceEntity.this.method_6051().nextInt(7);
                if (d > 1024.0) {
                    this.updateCountdownTicks += 10;
                } else if (d > 256.0) {
                    this.updateCountdownTicks += 5;
                }
                if (!TatteredPrinceEntity.this.method_5942().method_6335((class_1297)target, 1.0)) {
                    this.updateCountdownTicks += 15;
                }
            }
            TatteredPrinceEntity.this.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            if (this.getSquaredMaxAttackDistance(target) >= TatteredPrinceEntity.this.method_5858((class_1297)target) && !TatteredPrinceEntity.this.field_6252) {
                TatteredPrinceEntity.this.method_6104(class_1268.field_5808);
            }
        }

        protected double getSquaredMaxAttackDistance(class_1309 entity) {
            return TatteredPrinceEntity.this.method_17681() * 2.0f * TatteredPrinceEntity.this.method_17681() * 2.0f + entity.method_17681();
        }
    }

    public class BlessGoal
    extends class_1352 {
        public BlessGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return !TatteredPrinceEntity.this.method_6510() && TatteredPrinceEntity.this.getBlessTarget() != null && TatteredPrinceEntity.this.getBlessingTicks() == 0;
        }

        public void method_6269() {
            TatteredPrinceEntity.this.startBlessing();
        }

        public boolean method_6266() {
            return TatteredPrinceEntity.this.getBlessTarget() != null && TatteredPrinceEntity.this.getBlessingTicks() > 0;
        }

        public void method_6270() {
            TatteredPrinceEntity.this.setBlessTarget(null);
        }

        public void method_6268() {
            if (TatteredPrinceEntity.this.getBlessTarget() == null || TatteredPrinceEntity.this.getBlessTarget().method_29504()) {
                this.method_6270();
                return;
            }
            class_1309 target = TatteredPrinceEntity.this.getBlessTarget();
            if (TatteredPrinceEntity.this.getBlessingTicks() == 100 && target instanceof class_3222) {
                VisionPacket.send((class_3222)target, new class_2960("miskatonicmysteries", "hastur_bless"));
            }
            TatteredPrinceEntity.this.method_5988().method_6226((class_1297)target, 40.0f, 40.0f);
            class_243 pos = Util.getYawRelativePos(TatteredPrinceEntity.this.method_19538(), 2.5, TatteredPrinceEntity.this.field_6031, 0.0f);
            class_243 motionVec = new class_243(pos.field_1352 - target.method_23317(), pos.field_1351 + 2.0 - target.method_23318(), pos.field_1350 - target.method_23321());
            motionVec = motionVec.method_1029().method_1021(target.method_24828() ? (double)0.1f : (double)0.084f);
            target.method_18799(motionVec);
            target.field_6037 = true;
            target.field_6007 = true;
            TatteredPrinceEntity.this.decreaseBlessingTicks();
            if (TatteredPrinceEntity.this.getBlessingTicks() <= 0) {
                HasturAscensionHandler.blessThroughPrince(TatteredPrinceEntity.this.getBlessTarget(), TatteredPrinceEntity.this);
            }
        }
    }
}

