/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.entity;

import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.interfaces.Affiliated;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.common.entity.ProtagonistEntity;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class TentacleEntity
extends class_1314
implements Affiliated,
IAnimatable {
    private class_1309 owner;
    private boolean monster = false;
    private static final class_2940<Optional<UUID>> OWNER = class_2945.method_12791(TentacleEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> SPECIFIC_TARGET = class_2945.method_12791(TentacleEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> BROAD_SWING = class_2945.method_12791(TentacleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> SIZE = class_2945.method_12791(TentacleEntity.class, (class_2941)class_2943.field_13320);
    private int maxAge = 600;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    protected TentacleEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        if (spawnReason != class_3730.field_16471) {
            this.monster = true;
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OWNER, Optional.empty());
        this.field_6011.method_12784(SPECIFIC_TARGET, Optional.empty());
        this.field_6011.method_12784(BROAD_SWING, (Object)false);
        this.field_6011.method_12784(SIZE, (Object)Float.valueOf(0.0f));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SwingAtTargetGoal());
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, false, false, this::isValidTarget));
    }

    protected boolean isValidTarget(class_1309 target) {
        if (this.getOwnerUUID().isPresent()) {
            if (target.method_5667().equals(this.getOwnerUUID().get())) {
                if (this.owner == null) {
                    this.owner = target;
                }
                return false;
            }
            if (this.owner != null && (target.equals((Object)this.owner.method_6065()) || this.owner.equals((Object)target.method_6065()))) {
                return true;
            }
        }
        if (this.getTargetUUID().isPresent() && this.getTargetUUID().get().equals(target.method_5667())) {
            return true;
        }
        if (this.monster && !(target instanceof class_1569)) {
            return true;
        }
        Affiliation affiliation = MiskatonicMysteriesAPI.getNonNullAffiliation(target, true);
        if (!this.monster && target instanceof class_1569 && (this.getAffiliation(false) == MMAffiliations.NONE || affiliation != this.getAffiliation(true))) {
            return true;
        }
        return target instanceof ProtagonistEntity;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::animationPredicate));
    }

    public <P extends IAnimatable> PlayState animationPredicate(AnimationEvent<P> event) {
        if (this.field_6252) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.isBroadSwing() ? "attack_spread" : "attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.method_6510()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("alert", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("BroadSwing", this.isBroadSwing());
        if (this.getOwnerUUID().isPresent()) {
            tag.method_25927("Owner", this.getOwnerUUID().get());
        }
        if (this.getTargetUUID().isPresent()) {
            tag.method_25927("Target", this.getTargetUUID().get());
        }
        tag.method_10556("isMonster", this.monster);
        tag.method_10569("MaxAge", this.maxAge);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(BROAD_SWING, (Object)tag.method_10577("BroadSwing"));
        this.field_6011.method_12778(OWNER, tag.method_10545("Owner") ? Optional.of(tag.method_25926("Owner")) : Optional.empty());
        this.field_6011.method_12778(SPECIFIC_TARGET, tag.method_10545("Target") ? Optional.of(tag.method_25926("Target")) : Optional.empty());
        this.monster = tag.method_10577("isMonster");
        this.maxAge = tag.method_10550("MaxAge");
    }

    public void method_5784(class_1313 type, class_243 movement) {
        if (type != class_1313.field_6305) {
            super.method_5784(type, movement);
        }
    }

    public void method_6007() {
        int hitTick;
        int maxProgress = this.isBroadSwing() ? 37 : 18;
        int n = hitTick = this.isBroadSwing() ? 15 : 10;
        if (this.field_6252) {
            ++this.field_6279;
            if (this.field_6279 == hitTick && this.method_5968() != null && this.method_5968().method_5739((class_1297)this) <= 3.0f && this.isWithinAngle(this.method_5968())) {
                this.method_6121((class_1297)this.method_5968());
            }
            if (this.field_6279 >= maxProgress) {
                this.field_6279 = 0;
                this.field_6252 = false;
            }
        } else {
            this.field_6279 = 0;
        }
        this.field_6251 = (float)this.field_6279 / (float)maxProgress;
        super.method_6007();
        this.method_18800(0.0, this.method_18798().field_1351, 0.0);
    }

    private boolean isWithinAngle(class_1309 entity) {
        class_243 vec = new class_243(this.method_23317() - entity.method_23317(), this.method_23318() - entity.method_23318(), this.method_23321() - entity.method_23321());
        double targetYaw = -Math.toDegrees(Math.atan2(-vec.field_1352, -vec.field_1350));
        if (targetYaw < 0.0) {
            targetYaw += 360.0;
        }
        this.field_6241 %= 360.0f;
        if (this.field_6241 < 0.0f) {
            this.field_6241 += 360.0f;
        }
        return Math.abs(targetYaw - (double)this.field_6241) < (double)(this.isBroadSwing() ? 60 : 15);
    }

    protected void method_5958() {
        super.method_5958();
        if (this.field_6012 < 20) {
            this.setSize(this.getSize() + 0.05f);
        } else if (this.field_6012 > this.maxAge) {
            this.setSize(this.getSize() - 0.05f);
            if (this.getSize() < 0.0f) {
                this.method_5650();
            }
        }
    }

    public float getSize() {
        return ((Float)this.field_6011.method_12789(SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.field_6011.method_12778(SIZE, (Object)Float.valueOf(size));
    }

    public boolean method_6121(class_1297 target) {
        boolean damage;
        int i;
        float f = (float)this.method_26825(class_5134.field_23721) * (float)(this.isBroadSwing() ? 1 : 2);
        float g = (float)this.method_26825(class_5134.field_23722) * (float)(this.isBroadSwing() ? 2 : 1);
        if (target instanceof class_1309) {
            f += class_1890.method_8218((class_1799)this.method_6047(), (class_1310)((class_1309)target).method_6046());
            g += (float)class_1890.method_8205((class_1309)this);
        }
        if ((i = class_1890.method_8199((class_1309)this)) > 0) {
            target.method_5639(i * 4);
        }
        if (damage = target.method_5643(class_1282.method_5511((class_1309)this), f)) {
            if (g > 0.0f && target instanceof class_1309) {
                ((class_1309)target).method_6005(g * 0.5f, (double)class_3532.method_15374((float)(this.field_6031 * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.field_6031 * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            this.method_5723((class_1309)this, target);
            this.method_6114(target);
        }
        return damage;
    }

    public void method_5697(class_1297 entity) {
    }

    public class_1309 getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        return this.field_6002.method_18470(this.getOwnerUUID().get());
    }

    public boolean isBroadSwing() {
        return (Boolean)this.field_6011.method_12789(BROAD_SWING);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_6011.method_12789(OWNER);
    }

    public Optional<UUID> getTargetUUID() {
        return (Optional)this.field_6011.method_12789(SPECIFIC_TARGET);
    }

    public void setOwner(class_1309 owner) {
        this.field_6011.method_12778(OWNER, Optional.of(owner.method_5667()));
    }

    public void setSpecificTarget(class_1309 target) {
        this.field_6011.method_12778(SPECIFIC_TARGET, Optional.of(target.method_5667()));
    }

    protected boolean method_23734() {
        return this.monster;
    }

    @Override
    public boolean isSupernatural() {
        return true;
    }

    public class SwingAtTargetGoal
    extends class_1352 {
        public SwingAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return TentacleEntity.this.method_5968() != null;
        }

        public boolean method_6266() {
            if (!this.method_6264()) {
                return false;
            }
            class_1309 target = TentacleEntity.this.method_5968();
            return !(target instanceof class_1657) || !target.method_7325() && !((class_1657)target).method_7337();
        }

        public void method_6269() {
            TentacleEntity.this.method_19540(true);
        }

        public void method_6270() {
            class_1309 livingEntity = TentacleEntity.this.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                TentacleEntity.this.method_5980(null);
            }
            TentacleEntity.this.method_19540(false);
        }

        public void method_6268() {
            class_1309 target = TentacleEntity.this.method_5968();
            TentacleEntity.this.method_5988().method_6226((class_1297)target, 40.0f, 40.0f);
            if (this.getSquaredMaxAttackDistance(target) >= TentacleEntity.this.method_5858((class_1297)target) && !TentacleEntity.this.field_6252) {
                TentacleEntity.this.field_6011.method_12778(BROAD_SWING, (Object)TentacleEntity.this.field_5974.nextBoolean());
                TentacleEntity.this.method_6104(class_1268.field_5808);
            }
        }

        protected double getSquaredMaxAttackDistance(class_1309 entity) {
            return 13.0;
        }
    }
}

