/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.interfaces.Ascendant;
import com.miskatonicmysteries.common.entity.HasturCultistEntity;
import com.miskatonicmysteries.common.entity.ProtagonistEntity;
import com.miskatonicmysteries.common.entity.ai.task.CastSpellTask;
import com.miskatonicmysteries.common.entity.ai.task.HealthCareTask;
import com.miskatonicmysteries.common.entity.ai.task.RecruitTask;
import com.miskatonicmysteries.common.entity.ai.task.TacticalApproachTask;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.EffectParticlePacket;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMBlessings;
import com.miskatonicmysteries.common.registry.MMEntities;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_3852;
import net.minecraft.class_4095;
import net.minecraft.class_4096;
import net.minecraft.class_4097;
import net.minecraft.class_4107;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4116;
import net.minecraft.class_4118;
import net.minecraft.class_4122;
import net.minecraft.class_4124;
import net.minecraft.class_4125;
import net.minecraft.class_4127;
import net.minecraft.class_4128;
import net.minecraft.class_4129;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4214;
import net.minecraft.class_4215;
import net.minecraft.class_4253;
import net.minecraft.class_4815;
import net.minecraft.class_4816;
import net.minecraft.class_4820;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_5418;

public class HasturCultistBrain {
    private static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_25361, (Object)class_4140.field_22475, (Object)class_4140.field_22355, (Object)class_4140.field_22333, (Object)class_4140.field_18438, (Object)class_4140.field_18439, (Object)class_4140.field_25160, (Object)class_4140.field_18440, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19006, (Object)class_4140.field_18443, (Object[])new class_4140[]{class_4140.field_18444, class_4140.field_22354, class_4140.field_22332, class_4140.field_18445, class_4140.field_18446, class_4140.field_18447, class_4140.field_18448, class_4140.field_18449, class_4140.field_26389, class_4140.field_19007, class_4140.field_18451, class_4140.field_18452, class_4140.field_18453, class_4140.field_18873, class_4140.field_19008, class_4140.field_19009, class_4140.field_19293, class_4140.field_19385, class_4140.field_20616, class_4140.field_19386, class_4140.field_25754});
    private static final ImmutableList<class_4149<? extends class_4148<? super class_1646>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_19010, (Object)class_4149.field_18469, (Object)class_4149.field_18470, (Object)class_4149.field_19011, (Object)class_4149.field_18875, (Object)class_4149.field_25756);

    public static void init(HasturCultistEntity entity, class_4095<class_1646> brain) {
        brain.method_18882(class_4168.field_18594, 0, HasturCultistBrain.createCoreTasks(entity, 0.65f));
        brain.method_24529(class_4168.field_18595, class_4129.method_19024((class_3852)entity.method_7231().method_16924(), (float)0.65f), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457)));
        brain.method_24527(class_4168.field_22396, 10, HasturCultistBrain.createFightTasks(entity, 0.65f), class_4140.field_22355);
        brain.method_24529(class_4168.field_18598, HasturCultistBrain.createMeetTasks(0.65f), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18440, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457)));
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
    }

    public static class_4095.class_5303<class_1646> createProfile() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    public static void tickActivities(HasturCultistEntity entity) {
        class_4095 brain = entity.method_18868();
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_18598, (Object)class_4168.field_22396, (Object)class_4168.field_18595));
        if (!entity.field_6002.field_9236) {
            if (entity.isCasting()) {
                if (entity.currentSpell != null && !entity.field_6002.field_9236) {
                    EffectParticlePacket.send(entity);
                }
                entity.setCastTime(entity.getCastTime() - 1);
            }
            if (entity.currentSpell != null && entity.getCastTime() <= 0) {
                entity.currentSpell.cast((class_1309)entity);
                entity.currentSpell = null;
                entity.method_18868().method_24525(class_4140.field_22475, (Object)true, 40L);
            }
        }
    }

    public static void onAttacked(HasturCultistEntity cultist, class_1309 attacker) {
        if (!(attacker instanceof HasturCultistEntity) && attacker instanceof class_1657 && HasturCultistBrain.shouldAttack(attacker) && !class_4215.method_24558((class_1309)cultist, (class_1309)attacker, (double)4.0)) {
            cultist.method_18868().method_18875(class_4140.field_19293);
            cultist.method_18868().method_24525(class_4140.field_22333, (Object)attacker.method_5667(), 600L);
            HasturCultistBrain.getNearbyCultists(cultist).forEach(nearbyCultist -> {
                nearbyCultist.method_18868().method_18875(class_4140.field_19293);
                nearbyCultist.method_18868().method_24525(class_4140.field_22333, (Object)attacker.method_5667(), 600L);
            });
        }
    }

    private static List<HasturCultistEntity> getNearbyCultists(HasturCultistEntity cultist) {
        return cultist.method_5770().method_8390(HasturCultistEntity.class, cultist.method_5829().method_1009(10.0, 4.0, 10.0), null);
    }

    private static Optional<class_1309> getAngryAt(class_5418 piglin) {
        return class_4215.method_24560((class_1309)piglin, (class_4140)class_4140.field_22333);
    }

    private static boolean shouldAttack(class_1309 target) {
        return class_1301.field_22280.test(target);
    }

    private static boolean isAscended(class_1309 entity) {
        return entity instanceof HasturCultistEntity && ((HasturCultistEntity)entity).isAscended();
    }

    public static Optional<? extends class_1309> getBestTarget(class_1646 cultist) {
        Optional player;
        Optional mobs;
        class_4095 brain = cultist.method_18868();
        Optional optional = class_4215.method_24560((class_1309)cultist, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && HasturCultistBrain.shouldAttack((class_1309)optional.get())) {
            return optional;
        }
        if (brain.method_18896(class_4140.field_18442) && (mobs = brain.method_18904(class_4140.field_18442)).isPresent()) {
            List mobList = (List)mobs.get();
            class_1309 bestTarget = null;
            for (class_1309 livingEntity : mobList) {
                if (Ascendant.of(livingEntity).isPresent() && MiskatonicMysteriesAPI.hasBlessing(Ascendant.of(livingEntity).get(), MMBlessings.ROYAL_ENTOURAGE)) {
                    if (livingEntity.method_6065() != null) {
                        bestTarget = livingEntity.method_6065();
                        break;
                    }
                    if (livingEntity.method_6052() != null && !(livingEntity.method_6052() instanceof class_1646)) {
                        bestTarget = livingEntity.method_6052();
                        break;
                    }
                }
                if (MiskatonicMysteriesAPI.getNonNullAffiliation(livingEntity, true) != MMAffiliations.SHUB && !(livingEntity instanceof ProtagonistEntity) && (!(livingEntity instanceof class_1569) || livingEntity instanceof class_1548) || bestTarget != null && !(livingEntity.method_5739((class_1297)cultist) < bestTarget.method_5739((class_1297)cultist))) continue;
                bestTarget = livingEntity;
            }
            if (bestTarget != null) {
                return Optional.of(bestTarget);
            }
        }
        if (brain.method_18896(class_4140.field_18444) && (player = brain.method_18904(class_4140.field_18444)).isPresent() && cultist.method_20594((class_1657)player.get()) <= -100) {
            return player;
        }
        return Optional.empty();
    }

    private static boolean isPreferredAttackTarget(HasturCultistEntity cultist, class_1309 target) {
        return HasturCultistBrain.getBestTarget(cultist).filter(livingEntity2 -> livingEntity2 == target).isPresent();
    }

    public static ImmutableList<class_4097<? super class_1646>> createCoreTasks(HasturCultistEntity cultist, float f) {
        return ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4107(), (Object)new class_4110(45, 90), (Object)new class_4824(HasturCultistBrain::getBestTarget), (Object)new class_4829(), (Object)new class_4214(), (Object)new class_4253(), (Object)new class_4112(), (Object)new class_4124(), (Object)((Object)new HealthCareTask()), (Object)new class_4815(f, false, 4), (Object)new class_4096(MMEntities.HASTUR_POI, MMEntities.CONGREGATION_POINT, class_4140.field_18438, true, Optional.empty()), (Object[])new class_4097[]{new class_4096(class_4158.field_18518, class_4140.field_18440, true, Optional.of((byte)14)), new class_4828(livingEntity -> !HasturCultistBrain.isPreferredAttackTarget(cultist, livingEntity))});
    }

    public static ImmutableList<Pair<Integer, ? extends class_4097<? super class_1646>>> createMeetTasks(float f) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)new class_4116(class_4140.field_18440, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new class_4116(MMEntities.CONGREGATION_POINT, 0.4f, 80), (Object)2), (Object)Pair.of((Object)new class_4124(), (Object)2), (Object)Pair.of((Object)((Object)new RecruitTask()), (Object)3)))), (Object)Pair.of((Object)2, (Object)new class_4124()), (Object)Pair.of((Object)3, (Object)((Object)new RecruitTask())), (Object)Pair.of((Object)2, (Object)new class_4122(class_4140.field_18440, f, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new class_4128(class_4158.field_18518, class_4140.field_18440)), (Object)Pair.of((Object)99, (Object)new class_4127()));
    }

    public static ImmutableList<class_4097<? super class_1646>> createFightTasks(HasturCultistEntity cultist, float f) {
        return ImmutableList.of((Object)new class_4828(livingEntity -> !HasturCultistBrain.isPreferredAttackTarget(cultist, livingEntity)), (Object)new class_4820(HasturCultistBrain::isAscended, (class_4097)new CastSpellTask()), (Object)((Object)new TacticalApproachTask(f, mob -> mob instanceof HasturCultistEntity && ((HasturCultistEntity)mob).isCasting())), (Object)new class_4816(15));
    }
}

