/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature;

import com.miskatonicmysteries.api.interfaces.Affiliated;
import com.miskatonicmysteries.api.interfaces.Ascendant;
import com.miskatonicmysteries.api.interfaces.MalleableAffiliated;
import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.Blessing;
import com.miskatonicmysteries.api.registry.InsanityEvent;
import com.miskatonicmysteries.api.registry.SpellEffect;
import com.miskatonicmysteries.api.registry.SpellMedium;
import com.miskatonicmysteries.common.feature.spell.Spell;
import com.miskatonicmysteries.common.feature.world.MMWorldState;
import com.miskatonicmysteries.common.handler.ProtagonistHandler;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.ModifyBlessingPacket;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.VisionPacket;
import com.miskatonicmysteries.common.registry.MMRegistries;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ModCommand {
    public static void setup() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"miskmyst").requires(source -> source.method_9259(2));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").executes(context -> ModCommand.giveStatFeedback((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.giveStatFeedback((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player")))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sanity").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> ModCommand.giveSanityFeedback((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.giveSanityFeedback((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()])))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getMax").executes(context -> ModCommand.giveMaxSanityFeedback((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.giveMaxSanityFeedback((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()])))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> ModCommand.setSanity((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.setSanity((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()]))))))).then(class_2170.method_9247((String)"playInsanityEvent").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)InsanityEventArgumentType.insanityEvent()).executes(context -> ModCommand.playInsanityEvent((CommandContext<class_2168>)context, InsanityEventArgumentType.getInsanityEvent(context, "id"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.playInsanityEvent((CommandContext<class_2168>)context, InsanityEventArgumentType.getInsanityEvent(context, "id"), class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()]))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sanityExpansion").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ModCommand.addSanityExpansion((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.addSanityExpansion((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[0])))))))).then(class_2170.method_9247((String)"remove").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ModCommand.removeSanityExpansion((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.removeSanityExpansion((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()]))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(context -> ModCommand.clearSanityExpansions((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.clearSanityExpansions((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()])))))));
        LiteralArgumentBuilder blessingBuilder = class_2170.method_9247((String)"blessings");
        LiteralArgumentBuilder addBlessingBuilder = class_2170.method_9247((String)"addBlessing");
        LiteralArgumentBuilder removeBlessingBuilder = class_2170.method_9247((String)"removeBlessing");
        for (class_2960 blessingId : MMRegistries.BLESSINGS.method_10235()) {
            addBlessingBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)blessingId.toString()).executes(context -> ModCommand.addBlessing((CommandContext<class_2168>)context, blessingId, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.addBlessing((CommandContext<class_2168>)context, blessingId, class_2186.method_9315((CommandContext)context, (String)"player")))));
            removeBlessingBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)blessingId.toString()).executes(context -> ModCommand.removeBlessing((CommandContext<class_2168>)context, blessingId, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.removeBlessing((CommandContext<class_2168>)context, blessingId, class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        blessingBuilder.then((ArgumentBuilder)addBlessingBuilder);
        blessingBuilder.then((ArgumentBuilder)removeBlessingBuilder);
        blessingBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> ModCommand.giveBlessingFeedback((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.giveBlessingFeedback((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player")))));
        builder.then((ArgumentBuilder)blessingBuilder);
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"world").then(class_2170.method_9247((String)"getNBT").executes(context -> ModCommand.giveWorldNBT((CommandContext<class_2168>)context)))).then(class_2170.method_9247((String)"clear").executes(context -> ModCommand.clearWorldNBT((CommandContext<class_2168>)context))));
        LiteralArgumentBuilder ascensionBuilder = class_2170.method_9247((String)"ascension");
        ascensionBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> ModCommand.giveAscensionFeedback((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.giveAscensionFeedback((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player")))));
        LiteralArgumentBuilder setAscensionBuilder = class_2170.method_9247((String)"set");
        for (class_2960 id : MMRegistries.AFFILIATIONS.method_10235()) {
            setAscensionBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)id.toString()).executes(context -> ModCommand.setAscension((CommandContext<class_2168>)context, id, Ascendant.of(((class_2168)context.getSource()).method_9207()).get().getAscensionStage(), ((class_2168)context.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(context -> ModCommand.setAscension((CommandContext<class_2168>)context, id, IntegerArgumentType.getInteger((CommandContext)context, (String)"stage"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.setAscension((CommandContext<class_2168>)context, id, IntegerArgumentType.getInteger((CommandContext)context, (String)"stage"), class_2186.method_9315((CommandContext)context, (String)"player"))))));
        }
        ascensionBuilder.then((ArgumentBuilder)setAscensionBuilder);
        builder.then((ArgumentBuilder)ascensionBuilder);
        LiteralArgumentBuilder spellBuilder = class_2170.method_9247((String)"spells");
        spellBuilder.then(class_2170.method_9247((String)"setMax").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(context -> ModCommand.setMaxSpells((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.setMaxSpells((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()]))))));
        spellBuilder.then(class_2170.method_9247((String)"setPowerPool").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)30)).executes(context -> ModCommand.setPowerPool((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.setPowerPool((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), class_2186.method_9312((CommandContext)context, (String)"player").toArray(new class_3222[class_2186.method_9312((CommandContext)context, (String)"player").size()]))))));
        LiteralArgumentBuilder learnSpellBuilder = class_2170.method_9247((String)"learnEffect");
        for (Object effectId : MMRegistries.SPELL_EFFECTS.method_10235()) {
            learnSpellBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)effectId.toString()).executes(arg_0 -> ModCommand.lambda$setup$34((class_2960)effectId, arg_0))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(arg_0 -> ModCommand.lambda$setup$35((class_2960)effectId, arg_0))));
        }
        spellBuilder.then((ArgumentBuilder)learnSpellBuilder);
        LiteralArgumentBuilder removeSpellBuilder = class_2170.method_9247((String)"removeEffect");
        for (Object effectId : MMRegistries.SPELL_EFFECTS.method_10235()) {
            removeSpellBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)effectId.toString()).executes(arg_0 -> ModCommand.lambda$setup$36((class_2960)effectId, arg_0))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(arg_0 -> ModCommand.lambda$setup$37((class_2960)effectId, arg_0))));
        }
        spellBuilder.then((ArgumentBuilder)removeSpellBuilder);
        LiteralArgumentBuilder learnMedium = class_2170.method_9247((String)"learnMedium");
        for (Object mediumId : MMRegistries.SPELL_MEDIUMS.method_10235()) {
            learnMedium.then(((LiteralArgumentBuilder)class_2170.method_9247((String)mediumId.toString()).executes(arg_0 -> ModCommand.lambda$setup$38((class_2960)mediumId, arg_0))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(arg_0 -> ModCommand.lambda$setup$39((class_2960)mediumId, arg_0))));
        }
        spellBuilder.then((ArgumentBuilder)learnMedium);
        LiteralArgumentBuilder removeMedium = class_2170.method_9247((String)"removeMedium");
        for (Object mediumId : MMRegistries.SPELL_MEDIUMS.method_10235()) {
            removeMedium.then(((LiteralArgumentBuilder)class_2170.method_9247((String)mediumId.toString()).executes(arg_0 -> ModCommand.lambda$setup$40((class_2960)mediumId, arg_0))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(arg_0 -> ModCommand.lambda$setup$41((class_2960)mediumId, arg_0))));
        }
        spellBuilder.then((ArgumentBuilder)removeMedium);
        builder.then((ArgumentBuilder)spellBuilder);
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"summonInvestigator").executes(context -> ModCommand.spawnProtagonist((CommandContext<class_2168>)context, (class_1657)((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.spawnProtagonist((CommandContext<class_2168>)context, (class_1657)class_2186.method_9315((CommandContext)context, (String)"player")))));
        LiteralArgumentBuilder castingBuilder = class_2170.method_9247((String)"cast");
        for (class_2960 mediumId : MMRegistries.SPELL_MEDIUMS.method_10235()) {
            LiteralArgumentBuilder mediumBuilder = class_2170.method_9247((String)mediumId.toString());
            for (class_2960 effectId : MMRegistries.SPELL_EFFECTS.method_10235()) {
                mediumBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)effectId.toString()).executes(context -> ModCommand.castSpell(mediumId, effectId, 0, (class_1309)((class_2168)context.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"intensity", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> ModCommand.castSpell(mediumId, effectId, IntegerArgumentType.getInteger((CommandContext)context, (String)"intensity"), (class_1309)((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"\u0441aster", (ArgumentType)class_2186.method_9305()).executes(context -> ModCommand.castSpell(mediumId, effectId, IntegerArgumentType.getInteger((CommandContext)context, (String)"intensity"), (class_1309)class_2186.method_9315((CommandContext)context, (String)"\u0441aster"))))));
            }
            castingBuilder.then((ArgumentBuilder)mediumBuilder);
        }
        builder.then((ArgumentBuilder)castingBuilder);
        LiteralArgumentBuilder visionBuilder = class_2170.method_9247((String)"playVision");
        visionBuilder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(context -> ModCommand.displayVision((CommandContext<class_2168>)context, class_2232.method_9443((CommandContext)context, (String)"id"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> ModCommand.displayVision((CommandContext<class_2168>)context, class_2232.method_9443((CommandContext)context, (String)"id"), class_2186.method_9312((CommandContext)context, (String)"players").toArray(new class_3222[0])))));
        builder.then((ArgumentBuilder)visionBuilder);
        CommandRegistrationCallback.EVENT.register((displatcher, b) -> displatcher.register(builder));
    }

    private static int displayVision(CommandContext<class_2168> context, class_2960 visionId, class_3222 ... players) {
        for (class_3222 player : players) {
            VisionPacket.send(player, visionId);
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.display_vision", new Object[]{visionId.toString(), player.method_5476()}), true);
        }
        return players.length > 0 ? 15 : 0;
    }

    private static int castSpell(class_2960 mediumId, class_2960 effectId, int intensity, class_1309 caster) {
        SpellEffect effect;
        SpellMedium medium = (SpellMedium)MMRegistries.SPELL_MEDIUMS.method_10223(mediumId);
        Spell spell = new Spell(medium, effect = (SpellEffect)MMRegistries.SPELL_EFFECTS.method_10223(effectId), intensity);
        return spell.cast(caster) ? 15 : 0;
    }

    private static int spawnProtagonist(CommandContext<class_2168> context, class_1657 player) {
        boolean spawned = ProtagonistHandler.spawnProtagonist(((class_2168)context.getSource()).method_9225(), player);
        if (spawned) {
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.summon_investigator", new Object[]{player.method_5476()}), true);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("miskatonicmysteries.command.summon_investigator.failure"));
        }
        return spawned ? 15 : 0;
    }

    private static int giveWorldNBT(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(MMWorldState.get((class_1937)((class_2168)context.getSource()).method_9225()).method_75(new class_2487()).method_10715(), false);
        return 0;
    }

    private static int clearWorldNBT(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(MMWorldState.get((class_1937)((class_2168)context.getSource()).method_9225()).clear(), false);
        return 0;
    }

    private static int playInsanityEvent(CommandContext<class_2168> context, class_2960 id, class_3222 ... players) {
        InsanityEvent event = (InsanityEvent)MMRegistries.INSANITY_EVENTS.method_10223(id);
        if (event != null) {
            for (class_3222 player : players) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.execute_insanity_event", new Object[]{id.toString()}), false);
                Sanity.of(player).ifPresent(sanity -> event.execute((class_1657)player, (Sanity)sanity));
            }
            return 10;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("miskatonicmysteries.command.execute_insanity_event.failure", new Object[]{id.toString()}));
        return 0;
    }

    private static int clearSanityExpansions(CommandContext<class_2168> context, class_3222 ... players) {
        for (class_3222 player : players) {
            Sanity.of(player).ifPresent(sanity -> {
                if (sanity.getSanityCapExpansions().isEmpty()) {
                    ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("miskatonicmysteries.command.clear_expansions.none_failure", new Object[]{player.method_5476()}));
                } else {
                    sanity.getSanityCapExpansions().forEach((s, i) -> ModCommand.removeSanityExpansion(context, s, player));
                }
            });
        }
        return 0;
    }

    private static int addSanityExpansion(CommandContext<class_2168> context, String name, int value, class_3222 ... players) {
        for (class_3222 player : players) {
            Sanity.of(player).ifPresent(sanity -> {
                boolean contains = sanity.getSanityCapExpansions().containsKey(name);
                if (contains) {
                    ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("miskatonicmysteries.command.add_sanity_expansion.contains_failure", new Object[]{name, player.method_5476()}));
                } else {
                    ((Sanity)player).addSanityCapExpansion(name, value);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.add_sanity_expansion", new Object[]{name, value, player.method_5476()}), true);
                }
            });
        }
        return 0;
    }

    private static int removeSanityExpansion(CommandContext<class_2168> context, String name, class_3222 ... players) {
        for (class_3222 player : players) {
            Sanity.of(player).ifPresent(sanity -> {
                boolean contains = sanity.getSanityCapExpansions().containsKey(name);
                if (!contains) {
                    ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("miskatonicmysteries.command.remove_sanity_expansion.failure", new Object[]{name, player.method_5476()}));
                } else {
                    sanity.removeSanityCapExpansion(name);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.remove_sanity_expansion", new Object[]{name, player.method_5476()}), true);
                }
            });
        }
        return 0;
    }

    private static int giveMaxSanityFeedback(CommandContext<class_2168> context, class_3222 ... players) throws CommandSyntaxException {
        int returnValue = 1000;
        for (class_3222 player : players) {
            if (!Sanity.of(player).isPresent()) continue;
            Sanity sanity = Sanity.of(player).get();
            int value = sanity.getMaxSanity();
            class_2588 expansionText = sanity.getSanityCapExpansions().isEmpty() ? new class_2588("miskatonicmysteries.command.get_max_sanity.no_expansions") : new class_2588("miskatonicmysteries.command.get_max_sanity.expansions");
            sanity.getSanityCapExpansions().forEach((arg_0, arg_1) -> ModCommand.lambda$giveMaxSanityFeedback$55((class_5250)expansionText, arg_0, arg_1));
            class_2568 hoverInfo = new class_2568(class_2568.class_5247.field_24342, (Object)expansionText);
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_max_sanity.self", new Object[]{value}).method_10862(class_2583.field_24360.method_10949(hoverInfo)), false);
            } else {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_max_sanity", new Object[]{player.method_5476(), value}).method_10862(class_2583.field_24360.method_10949(hoverInfo)), false);
            }
            if (value >= returnValue) continue;
            returnValue = value;
        }
        return Math.round(15.0f * ((float)returnValue / 1000.0f));
    }

    private static int setSanity(CommandContext<class_2168> context, int value, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!Sanity.of(player).isPresent()) continue;
            Sanity sanity = Sanity.of(player).get();
            sanity.setSanity(value, true);
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_sanity.self", new Object[]{value}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_sanity", new Object[]{player.method_5476(), value}), true);
        }
        return Math.round(15.0f * ((float)value / 1000.0f));
    }

    private static int setMaxSpells(CommandContext<class_2168> context, int value, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!SpellCaster.of(player).isPresent()) continue;
            SpellCaster caster = SpellCaster.of(player).get();
            caster.setMaxSpells(value);
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_max_spells.self", new Object[]{value}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_max_spells", new Object[]{player.method_5476(), value}), true);
        }
        return value;
    }

    private static int setPowerPool(CommandContext<class_2168> context, int value, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!SpellCaster.of(player).isPresent()) continue;
            SpellCaster caster = SpellCaster.of(player).get();
            caster.setPowerPool(value);
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_power_pool.self", new Object[]{value}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_power_pool", new Object[]{player.method_5476(), value}), true);
        }
        return value;
    }

    private static int learnSpellEffect(CommandContext<class_2168> context, class_2960 effect, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!SpellCaster.of(player).isPresent()) continue;
            SpellCaster caster = SpellCaster.of(player).get();
            caster.learnEffect((SpellEffect)MMRegistries.SPELL_EFFECTS.method_10223(effect));
            caster.syncSpellData();
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.learn_spell.self", new Object[]{effect}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.learn_spell", new Object[]{player.method_5476(), effect}), true);
        }
        return 0;
    }

    private static int removeSpellEffect(CommandContext<class_2168> context, class_2960 effect, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!SpellCaster.of(player).isPresent()) continue;
            SpellCaster caster = SpellCaster.of(player).get();
            caster.getLearnedEffects().remove(MMRegistries.SPELL_EFFECTS.method_10223(effect));
            caster.syncSpellData();
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.removed_spell.self", new Object[]{effect}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.removed_spell", new Object[]{player.method_5476(), effect}), true);
        }
        return 0;
    }

    private static int learnMedium(CommandContext<class_2168> context, class_2960 medium, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!SpellCaster.of(player).isPresent()) continue;
            SpellCaster caster = SpellCaster.of(player).get();
            caster.learnMedium((SpellMedium)MMRegistries.SPELL_MEDIUMS.method_10223(medium));
            caster.syncSpellData();
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.learn_medium.self", new Object[]{medium}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.learn_medium", new Object[]{player.method_5476(), medium}), true);
        }
        return 0;
    }

    private static int removeMedium(CommandContext<class_2168> context, class_2960 medium, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!SpellCaster.of(player).isPresent()) continue;
            SpellCaster caster = SpellCaster.of(player).get();
            caster.getLearnedMediums().remove(MMRegistries.SPELL_MEDIUMS.method_10223(medium));
            caster.syncSpellData();
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.removed_medium.self", new Object[]{medium}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.removed_medium", new Object[]{player.method_5476(), medium}), true);
        }
        return 0;
    }

    private static int addBlessing(CommandContext<class_2168> context, class_2960 blessingId, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!Ascendant.of(player).isPresent()) continue;
            Ascendant ascendant = Ascendant.of(player).get();
            if (ascendant.getBlessings().size() < 3) {
                Blessing blessing = (Blessing)MMRegistries.BLESSINGS.method_10223(blessingId);
                ascendant.addBlessing(blessing);
                ModifyBlessingPacket.send((class_1657)player, blessing, true);
                ascendant.syncBlessingData();
                if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.add_blessing.self", new Object[]{new class_2588(blessing.getTranslationString())}), true);
                    continue;
                }
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.add_blessing", new Object[]{player.method_5476(), new class_2588(blessing.getTranslationString())}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("miskatonicmysteries.command.add_blessing.failure", new Object[]{player.method_5476()}));
        }
        return 0;
    }

    private static int removeBlessing(CommandContext<class_2168> context, class_2960 blessingId, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!Ascendant.of(player).isPresent()) continue;
            Ascendant ascendant = Ascendant.of(player).get();
            Blessing blessing = (Blessing)MMRegistries.BLESSINGS.method_10223(blessingId);
            ascendant.removeBlessing(blessing);
            ModifyBlessingPacket.send((class_1657)player, blessing, false);
            ascendant.syncBlessingData();
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.remove_blessing.self", new Object[]{new class_2588(blessing.getTranslationString())}), true);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.remove_blessing", new Object[]{player.method_5476(), new class_2588(blessing.getTranslationString())}), true);
        }
        return 0;
    }

    private static int giveBlessingFeedback(CommandContext<class_2168> context, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!Ascendant.of(player).isPresent()) continue;
            Ascendant ascendant = Ascendant.of(player).get();
            int value = ascendant.getBlessings().size();
            class_2588 blessingText = new class_2588("miskatonicmysteries.command.get_blessings.blessings");
            ascendant.getBlessings().forEach(arg_0 -> ModCommand.lambda$giveBlessingFeedback$56((class_5250)blessingText, arg_0));
            class_2568 hoverInfo = new class_2568(class_2568.class_5247.field_24342, (Object)blessingText);
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_blessings.self", new Object[]{value}).method_10862(class_2583.field_24360.method_10949(hoverInfo)), false);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_blessings", new Object[]{player.method_5476(), value}).method_10862(class_2583.field_24360.method_10949(hoverInfo)), false);
        }
        return 0;
    }

    private static int giveAscensionFeedback(CommandContext<class_2168> context, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!Ascendant.of(player).isPresent() || !Affiliated.of(player).isPresent()) continue;
            Affiliation affiliation = Affiliated.of(player).get().getAffiliation(false);
            Affiliation apparentAffiliation = Affiliated.of(player).get().getAffiliation(true);
            int stage = Ascendant.of(player).get().getAscensionStage();
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_ascension.self"), false);
            } else {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_ascension", new Object[]{player.method_5476()}), false);
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_ascension.apparent_path", new Object[]{apparentAffiliation.getId()}), false);
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_ascension.path", new Object[]{affiliation.getId()}), false);
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_ascension.stage", new Object[]{stage}), false);
        }
        return 0;
    }

    private static int setAscension(CommandContext<class_2168> context, class_2960 affiliation, int stage, class_3222 ... players) throws CommandSyntaxException {
        for (class_3222 player : players) {
            if (!Ascendant.of(player).isPresent() || !Affiliated.of(player).isPresent()) continue;
            MalleableAffiliated.of(player).get().setAffiliation((Affiliation)MMRegistries.AFFILIATIONS.method_10223(affiliation), false);
            Ascendant.of(player).get().setAscensionStage(stage);
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_ascension.self", new Object[]{affiliation, stage}), false);
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.set_ascension", new Object[]{player.method_5476(), affiliation, stage}), false);
        }
        return 0;
    }

    private static int giveStatFeedback(CommandContext<class_2168> context, class_3222 player) throws CommandSyntaxException {
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.stats", new Object[]{player.method_5476()}).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), false);
        ModCommand.giveSanityFeedback(context, player);
        ModCommand.giveMaxSanityFeedback(context, player);
        ModCommand.giveBlessingFeedback(context, player);
        ModCommand.giveAscensionFeedback(context, player);
        return 0;
    }

    private static int giveSanityFeedback(CommandContext<class_2168> context, class_3222 ... players) throws CommandSyntaxException {
        int returnValue = 0;
        for (class_3222 player : players) {
            int value;
            int n = value = Sanity.of(player).isPresent() ? Sanity.of(player).get().getSanity() : 0;
            if (player.equals((Object)((class_2168)context.getSource()).method_9207())) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_sanity.self", new Object[]{value}), false);
            } else {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("miskatonicmysteries.command.get_sanity", new Object[]{player.method_5476(), value}), false);
            }
            if (value <= returnValue) continue;
            returnValue = value;
        }
        return Math.round(15.0f * ((float)returnValue / 1000.0f));
    }

    private static /* synthetic */ void lambda$giveBlessingFeedback$56(class_5250 blessingText, Blessing blessing) {
        blessingText.method_27693("\n");
        blessingText.method_10852((class_2561)new class_2585("-").method_10852((class_2561)new class_2588(blessing.getTranslationString())));
    }

    private static /* synthetic */ void lambda$giveMaxSanityFeedback$55(class_5250 expansionText, String s, Integer i) {
        expansionText.method_27693("\n");
        expansionText.method_10852((class_2561)new class_2585(s + ": ").method_10852((class_2561)new class_2585(Integer.toString(i)).method_27692(i <= 0 ? class_124.field_1061 : class_124.field_1060)));
    }

    private static /* synthetic */ int lambda$setup$41(class_2960 mediumId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.removeMedium((CommandContext<class_2168>)context, mediumId, class_2186.method_9315((CommandContext)context, (String)"player"));
    }

    private static /* synthetic */ int lambda$setup$40(class_2960 mediumId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.removeMedium((CommandContext<class_2168>)context, mediumId, ((class_2168)context.getSource()).method_9207());
    }

    private static /* synthetic */ int lambda$setup$39(class_2960 mediumId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.learnMedium((CommandContext<class_2168>)context, mediumId, class_2186.method_9315((CommandContext)context, (String)"player"));
    }

    private static /* synthetic */ int lambda$setup$38(class_2960 mediumId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.learnMedium((CommandContext<class_2168>)context, mediumId, ((class_2168)context.getSource()).method_9207());
    }

    private static /* synthetic */ int lambda$setup$37(class_2960 effectId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.removeSpellEffect((CommandContext<class_2168>)context, effectId, class_2186.method_9315((CommandContext)context, (String)"player"));
    }

    private static /* synthetic */ int lambda$setup$36(class_2960 effectId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.removeSpellEffect((CommandContext<class_2168>)context, effectId, ((class_2168)context.getSource()).method_9207());
    }

    private static /* synthetic */ int lambda$setup$35(class_2960 effectId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.learnSpellEffect((CommandContext<class_2168>)context, effectId, class_2186.method_9315((CommandContext)context, (String)"player"));
    }

    private static /* synthetic */ int lambda$setup$34(class_2960 effectId, CommandContext context) throws CommandSyntaxException {
        return ModCommand.learnSpellEffect((CommandContext<class_2168>)context, effectId, ((class_2168)context.getSource()).method_9207());
    }

    public static class InsanityEventArgumentType
    implements ArgumentType<class_2960> {
        public static InsanityEventArgumentType insanityEvent() {
            return new InsanityEventArgumentType();
        }

        public static <S> class_2960 getInsanityEvent(CommandContext<S> context, String name) {
            return (class_2960)context.getArgument(name, class_2960.class);
        }

        public class_2960 parse(StringReader reader) throws CommandSyntaxException {
            return class_2960.method_12835((StringReader)reader);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            MMRegistries.INSANITY_EVENTS.method_10235().forEach(id -> {
                if (id.toString().startsWith(builder.getRemaining().toLowerCase())) {
                    builder.suggest(id.toString());
                }
            });
            return builder.buildFuture();
        }
    }
}

