/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite;

import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.entity.HasturCultistEntity;
import com.miskatonicmysteries.common.feature.recipe.rite.AscensionLockedRite;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.SyncRiteTargetPacket;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMEntities;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMParticles;
import com.miskatonicmysteries.common.registry.MMSounds;
import com.miskatonicmysteries.common.registry.MMStatusEffects;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4139;
import net.minecraft.class_4140;
import net.minecraft.class_5425;

public class GoldenFlockRite
extends AscensionLockedRite {
    public GoldenFlockRite() {
        super(new class_2960("miskatonicmysteries", "golden_flock"), MMAffiliations.HASTUR, MMAffiliations.HASTUR.getId().method_12832(), 0.5f, 1, class_1856.method_8091((class_1935[])new class_1935[]{MMObjects.OCEANIC_GOLD}));
    }

    @Override
    public boolean shouldContinue(OctagramBlockEntity octagram) {
        if (octagram.getOriginalCaster() == null) {
            return false;
        }
        if (octagram.targetedEntity == null && !octagram.method_10997().field_9236) {
            ++octagram.tickCount;
            class_243 pos = octagram.getSummoningPos();
            octagram.targetedEntity = octagram.method_10997().method_21726(class_1646.class, new class_4051().method_18420(villager -> villager instanceof class_1646 && villager.method_6059(MMStatusEffects.MANIA)), null, pos.field_1352, pos.field_1351, pos.field_1350, octagram.getSelectionBox().method_1009(10.0, 5.0, 10.0));
            if (octagram.targetedEntity != null) {
                octagram.tickCount = 0;
                SyncRiteTargetPacket.send(octagram.targetedEntity, octagram);
                octagram.method_5431();
                octagram.sync();
            }
        }
        return octagram.targetedEntity != null || octagram.tickCount <= 20;
    }

    @Override
    public void onCancelled(OctagramBlockEntity octagram) {
        super.onCancelled(octagram);
    }

    @Override
    public boolean isFinished(OctagramBlockEntity octagram) {
        return octagram.targetedEntity != null && octagram.targetedEntity.method_5707(octagram.getSummoningPos()) < 8.0 && octagram.tickCount >= 200;
    }

    @Override
    public void tick(OctagramBlockEntity octagram) {
        if (octagram.targetedEntity instanceof class_1646 && !octagram.targetedEntity.method_5864().equals(MMEntities.HASTUR_CULTIST)) {
            class_243 pos = octagram.getSummoningPos();
            if (octagram.targetedEntity.method_5707(pos) > 100.0 || ((class_1646)octagram.targetedEntity).method_29504()) {
                octagram.targetedEntity = null;
                return;
            }
            class_1646 villager = (class_1646)octagram.targetedEntity;
            villager.method_5942().method_6337(pos.field_1352, pos.field_1351, pos.field_1350, 0.75);
            List cultists = octagram.method_10997().method_8390(HasturCultistEntity.class, octagram.getSelectionBox().method_1009(10.0, 5.0, 10.0), cultist -> !cultist.method_6510());
            for (HasturCultistEntity cultist2 : cultists) {
                cultist2.method_5942().method_6337(pos.field_1352, pos.field_1351, pos.field_1350, (double)0.8f);
                if (!(cultist2.method_19538().method_1022(pos) < 5.0)) continue;
                cultist2.method_5942().method_6340();
                cultist2.currentSpell = null;
                cultist2.setCastTime(20);
            }
            if (villager.method_5707(pos) < 16.0) {
                if (villager.method_5707(pos) < 4.0) {
                    class_243 motionVec = new class_243(pos.field_1352 - villager.method_23317(), 0.0, pos.field_1350 - villager.method_23321());
                    motionVec = motionVec.method_1029().method_1021((double)0.1f).method_1031(0.0, villager.method_18798().field_1351, 0.0);
                    villager.method_18799(motionVec);
                }
                this.playMusic(octagram.method_10997(), pos, octagram.tickCount);
                this.spawnParticles(octagram.method_10997(), pos, octagram.method_10997().field_9229);
                ++octagram.tickCount;
                villager.method_5993().method_6233();
                villager.method_6100(true);
                if (octagram.getOriginalCaster() != null) {
                    villager.method_5951((class_1297)octagram.getOriginalCaster(), 20.0f, 20.0f);
                }
            }
        }
    }

    @Override
    public void onFinished(OctagramBlockEntity octagram) {
        if (octagram.targetedEntity instanceof class_1646) {
            octagram.targetedEntity.method_5783(MMSounds.MAGIC, 1.0f, (float)(1.0 + ((class_1646)octagram.targetedEntity).method_6051().nextGaussian() * (double)0.2f));
            if (octagram.method_10997().field_9236) {
                for (int i = 0; i < 20; ++i) {
                    MMParticles.spawnCandleParticle(octagram.method_10997(), octagram.targetedEntity.method_23317() + octagram.method_10997().field_9229.nextGaussian() * (double)octagram.targetedEntity.method_17681(), octagram.targetedEntity.method_23318() + (double)(octagram.method_10997().field_9229.nextFloat() * octagram.targetedEntity.method_17682()), octagram.targetedEntity.method_23321() + (double)(octagram.method_10997().field_9229.nextFloat() * octagram.targetedEntity.method_17681()), 1.0f, true);
                }
            }
            if (octagram.method_10997() instanceof class_3218) {
                class_1646 recipient = (class_1646)octagram.targetedEntity;
                class_3218 world = (class_3218)octagram.method_10997();
                HasturCultistEntity cultist = (HasturCultistEntity)MMEntities.HASTUR_CULTIST.method_5883((class_1937)world);
                cultist.method_5808(recipient.method_23317(), recipient.method_23318(), recipient.method_23321(), recipient.field_6031, recipient.field_5965);
                cultist.method_5943((class_5425)world, world.method_8404(cultist.method_24515()), class_3730.field_16468, null, null);
                cultist.method_5977(recipient.method_5987());
                if (recipient.method_16914()) {
                    cultist.method_5665(recipient.method_5797());
                    cultist.method_5880(recipient.method_5807());
                }
                cultist.setCastTime(20);
                cultist.method_5971();
                world.method_30771((class_1297)cultist);
                recipient.method_19176(class_4140.field_18438);
                recipient.method_19176(class_4140.field_18439);
                recipient.method_19176(class_4140.field_25160);
                recipient.method_19176(class_4140.field_18440);
                recipient.method_5650();
                cultist.method_19179(world);
                if (octagram.getOriginalCaster() != null) {
                    cultist.method_21651().method_19072(octagram.getOriginalCaster().method_5667(), class_4139.field_18427, 50);
                }
            }
        }
        super.onFinished(octagram);
    }

    private void playMusic(class_1937 world, class_243 pos, int tickCount) {
        if (tickCount % 12 == 0) {
            world.method_8465(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14708, class_3419.field_15248, 0.5f + (float)tickCount / 200.0f, 1.0f);
        } else if (tickCount % 15 == 6) {
            world.method_8465(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14708, class_3419.field_15248, 0.4f + (float)tickCount / 200.0f, 1.0f);
        } else if (tickCount % 15 == 9) {
            world.method_8465(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14708, class_3419.field_15248, 0.4f + (float)tickCount / 200.0f, 1.0f);
        }
    }

    private void spawnParticles(class_1937 world, class_243 pos, Random random) {
        class_243 particlePos;
        if (random.nextFloat() < 0.1f) {
            particlePos = pos.method_1031(random.nextGaussian() * 2.5, (double)(-0.25f + random.nextFloat() * 2.0f), random.nextGaussian() * 2.5);
            world.method_8406((class_2394)class_2398.field_11224, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1.0, 0.75 + (double)(random.nextFloat() * 0.25f), (double)(random.nextFloat() * 0.1f));
        }
        if (random.nextFloat() < 0.2f) {
            particlePos = pos.method_1031(random.nextGaussian() * 3.0, (double)(-0.25f + random.nextFloat() * 3.0f), random.nextGaussian() * 3.0);
            world.method_8406((class_2394)MMParticles.AMBIENT, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1.0, 0.75 + (double)(random.nextFloat() * 0.25f), (double)(random.nextFloat() * 0.1f));
        }
    }
}

