/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite;

import com.miskatonicmysteries.api.block.StatueBlock;
import com.miskatonicmysteries.api.registry.Rite;
import com.miskatonicmysteries.client.model.block.HasturStatueModel;
import com.miskatonicmysteries.client.render.ResourceHandler;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.entity.HasturCultistEntity;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMParticles;
import com.miskatonicmysteries.common.registry.MMSounds;
import com.miskatonicmysteries.common.registry.MMStatusEffects;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import net.minecraft.class_824;

public class SculptorRite
extends Rite {
    private final int ticksNeeded = 140;
    private final String knowledge = MMAffiliations.HASTUR.getId().method_12832();

    public SculptorRite() {
        super(new class_2960("miskatonicmysteries", "sculptor_rite"), MMAffiliations.HASTUR, 0.2f, class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10460}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8192}), class_1856.method_8091((class_1935[])new class_1935[]{MMObjects.IRIDESCENT_PEARL}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8260, class_1802.field_20391}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8260, class_1802.field_20391}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8260, class_1802.field_20391}), class_1856.method_8091((class_1935[])new class_1935[]{MMObjects.IRIDESCENT_PEARL}), class_1856.method_8091((class_1935[])new class_1935[]{MMObjects.OCEANIC_GOLD}));
    }

    @Override
    public boolean canCast(OctagramBlockEntity octagram) {
        if (super.canCast(octagram)) {
            if (!octagram.doesNearestAltarHaveKnowledge(this.knowledge)) {
                if (octagram.getOriginalCaster() != null) {
                    octagram.getOriginalCaster().method_7353((class_2561)new class_2588("message.miskatonicmysteries.rite_fail.knowledge"), true);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void tick(OctagramBlockEntity octagram) {
        class_243 pos;
        if (octagram.tickCount > 0 && octagram.tickCount % 40 == 0 && octagram.tickCount <= 120) {
            class_1937 world = octagram.method_10997();
            if (!world.field_9236) {
                octagram.getOriginalCaster().method_5643(class_1282.field_5846, octagram.getOriginalCaster().method_6063() / 3.0f);
                octagram.getOriginalCaster().method_6092(new class_1293(MMStatusEffects.BLEED, 400, 1, true, false, false));
                world.method_8396(null, octagram.method_11016(), class_3417.field_14559, class_3419.field_15248, 0.8f, 1.0f);
            } else {
                pos = octagram.getSummoningPos().method_1031(0.0, (double)(0.25f * (float)octagram.tickCount / 40.0f), 0.0);
                Random random = world.field_9229;
                for (int i = 0; i < 7; ++i) {
                    MMParticles.spawnCandleParticle(world, pos.field_1352 + random.nextGaussian() / 4.0, pos.field_1351 + random.nextGaussian() / 4.0, pos.field_1350 + random.nextGaussian() / 4.0, 1.0f, true);
                    world.method_8406((class_2394)MMParticles.DRIPPING_BLOOD, pos.field_1352 + random.nextGaussian() / 2.0, pos.field_1351 + random.nextGaussian() / 2.0, pos.field_1350 + random.nextGaussian() / 2.0, 0.0, (double)0.05f, 0.0);
                }
            }
        }
        List cultists = octagram.method_10997().method_8390(HasturCultistEntity.class, octagram.getSelectionBox().method_1009(10.0, 5.0, 10.0), cultist -> !cultist.method_6510());
        pos = octagram.getSummoningPos();
        for (HasturCultistEntity cultist2 : cultists) {
            cultist2.method_5942().method_6337(pos.field_1352, pos.field_1351, pos.field_1350, (double)0.8f);
            if (!(cultist2.method_19538().method_1022(pos) < 5.0)) continue;
            cultist2.method_5942().method_6340();
            cultist2.currentSpell = null;
            cultist2.setCastTime(20);
        }
        super.tick(octagram);
    }

    @Override
    public boolean shouldContinue(OctagramBlockEntity octagram) {
        return octagram.getOriginalCaster() != null && !octagram.getOriginalCaster().method_29504();
    }

    @Override
    public void onFinished(OctagramBlockEntity octagram) {
        class_1937 world = octagram.method_10997();
        world.method_8396(null, octagram.method_11016(), MMSounds.MAGIC, class_3419.field_15248, 0.8f, 1.0f);
        class_243 pos = octagram.getSummoningPos().method_1031(0.0, 0.5, 0.0);
        if (!world.field_9236) {
            class_1542 result = new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, StatueBlock.setCreator(new class_1799((class_1935)SculptorRite.getStatueForIngredients(octagram)), octagram.getOriginalCaster()));
            result.method_18800(0.0, 0.0, 0.0);
            result.method_5875(true);
            world.method_8649((class_1297)result);
        } else {
            for (int i = 0; i < 20; ++i) {
                MMParticles.spawnCandleParticle(world, pos.field_1352 + world.field_9229.nextGaussian(), pos.field_1351 + world.field_9229.nextGaussian(), pos.field_1350 + world.field_9229.nextGaussian(), 1.0f, true);
            }
        }
        super.onFinished(octagram);
    }

    @Override
    public boolean isFinished(OctagramBlockEntity octagram) {
        return octagram.triggered && octagram.tickCount >= 140;
    }

    private static StatueBlock getStatueForIngredients(OctagramBlockEntity octagram) {
        for (class_1799 item : octagram.getItems()) {
            if (item.method_7909() == class_1802.field_20391) {
                return MMObjects.HASTUR_STATUE_STONE;
            }
            if (item.method_7909() != class_1802.field_8260) continue;
            return MMObjects.HASTUR_STATUE_TERRACOTTA;
        }
        return MMObjects.HASTUR_STATUE_STONE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public byte beforeRender(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        return 1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderRite(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        class_4588 vertexConsumer = ResourceHandler.STATUE_SPRITES.get(SculptorRite.getStatueForIngredients(entity)).method_24145(vertexConsumers, class_1921::method_23572);
        matrixStack.method_22904(1.5, 0.0, 1.5);
        matrixStack.method_22903();
        HasturStatueModel model = ResourceHandler.HASTUR_STATUE_MODEL;
        model.plinth.field_3665 = entity.tickCount > 40;
        model.body.field_3665 = entity.tickCount > 80;
        model.head.field_3665 = entity.tickCount > 120;
        matrixStack.method_22904(0.0, 1.5, 0.0);
        matrixStack.method_22907(class_1160.field_20704.method_23214(180.0f));
        matrixStack.method_22907(class_1160.field_20707.method_23214(180.0f));
        model.method_2828(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.method_22909();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderRiteItems(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        int count = 0;
        int maxAllowedCount = 3 - entity.tickCount / 40;
        for (int i = 0; i < entity.method_5439(); ++i) {
            class_1799 stack = entity.method_5438(i);
            if ((stack.method_7909() == class_1802.field_20391 || stack.method_7909() == class_1802.field_8260) && ++count > maxAllowedCount) continue;
            matrixStack.method_22903();
            matrixStack.method_22907(class_1160.field_20704.method_23214(0.125f * (float)i * 360.0f));
            matrixStack.method_22904(0.0, 0.0, -1.1);
            matrixStack.method_22907(class_1160.field_20702.method_23214(90.0f));
            class_310.method_1551().method_1480().method_23178(entity.method_5438(i), class_809.class_811.field_4318, light, class_4608.field_21444, matrixStack, vertexConsumers);
            matrixStack.method_22909();
        }
    }
}

