/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite;

import com.miskatonicmysteries.api.interfaces.DropManipulator;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.feature.recipe.rite.TriggeredRite;
import com.miskatonicmysteries.common.registry.MMParticles;
import com.miskatonicmysteries.common.registry.MMSounds;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5425;
import net.minecraft.class_824;

public class SpawnerTrapRite
extends TriggeredRite {
    private final Predicate<class_1299<?>> spawnPredicate;
    private final class_2394 spawnParticles;
    private final float[] color;

    public SpawnerTrapRite(class_2960 id, @Nullable Affiliation octagram, Predicate<class_1299<?>> spawnPredicate, class_2394 spawnParticles, float[] color, class_1856 ... ingredients) {
        super(id, octagram, 0.01f, 90, ingredients);
        this.spawnPredicate = spawnPredicate;
        this.spawnParticles = spawnParticles;
        this.color = color;
    }

    @Override
    public boolean canCast(OctagramBlockEntity octagram) {
        if (super.canCast(octagram)) {
            if (octagram.method_10997().field_9236) {
                return true;
            }
            for (class_2338 iterateOutward : class_2338.method_25996((class_2338)octagram.method_11016().method_10069(0, 1, 0), (int)1, (int)1, (int)1)) {
                if (!octagram.method_10997().method_8320(iterateOutward).method_26212((class_1922)octagram.method_10997(), iterateOutward)) continue;
                if (octagram.getOriginalCaster() != null) {
                    octagram.getOriginalCaster().method_7353((class_2561)new class_2588("message.miskatonicmysteries.needs_space"), true);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void tick(OctagramBlockEntity octagram) {
        if (octagram.triggered && octagram.tickCount > this.ticksNeeded && octagram.tickCount % 200 == 0) {
            class_1937 world = octagram.method_10997();
            int amount = 1 + world.field_9229.nextInt(2);
            octagram.method_10997().method_8396(null, octagram.method_11016(), MMSounds.BROKE_VEIL_SPAWN, class_3419.field_15256, 1.0f, (float)world.field_9229.nextGaussian() * 0.2f + 1.0f);
            if (!world.field_9236) {
                for (int i = 0; i < amount; ++i) {
                    List possibleTypes = class_2378.field_11145.method_10220().filter(this.spawnPredicate).collect(Collectors.toList());
                    class_1299 type = (class_1299)possibleTypes.get(world.field_9229.nextInt(possibleTypes.size()));
                    class_1297 entity = type.method_5883(world);
                    class_243 position = octagram.getSummoningPos().method_1031(octagram.method_10997().field_9229.nextGaussian(), (double)(-0.25f + octagram.method_10997().field_9229.nextFloat()), octagram.method_10997().field_9229.nextGaussian());
                    int yaw = world.field_9229.nextInt(360);
                    entity.method_5641(position.field_1352, position.field_1351, position.field_1350, (float)yaw, 0.0f);
                    if (entity instanceof class_1309) {
                        ((class_1309)entity).field_6283 = yaw;
                        ((class_1309)entity).method_6092(new class_1293(class_1294.field_5910, 1200, 0, true, true));
                        ((class_1309)entity).method_6092(new class_1293(class_1294.field_5907, 1200, 0, true, true));
                        ((class_1309)entity).method_6092(new class_1293(class_1294.field_5918, 1200, 0, true, true));
                        if (entity instanceof class_1308) {
                            ((class_1308)entity).method_5943((class_5425)((class_3218)world), world.method_8404(entity.method_24515()), class_3730.field_16467, null, null);
                            entity.field_6002.method_8333(entity, entity.method_5829().method_1009(8.0, 3.0, 8.0), target -> target instanceof class_1309 && !(target instanceof class_1569) && class_1301.field_22280.test(target)).stream().findAny().ifPresent(value -> ((class_1308)entity).method_5980((class_1309)value));
                        }
                        ((DropManipulator)entity).setDropOveride(true);
                    }
                    world.method_8649(entity);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    class_243 position = octagram.getSummoningPos().method_1031(octagram.method_10997().field_9229.nextGaussian() * 0.5, -0.25 + (double)octagram.method_10997().field_9229.nextFloat(), octagram.method_10997().field_9229.nextGaussian() * 0.5);
                    octagram.method_10997().method_8406(this.spawnParticles, position.field_1352, position.field_1351, position.field_1350, 0.0, 0.0, 0.0);
                }
            }
        } else if (octagram.method_10997().field_9236 && (octagram.tickCount < this.ticksNeeded || octagram.triggered) && octagram.method_10997().field_9229.nextFloat() < 0.25f) {
            class_243 position = octagram.getSummoningPos().method_1031(octagram.method_10997().field_9229.nextGaussian(), -0.5 + (double)octagram.method_10997().field_9229.nextFloat(), octagram.method_10997().field_9229.nextGaussian() * 0.5);
            octagram.method_10997().method_8406((class_2394)MMParticles.AMBIENT, position.field_1352, position.field_1351, position.field_1350, (double)this.color[0], (double)this.color[1], (double)this.color[2]);
        }
        if (octagram.triggered || octagram.tickCount < this.ticksNeeded) {
            super.tick(octagram);
        }
    }

    @Override
    public void trigger(OctagramBlockEntity octagram, class_1297 triggeringEntity) {
        super.trigger(octagram, triggeringEntity);
        if (triggeringEntity instanceof class_1309) {
            ((class_1309)triggeringEntity).method_6092(new class_1293(class_1294.field_5909, 400, 1, true, true));
        }
    }

    @Override
    public boolean isFinished(OctagramBlockEntity octagram) {
        return octagram.triggered && octagram.tickCount >= 1200;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderRite(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        if (entity.triggered && entity.tickCount > this.ticksNeeded) {
            float alpha = entity.tickCount - this.ticksNeeded > this.ticksNeeded ? 1.0f : (float)(entity.tickCount - this.ticksNeeded) / (float)this.ticksNeeded;
            SpawnerTrapRite.renderPortalOctagram(alpha, this.color, entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
        } else {
            super.renderRite(entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
        }
    }
}

