/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite;

import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.SpellEffect;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.entity.BoltEntity;
import com.miskatonicmysteries.common.feature.recipe.rite.AscensionLockedRite;
import com.miskatonicmysteries.common.registry.MMEntities;
import com.miskatonicmysteries.common.registry.MMParticles;
import com.miskatonicmysteries.common.registry.MMSounds;
import com.miskatonicmysteries.common.registry.MMStatusEffects;
import java.awt.Color;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class SpellGivingRite
extends AscensionLockedRite {
    private final SpellEffect grantedEffect;

    public SpellGivingRite(SpellEffect effect, String knowledge, class_2960 id, @Nullable Affiliation octagram, int stage, class_1856 ... ingredients) {
        super(id, octagram, knowledge, 0.25f, stage, ingredients);
        this.grantedEffect = effect;
    }

    @Override
    public boolean canCast(OctagramBlockEntity octagram) {
        if (super.canCast(octagram)) {
            Optional<SpellCaster> caster = SpellCaster.of(octagram.getOriginalCaster());
            if (caster.isPresent() && caster.get().getLearnedEffects().contains(this.grantedEffect)) {
                octagram.getOriginalCaster().method_7353((class_2561)new class_2588("message.miskatonicmysteries.spell_rite_fail"), true);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldContinue(OctagramBlockEntity octagram) {
        return octagram.getOriginalCaster() != null;
    }

    @Override
    public boolean isFinished(OctagramBlockEntity octagram) {
        return octagram.getOriginalCaster() != null && octagram.tickCount >= 240;
    }

    @Override
    public void tick(OctagramBlockEntity octagram) {
        class_243 pos = octagram.getSummoningPos();
        class_1657 player = octagram.getOriginalCaster();
        if (player == null) {
            octagram.setOriginalCaster(null);
            this.onCancelled(octagram);
        }
        class_243 motionVec = new class_243(pos.field_1352 - player.method_23317(), pos.field_1351 - player.method_23318(), pos.field_1350 - player.method_23321());
        motionVec = motionVec.method_1021(0.5);
        player.method_18799(motionVec.method_1031(0.0, player.method_18798().field_1351, 0.0));
        if (player.method_5707(pos) < 4.0) {
            ++octagram.tickCount;
            this.spawnParticles(octagram.method_10997(), player.method_19538(), player.method_6051(), octagram.tickCount, player);
            if (octagram.tickCount % 40 == 1) {
                player.method_5783(MMSounds.MAGIC, 0.6f, 1.3f);
            }
        } else if (player.method_5707(pos) > 100.0) {
            octagram.tickCount = 0;
            octagram.setOriginalCaster(null);
            this.onCancelled(octagram);
            return;
        }
    }

    @Override
    public void onFinished(OctagramBlockEntity octagram) {
        class_1657 player = octagram.getOriginalCaster();
        player.method_18800(0.0, 0.5, 0.0);
        player.method_5783(MMSounds.MAGIC, 1.0f, (float)(1.0 + player.method_6051().nextGaussian() * (double)0.2f));
        if (octagram.method_10997().field_9236) {
            for (int i = 0; i < 20; ++i) {
                MMParticles.spawnCandleParticle(octagram.method_10997(), player.method_23317() + octagram.method_10997().field_9229.nextGaussian() * (double)player.method_17681(), player.method_23318() + (double)(octagram.method_10997().field_9229.nextFloat() * player.method_17682()), player.method_23321() + (double)(octagram.method_10997().field_9229.nextFloat() * player.method_17681()), 1.5f, true);
            }
        } else {
            class_243 pos = player.method_19538();
            for (int i = 0; i < 5; ++i) {
                BoltEntity bolt = (BoltEntity)MMEntities.BOLT.method_5883(octagram.method_10997());
                bolt.method_23327(pos.field_1352, pos.field_1351 + 0.5, pos.field_1350);
                bolt.field_6031 = player.method_6051().nextInt(360);
                bolt.field_5965 = player.method_6051().nextInt(360);
                bolt.setColor(this.grantedEffect.getColor((class_1309)player));
                octagram.method_10997().method_8649((class_1297)bolt);
            }
            player.method_6092(new class_1293(MMStatusEffects.MANIA, 100 + octagram.method_10997().field_9229.nextInt(200), 1));
            Sanity.of(player).ifPresent(sanity -> {
                int reductionAmount = 15 - player.method_6051().nextInt(8);
                sanity.addSanityCapExpansion("spell." + this.grantedEffect.getId().method_12832(), -reductionAmount);
            });
            SpellCaster.of(player).ifPresent(caster -> {
                caster.learnEffect(this.grantedEffect);
                caster.syncSpellData();
            });
        }
        super.onFinished(octagram);
    }

    private void spawnParticles(class_1937 world, class_243 pos, Random random, int ticks, class_1657 player) {
        if (!world.field_9236) {
            if (ticks % 40 == 0) {
                for (int i = 0; i < 2; ++i) {
                    BoltEntity bolt = (BoltEntity)MMEntities.BOLT.method_5883(world);
                    bolt.method_23327(pos.field_1352, pos.field_1351 + 1.5, pos.field_1350);
                    bolt.field_6031 = random.nextInt(360);
                    bolt.field_5965 = random.nextInt(360);
                    bolt.setColor(this.grantedEffect.getColor((class_1309)player));
                    world.method_8649((class_1297)bolt);
                }
            }
        } else {
            Color color = new Color(this.grantedEffect.getColor((class_1309)player));
            double rad = Math.PI * (double)((float)ticks / 20.0f);
            double y = ticks % 40 > 20 ? (double)(1.0f - (float)(ticks % 20) / 20.0f) : (double)((float)(ticks % 20) / 20.0f);
            world.method_8406((class_2394)MMParticles.SHRINKING_MAGIC, pos.field_1352 + Math.sin(rad), pos.field_1351 + y, pos.field_1350 + Math.cos(rad), (double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f));
            world.method_8406((class_2394)MMParticles.SHRINKING_MAGIC, pos.field_1352 + Math.sin(rad + Math.PI), pos.field_1351 + y, pos.field_1350 + Math.cos(rad + Math.PI), (double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f));
        }
    }
}

