/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite;

import com.miskatonicmysteries.api.registry.Rite;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.item.IncantationYogItem;
import com.miskatonicmysteries.common.registry.MMObjects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public class TeleportRite
extends Rite {
    private final int ticksNeeded;

    public TeleportRite() {
        super(new class_2960("miskatonicmysteries", "teleport"), null, 0.0f, class_1856.method_8091((class_1935[])new class_1935[]{MMObjects.INCANTATION_YOG}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8634}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8449}), class_1856.method_8091((class_1935[])new class_1935[]{MMObjects.OCEANIC_GOLD}));
        this.ticksNeeded = 60;
    }

    @Override
    public boolean canCast(OctagramBlockEntity octagram) {
        if (super.canCast(octagram)) {
            if (octagram.method_10997().field_9236) {
                return true;
            }
            class_1657 caster = octagram.getOriginalCaster();
            class_1799 incantation = octagram.getStack(MMObjects.INCANTATION_YOG);
            if (!incantation.method_7960() && IncantationYogItem.getPosition(incantation) != null && IncantationYogItem.getWorld((class_3218)octagram.method_10997(), incantation) != null) {
                class_2338 octagramPos = IncantationYogItem.getPosition(incantation);
                class_3218 boundWorld = IncantationYogItem.getWorld((class_3218)octagram.method_10997(), incantation);
                if (!(boundWorld.method_8321(octagramPos) instanceof OctagramBlockEntity)) {
                    caster.method_7353((class_2561)new class_2588("message.miskatonicmysteries.invalid_octagram.not_present"), true);
                    return false;
                }
                if (octagramPos.equals((Object)octagram.method_11016())) {
                    caster.method_7353((class_2561)new class_2588("message.miskatonicmysteries.invalid_connection.self_reference"), true);
                    return false;
                }
                if (((OctagramBlockEntity)boundWorld.method_8321(octagramPos)).getAffiliation(false) != octagram.getAffiliation(false)) {
                    caster.method_7353((class_2561)new class_2588("message.miskatonicmysteries.invalid_octagram.bad_affiliation"), true);
                    return false;
                }
                if (((OctagramBlockEntity)boundWorld.method_8321((class_2338)octagramPos)).boundPos != null) {
                    caster.method_7353((class_2561)new class_2588("message.miskatonicmysteries.invalid_octagram.already_bound"), true);
                    return false;
                }
                return true;
            }
            if (caster != null) {
                caster.method_7353((class_2561)new class_2588("message.miskatonicmysteries.invalid_incantation"), true);
                return false;
            }
        }
        return false;
    }

    @Override
    public void tick(OctagramBlockEntity octagram) {
        if (!this.isFinished(octagram) && !octagram.permanentRiteActive) {
            super.tick(octagram);
        }
    }

    @Override
    public void onFinished(OctagramBlockEntity octagram) {
        if (!octagram.method_10997().field_9236) {
            class_3218 world = (class_3218)octagram.method_10997();
            octagram.tickCount = 0;
            class_1799 incantation = octagram.getStack(MMObjects.INCANTATION_YOG);
            if (!incantation.method_7960()) {
                class_2338 octagramPos = IncantationYogItem.getPosition(incantation);
                class_3218 boundWorld = IncantationYogItem.getWorld(world, incantation);
                if (boundWorld.method_8321(octagramPos) instanceof OctagramBlockEntity) {
                    octagram.bind((class_1937)boundWorld, octagramPos);
                    OctagramBlockEntity otherOctagram = (OctagramBlockEntity)boundWorld.method_8321(octagramPos);
                    otherOctagram.bind((class_1937)world, octagram.method_11016());
                    otherOctagram.permanentRiteActive = true;
                    otherOctagram.currentRite = this;
                    otherOctagram.tickCount = 0;
                    otherOctagram.method_5431();
                    otherOctagram.sync();
                }
            }
        }
        super.onFinished(octagram);
    }

    @Override
    public void onCancelled(OctagramBlockEntity octagram) {
        OctagramBlockEntity otherOctagram = TeleportRite.getBoundOctagram(octagram);
        if (otherOctagram != null && !otherOctagram.method_10997().field_9236) {
            otherOctagram.permanentRiteActive = false;
            otherOctagram.currentRite = null;
            otherOctagram.tickCount = 0;
            octagram.boundPos = null;
            otherOctagram.boundPos = null;
            otherOctagram.method_5431();
            octagram.method_5431();
            otherOctagram.sync();
        }
        super.onCancelled(octagram);
    }

    public static OctagramBlockEntity getBoundOctagram(OctagramBlockEntity octagram) {
        class_2586 be;
        class_2338 octagramPos = octagram.getBoundPos();
        class_3218 boundWorld = octagram.getBoundDimension();
        if (octagramPos != null && boundWorld != null && (be = boundWorld.method_8321(octagramPos)) instanceof OctagramBlockEntity) {
            return (OctagramBlockEntity)be;
        }
        return null;
    }

    @Override
    public boolean shouldContinue(OctagramBlockEntity octagram) {
        return super.shouldContinue(octagram);
    }

    @Override
    public boolean isFinished(OctagramBlockEntity octagram) {
        return octagram.tickCount >= this.ticksNeeded;
    }

    @Override
    public boolean isPermanent(OctagramBlockEntity octagram) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public byte beforeRender(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        return super.beforeRender(entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderRite(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        float alpha = entity.permanentRiteActive ? 1.0f : (float)entity.tickCount / (float)this.ticksNeeded;
        TeleportRite.renderPortalOctagram(alpha, entity.getAffiliation(true).getColor(), entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
    }
}

