/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite;

import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.Rite;
import com.miskatonicmysteries.client.render.RenderHelper;
import com.miskatonicmysteries.client.render.ResourceHandler;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public abstract class TriggeredRite
extends Rite {
    public final int ticksNeeded;

    public TriggeredRite(class_2960 id, @Nullable Affiliation octagram, float investigatorChance, int tickCount, class_1856 ... ingredients) {
        super(id, octagram, investigatorChance, ingredients);
        this.ticksNeeded = tickCount;
    }

    @Override
    public void tick(OctagramBlockEntity octagram) {
        super.tick(octagram);
        if (octagram.tickCount == this.ticksNeeded) {
            octagram.permanentRiteActive = true;
            octagram.method_5448();
            octagram.method_5431();
        }
    }

    public void trigger(OctagramBlockEntity octagram, class_1297 triggeringEntity) {
        octagram.triggered = true;
        octagram.tickCount = this.ticksNeeded;
    }

    @Override
    public void onFinished(OctagramBlockEntity octagram) {
        super.onFinished(octagram);
        octagram.permanentRiteActive = false;
        octagram.currentRite = null;
        octagram.tickCount = 0;
    }

    @Override
    public boolean isPermanent(OctagramBlockEntity octagram) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public byte beforeRender(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        return !entity.triggered ? (byte)2 : super.beforeRender(entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderRite(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        if (!entity.triggered) {
            float alpha = entity.tickCount >= this.ticksNeeded ? 1.0f : (float)entity.tickCount / (float)this.ticksNeeded;
            matrixStack.method_22904(0.0, (double)0.001f, 0.0);
            RenderHelper.renderTexturedPlane(3.0f, ResourceHandler.getOctagramTextureFor(entity).method_24148(), matrixStack, vertexConsumers.getBuffer(RenderHelper.getTransparency()), light, overlay, new float[]{1.0f, 1.0f, 1.0f, Math.max(1.0f - alpha, 0.15f)});
        }
    }
}

