/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.recipe.rite.summon;

import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.client.render.RenderHelper;
import com.miskatonicmysteries.client.render.ResourceHandler;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.feature.recipe.rite.AscensionLockedRite;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1856;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5425;
import net.minecraft.class_824;

public abstract class SummoningRite<T extends class_1297>
extends AscensionLockedRite {
    protected int tickCount;
    protected class_1299<T> summon;
    @Nullable
    protected class_2487 nbt;
    @Nullable
    protected class_1315 data;

    public SummoningRite(class_2960 id, @Nullable Affiliation octagram, String knowledge, float investigatorChance, int stage, class_1299<T> summon, class_1856 ... ingredients) {
        super(id, octagram, knowledge, investigatorChance, stage, ingredients);
        this.summon = summon;
        this.tickCount = 200;
    }

    @Override
    public void onFinished(OctagramBlockEntity octagram) {
        if (octagram.method_10997() instanceof class_3218) {
            class_3218 world = (class_3218)octagram.method_10997();
            class_1297 entity = this.summon.method_5888(world, this.nbt, null, octagram.getOriginalCaster(), octagram.method_11016(), class_3730.field_16471, true, false);
            class_243 pos = octagram.getSummoningPos();
            class_2350 direction = (class_2350)world.method_8320(octagram.method_11016()).method_11654((class_2769)class_2383.field_11177);
            entity.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, direction.method_10144() + 180.0f, 90.0f);
            this.addDataToSummon(world, octagram, entity);
            world.method_30771(entity);
        }
        super.onFinished(octagram);
    }

    protected void addDataToSummon(class_3218 world, OctagramBlockEntity octagram, T entity) {
        if (entity instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)world, world.method_8404(entity.method_24515()), class_3730.field_16471, null, null);
        }
    }

    @Override
    public void renderRite(OctagramBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, class_824 dispatcher) {
        super.renderRite(entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
        if (entity.tickCount > 0) {
            float alpha = entity.tickCount > 20 ? 1.0f : (float)entity.tickCount / 20.0f;
            float[] rgb = entity.getAffiliation(true).getColor();
            SummoningRite.renderPortalOctagram(alpha, rgb, entity, tickDelta, matrixStack, vertexConsumers, light, overlay, dispatcher);
            class_3879 model = this.getRenderedModel(entity);
            double distance = entity.method_11016().method_19770((class_2374)dispatcher.field_4344.method_19326(), true);
            int renderDepth = Math.max(RenderHelper.getDepthFromDistance(distance) - 15 + 4 * entity.tickCount / this.tickCount, 0);
            matrixStack.method_22904(1.5, 1.5, 1.5);
            matrixStack.method_22907(class_1160.field_20707.method_23214(180.0f));
            matrixStack.method_22907(class_1160.field_20705.method_23214(180.0f));
            RenderSystem.enableBlend();
            alpha = (float)entity.tickCount / 200.0f;
            model.method_2828(matrixStack, ResourceHandler.TOTAL_DARK.method_24148().method_24108(vertexConsumers.getBuffer(RenderHelper.getTransparency())), 0, overlay, 0.0f, 0.0f, 0.0f, alpha);
            for (int i = 0; i < renderDepth; ++i) {
                RenderHelper.renderModelAsPortal(vertexConsumers, matrixStack, light, overlay, model, rgb, alpha, entity.method_10997().field_9229, i + 11);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract class_3879 getRenderedModel(OctagramBlockEntity var1);

    @Override
    public boolean isFinished(OctagramBlockEntity octagram) {
        return octagram.tickCount >= 200;
    }
}

