/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.feature.spell;

import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.interfaces.Ascendant;
import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.registry.SpellEffect;
import com.miskatonicmysteries.api.registry.SpellMedium;
import com.miskatonicmysteries.common.handler.networking.packet.SpellPacket;
import com.miskatonicmysteries.common.registry.MMBlessings;
import com.miskatonicmysteries.common.registry.MMRegistries;
import com.miskatonicmysteries.common.registry.MMSounds;
import com.miskatonicmysteries.common.registry.MMStatusEffects;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class Spell {
    public SpellEffect effect;
    public SpellMedium medium;
    public int intensity;

    public Spell(SpellMedium medium, SpellEffect effect, int intensity) {
        this.medium = medium;
        this.effect = effect;
        this.intensity = intensity;
    }

    public boolean cast(class_1309 caster) {
        Optional<SpellCaster> spellCaster = SpellCaster.of(caster);
        if (spellCaster.isPresent()) {
            caster.field_6002.method_8486(caster.method_23317(), caster.method_23318(), caster.method_23321(), MMSounds.MAGIC, class_3419.field_15248, 0.85f, (float)caster.method_6051().nextGaussian() * 0.2f + 1.0f, true);
        }
        if (!caster.field_6002.field_9236) {
            int intensityMod = 0;
            int cooldownMod = 0;
            if (MiskatonicMysteriesAPI.isWardingMarkNearby(caster.field_6002, caster.method_24515())) {
                caster.method_6092(new class_1293(MMStatusEffects.MANIA, 100, 0));
                cooldownMod += 80;
                if (this.intensity <= 0) {
                    spellCaster.get().setSpellCooldown(100);
                    return false;
                }
                --intensityMod;
            }
            if (caster.method_6059(MMStatusEffects.RESONANCE)) {
                class_1293 instance = caster.method_6112(MMStatusEffects.RESONANCE);
                cooldownMod -= (instance.method_5578() + 1) * 20;
                intensityMod += Math.round((float)instance.method_5578() * 0.75f);
            }
            if (Ascendant.of(caster).isPresent() && MiskatonicMysteriesAPI.hasBlessing(Ascendant.of(caster).get(), MMBlessings.MAGIC_BOOST)) {
                ++intensityMod;
            }
            if (spellCaster.isPresent()) {
                int burnout = class_3532.method_15340((int)(spellCaster.get().getSpellCooldown() + Math.round(this.medium.getCooldownModifier(caster) * this.effect.getCooldownBase(this.intensity)) + cooldownMod), (int)0, (int)999);
                spellCaster.get().setSpellCooldown(burnout);
            }
            Sanity.of(caster).ifPresent(sanity -> sanity.setSanity(sanity.getSanity() - this.effect.calculateSanityPenalty(caster.method_6051(), this.intensity), false));
            SpellPacket.send(caster, this.toTag(new class_2487()), intensityMod);
        }
        return this.effect.canCast(caster, this.medium) && this.medium.cast(caster.field_6002, caster, this.effect, this.intensity);
    }

    public class_2487 toTag(class_2487 tag) {
        tag.method_10582("SpellEffect", this.effect.getId().toString());
        tag.method_10582("SpellMedium", this.medium.getId().toString());
        tag.method_10569("Intensity", this.intensity);
        return tag;
    }

    public static Spell fromTag(class_2487 tag) {
        return tag.isEmpty() ? null : new Spell((SpellMedium)MMRegistries.SPELL_MEDIUMS.method_10223(new class_2960(tag.method_10558("SpellMedium"))), (SpellEffect)MMRegistries.SPELL_EFFECTS.method_10223(new class_2960(tag.method_10558("SpellEffect"))), tag.method_10550("Intensity"));
    }
}

