/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.common.handler;

import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.registry.InsanityEvent;
import com.miskatonicmysteries.common.MiskatonicMysteries;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMRegistries;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_746;

public class InsanityHandler {
    public static boolean hasSanityCapExpansion(class_1657 player, String expansion) {
        Optional<Sanity> sanity = Sanity.of(player);
        return sanity.isPresent() && sanity.get().getSanityCapExpansions().containsKey(expansion);
    }

    public static void handleInsanityEvents(class_1657 player) {
        Optional<Sanity> optionalSanity = Sanity.of(player);
        float insanityFactor = 1.0f - InsanityHandler.calculateSanityFactor(optionalSanity);
        optionalSanity.ifPresent(sanity -> {
            InsanityEvent event;
            if (player.method_6051().nextFloat() < 0.1f + 0.1f * insanityFactor && (event = InsanityHandler.findInsanityEvent(player, sanity, insanityFactor)) != null) {
                event.execute(player, (Sanity)player);
            }
        });
    }

    private static InsanityEvent findInsanityEvent(class_1657 player, Sanity sanity, float insanityFactor) {
        List events = MMRegistries.INSANITY_EVENTS.method_10220().filter(event -> event.test(player, sanity, insanityFactor)).collect(Collectors.toList());
        for (int i = 0; i < MiskatonicMysteries.config.sanity.insanityEventAttempts; ++i) {
            if (events.isEmpty()) {
                return null;
            }
            InsanityEvent event2 = (InsanityEvent)events.get(player.method_6051().nextInt(events.size()));
            if (player.method_6051().nextFloat() < event2.baseChance) {
                return event2;
            }
            events.remove(event2);
        }
        return null;
    }

    public static float calculateSanityFactor(Optional<Sanity> sanity) {
        return sanity.map(value -> Float.valueOf((float)value.getSanity() / 1000.0f)).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void handleClientSideBlockChange(class_746 player, class_1937 world, class_2680 state, class_2338 pos, Random random) {
        Sanity.of(player).ifPresent(sanity -> {
            if (sanity.getSanity() < 750 && random.nextFloat() < 0.2f && state.method_26204().equals(class_2246.field_10511)) {
                world.method_8652(pos, MMObjects.BIRCH_LOG.method_9564(), 1);
            }
        });
    }
}

