/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.mixin;

import com.miskatonicmysteries.api.interfaces.Appeasable;
import com.miskatonicmysteries.api.interfaces.DropManipulator;
import com.miskatonicmysteries.api.interfaces.Hallucination;
import com.miskatonicmysteries.common.block.blockentity.OctagramBlockEntity;
import com.miskatonicmysteries.common.registry.MMStatusEffects;
import com.miskatonicmysteries.common.util.Constants;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements DropManipulator {
    private boolean overrideDrops;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"onKilledBy"}, at={@At(value="HEAD")})
    private void onKilledBy(@Nullable class_1309 adversary, CallbackInfo ci) {
        if (!this.field_6002.field_9236 && this.method_5864().method_20210(Constants.Tags.VALID_SACRIFICES)) {
            Iterable positions = class_2338.method_25996((class_2338)this.method_24515(), (int)6, (int)6, (int)6);
            for (class_2338 position : positions) {
                if (!(this.field_6002.method_8321(position) instanceof OctagramBlockEntity)) continue;
                OctagramBlockEntity octagram = (OctagramBlockEntity)this.field_6002.method_8321(position);
                if (octagram.currentRite == null) continue;
                octagram.setFlag(0, true);
                octagram.method_5431();
                octagram.sync();
                break;
            }
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")}, cancellable=true)
    private void eatFood(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        if (this.method_6059(MMStatusEffects.EXOTIC_CRAVINGS)) {
            if (!stack.method_7909().method_7855(Constants.Tags.GROSS_FOOD)) {
                this.method_5643(class_1282.field_5852, 4.0f);
            } else {
                class_1293 instance = this.method_6112(MMStatusEffects.EXOTIC_CRAVINGS);
                this.method_6016(MMStatusEffects.EXOTIC_CRAVINGS);
                this.method_6092(new class_1293(instance.method_5579(), instance.method_5584() - (200 - instance.method_5578() * 40), instance.method_5578(), false, true));
            }
        }
    }

    @Override
    public boolean hasOverridenDrops() {
        return this.overrideDrops;
    }

    @Override
    public void setDropOveride(boolean dropOveride) {
        this.overrideDrops = dropOveride;
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    public void dropLoot(CallbackInfo info) {
        if (this.hasOverridenDrops()) {
            info.cancel();
        }
    }

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    public abstract Random method_6051();

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_1291 var1);

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract boolean method_6016(class_1291 var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventHeal(float amount, CallbackInfo callbackInfo) {
        if (this.method_6059(MMStatusEffects.BLEED) && (double)this.method_6051().nextFloat() < 0.4 + 0.2 * (double)this.method_6112(MMStatusEffects.BLEED).method_5578()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"writeCustomDataToTag(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void writeMiscData(class_2487 compoundTag, CallbackInfo info) {
        compoundTag.method_10556("ShouldDrop", this.hasOverridenDrops());
        Appeasable.of(this).ifPresent(appeasable -> {
            compoundTag.method_10569("AppeaseTicks", appeasable.getAppeasedTicks());
            compoundTag.method_10569("HoldTicks", appeasable.getHoldTicks());
        });
    }

    @Inject(method={"readCustomDataFromTag(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readMiscData(class_2487 compoundTag, CallbackInfo info) {
        this.setDropOveride(compoundTag.method_10577("ShouldDrop"));
        Appeasable.of(this).ifPresent(appeasable -> {
            appeasable.setAppeasedTicks(compoundTag.method_10550("AppeaseTicks"));
            appeasable.setHoldTicks(compoundTag.method_10550("HoldTicks"));
        });
    }

    @Inject(method={"canTarget(Lnet/minecraft/entity/EntityType;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void appease(class_1299<?> type, CallbackInfoReturnable<Boolean> cir) {
        if (Appeasable.of(this).isPresent() && Appeasable.of(this).get().isAppeased()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")}, cancellable=true)
    private void hit(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (Hallucination.of(this).isPresent() && Hallucination.of(this).get().getHallucinationTarget().isPresent() && source.method_5529() != null) {
            this.method_5650();
        }
    }
}

