/*
 * Decompiled with CFR 0.152.
 */
package com.miskatonicmysteries.mixin;

import com.miskatonicmysteries.api.MiskatonicMysteriesAPI;
import com.miskatonicmysteries.api.block.StatueBlock;
import com.miskatonicmysteries.api.interfaces.Ascendant;
import com.miskatonicmysteries.api.interfaces.MalleableAffiliated;
import com.miskatonicmysteries.api.interfaces.Resonating;
import com.miskatonicmysteries.api.interfaces.Sanity;
import com.miskatonicmysteries.api.interfaces.SpellCaster;
import com.miskatonicmysteries.api.item.trinkets.MaskTrinketItem;
import com.miskatonicmysteries.api.registry.Affiliation;
import com.miskatonicmysteries.api.registry.Blessing;
import com.miskatonicmysteries.api.registry.SpellEffect;
import com.miskatonicmysteries.api.registry.SpellMedium;
import com.miskatonicmysteries.common.MiskatonicMysteries;
import com.miskatonicmysteries.common.entity.ProtagonistEntity;
import com.miskatonicmysteries.common.feature.effect.LazarusStatusEffect;
import com.miskatonicmysteries.common.feature.spell.Spell;
import com.miskatonicmysteries.common.handler.InsanityHandler;
import com.miskatonicmysteries.common.handler.networking.packet.SyncSpellCasterDataPacket;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.ExpandSanityPacket;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.RemoveExpansionPacket;
import com.miskatonicmysteries.common.handler.networking.packet.s2c.SyncBlessingsPacket;
import com.miskatonicmysteries.common.registry.MMAffiliations;
import com.miskatonicmysteries.common.registry.MMObjects;
import com.miskatonicmysteries.common.registry.MMRegistries;
import com.miskatonicmysteries.common.registry.MMStatusEffects;
import com.miskatonicmysteries.common.util.Constants;
import com.miskatonicmysteries.common.util.InventoryUtil;
import com.miskatonicmysteries.common.util.NbtUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements Sanity,
MalleableAffiliated,
SpellCaster,
Ascendant,
Resonating {
    public final Map<String, Integer> sanityCapOverrides = new ConcurrentHashMap<String, Integer>();
    private final List<Spell> spells = new ArrayList<Spell>();
    private final Set<SpellEffect> learnedEffects = new HashSet<SpellEffect>();
    private final Set<SpellMedium> learnedMediums = new HashSet<SpellMedium>();
    private final List<Blessing> blessings = new ArrayList<Blessing>();

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")})
    private void wakeUp(boolean bl, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (this.method_7276() && !this.field_6002.field_9236 && this.field_6002.field_9229.nextFloat() < MiskatonicMysteries.config.entities.statueEffectChance) {
            Iterable positions = class_2338.method_25996((class_2338)this.method_24515(), (int)10, (int)10, (int)10);
            for (class_2338 position : positions) {
                if (!(this.field_6002.method_8320(position).method_26204() instanceof StatueBlock)) continue;
                ((StatueBlock)this.field_6002.method_8320(position).method_26204()).selectStatusEffects(this, this);
                break;
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void handleMiskStats(CallbackInfo info) {
        for (Blessing blessing : this.blessings) {
            blessing.tick(this);
        }
        if (this.getResonance() > 0.0f) {
            if (this.getSanity() < 750) {
                this.method_6092(new class_1293(class_1294.field_5924, 100, 0, true, true, false));
                if (this.getSanity() < 500 && !this.field_6002.field_9236 && this.getResonance() > 0.4f && this.field_6012 % 400 == 0) {
                    this.method_7316(this.field_5974.nextInt(10));
                }
            }
            this.setResonance(this.getResonance() - 0.01f);
        }
        if (this.getSpellCooldown() > 0) {
            this.setSpellCooldown(this.getSpellCooldown() - 1);
        }
        if (this.field_6012 % MiskatonicMysteries.config.modUpdateInterval == 0 && this.isShocked() && this.field_5974.nextFloat() < MiskatonicMysteries.config.sanity.shockRemoveChance) {
            this.setShocked(false);
        }
        if (!this.field_6002.field_9236 && this.field_6012 > 100 && this.field_6012 % MiskatonicMysteries.config.sanity.insanityInterval == 0) {
            InsanityHandler.handleInsanityEvents((class_1657)this);
        }
    }

    @Shadow
    public abstract void method_7316(int var1);

    @Shadow
    public abstract boolean method_7276();

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void manipulateProtagonistDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> infoReturnable) {
        if (source.method_5529() instanceof ProtagonistEntity && !(source instanceof Constants.DamageSources.ProtagonistDamageSource)) {
            ((class_1657)this).method_5643((class_1282)new Constants.DamageSources.ProtagonistDamageSource(source.method_5529()), amount);
        }
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void manipulateDeath(class_1282 source, float amount, CallbackInfoReturnable<Boolean> infoReturnable) {
        if (amount >= this.method_6032() && !source.method_5538()) {
            class_1657 entity = (class_1657)this;
            if (InventoryUtil.getSlotForItemInHotbar(entity, MMObjects.RE_AGENT_SYRINGE) >= 0) {
                entity.field_7514.method_5438(InventoryUtil.getSlotForItemInHotbar(entity, MMObjects.RE_AGENT_SYRINGE)).method_7934(1);
                if (LazarusStatusEffect.revive(entity)) {
                    this.field_6272 = false;
                    this.field_5988 = false;
                    infoReturnable.setReturnValue((Object)false);
                    infoReturnable.cancel();
                }
            } else if (this.method_29504() && source instanceof Constants.DamageSources.ProtagonistDamageSource) {
                MiskatonicMysteriesAPI.resetProgress((class_1657)this);
                if (source.method_5526() instanceof ProtagonistEntity) {
                    ((ProtagonistEntity)source.method_5529()).removeAfterTargetKill();
                }
            }
        }
    }

    @Inject(method={"initDataTracker()V"}, at={@At(value="TAIL")})
    private void addMiskStats(CallbackInfo info) {
        this.field_6011.method_12784(Constants.DataTrackers.SANITY, (Object)1000);
        this.field_6011.method_12784(Constants.DataTrackers.SHOCKED, (Object)false);
        this.field_6011.method_12784(Constants.DataTrackers.STAGE, (Object)0);
        this.field_6011.method_12784(Constants.DataTrackers.POWER_POOL, (Object)0);
        this.field_6011.method_12784(Constants.DataTrackers.SPELL_COOLDOWN, (Object)0);
        this.field_6011.method_12784(Constants.DataTrackers.MAX_SPELLS, (Object)3);
        this.field_6011.method_12784(Constants.DataTrackers.AFFILIATION, (Object)MMAffiliations.NONE);
        this.field_6011.method_12784(Constants.DataTrackers.APPARENT_AFFILIATION, (Object)MMAffiliations.NONE);
        this.field_6011.method_12784(Constants.DataTrackers.RESONANCE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public int getSanity() {
        return (Integer)this.field_6011.method_12789(Constants.DataTrackers.SANITY);
    }

    @Override
    public void setSanity(int sanity, boolean ignoreFactors) {
        if (ignoreFactors || !this.isShocked() && !this.method_6059(MMStatusEffects.TRANQUILIZED)) {
            this.field_6011.method_12778(Constants.DataTrackers.SANITY, (Object)class_3532.method_15340((int)sanity, (int)0, (int)this.getMaxSanity()));
        }
    }

    @Override
    public void setShocked(boolean shocked) {
        this.field_6011.method_12778(Constants.DataTrackers.SHOCKED, (Object)shocked);
    }

    @Override
    public boolean isShocked() {
        return (Boolean)this.field_6011.method_12789(Constants.DataTrackers.SHOCKED);
    }

    @Override
    public int getMaxSanity() {
        int mod = 0;
        for (Integer value : this.getSanityCapExpansions().values()) {
            mod += value.intValue();
        }
        return 1000 + mod;
    }

    @Override
    public void addSanityCapExpansion(String name, int amount) {
        if ((class_1657)this instanceof class_3222) {
            this.sanityCapOverrides.putIfAbsent(name, amount);
            ExpandSanityPacket.send((class_1657)((class_3222)this), name, amount);
            if (this.getSanity() > this.getMaxSanity()) {
                this.setSanity(this.getMaxSanity(), true);
            }
        }
    }

    @Override
    public void removeSanityCapExpansion(String name) {
        if (!this.field_6002.field_9236 && this.sanityCapOverrides.containsKey(name)) {
            this.sanityCapOverrides.remove(name);
            RemoveExpansionPacket.send((class_1657)this, name);
        }
    }

    @Override
    public Map<String, Integer> getSanityCapExpansions() {
        return this.sanityCapOverrides;
    }

    @Override
    public void syncSanityData() {
        if (!this.field_6002.field_9236) {
            this.sanityCapOverrides.forEach((s, i) -> ExpandSanityPacket.send((class_1657)this, s, i));
        }
    }

    @Inject(method={"writeCustomDataToTag(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void writeMiskData(class_2487 compoundTag, CallbackInfo info) {
        class_2487 tag = new class_2487();
        tag.method_10569("Sanity", this.getSanity());
        tag.method_10556("Shocked", this.isShocked());
        class_2499 expansions = new class_2499();
        this.getSanityCapExpansions().forEach((s, i) -> {
            class_2487 expansionTag = new class_2487();
            expansionTag.method_10582("Name", s);
            expansionTag.method_10569("Amount", i.intValue());
            expansions.add((Object)expansionTag);
        });
        tag.method_10566("SanityExpansions", (class_2520)expansions);
        tag.method_10569("MaxPower", this.getPowerPool());
        tag.method_10569("MaxSpells", this.getMaxSpells());
        tag.method_10569("SpellCooldown", this.getSpellCooldown());
        NbtUtil.writeSpellData(this, tag);
        tag.method_10569("AscensionStage", this.getAscensionStage());
        tag.method_10582("Affiliation", this.getAffiliation(false).getId().toString());
        tag.method_10582("ApparentAffiliation", this.getAffiliation(true).getId().toString());
        tag.method_10548("Resonance", this.getResonance());
        NbtUtil.writeBlessingData(this, tag);
        compoundTag.method_10566("MiskMystData", (class_2520)tag);
    }

    @Inject(method={"readCustomDataFromTag(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readMiskData(class_2487 compoundTag, CallbackInfo info) {
        class_2487 tag = (class_2487)compoundTag.method_10580("MiskMystData");
        if (tag != null) {
            this.setSanity(tag.method_10550("Sanity"), true);
            this.setShocked(tag.method_10577("Shocked"));
            this.getSanityCapExpansions().clear();
            ((class_2499)tag.method_10580("SanityExpansions")).forEach(s -> this.sanityCapOverrides.put(((class_2487)s).method_10558("Name"), ((class_2487)s).method_10550("Amount")));
            this.setPowerPool(tag.method_10550("MaxPower"));
            this.setMaxSpells(tag.method_10550("MaxSpells"));
            this.setSpellCooldown(tag.method_10550("SpellCooldown"));
            NbtUtil.readSpellData(this, tag);
            this.setAscensionStage(tag.method_10550("AscensionStage"));
            this.setAffiliation((Affiliation)MMRegistries.AFFILIATIONS.method_10223(new class_2960(tag.method_10558("Affiliation"))), false);
            this.setAffiliation((Affiliation)MMRegistries.AFFILIATIONS.method_10223(new class_2960(tag.method_10558("ApparentAffiliation"))), true);
            NbtUtil.readBlessingData(this, tag);
            this.setResonance(tag.method_10583("Resonance"));
        }
    }

    @Override
    public boolean isSupernatural() {
        return false;
    }

    @Override
    public Affiliation getAffiliation(boolean apparent) {
        return (Affiliation)this.field_6011.method_12789(apparent ? Constants.DataTrackers.APPARENT_AFFILIATION : Constants.DataTrackers.AFFILIATION);
    }

    @Override
    public void setAffiliation(Affiliation affiliation, boolean apparent) {
        this.field_6011.method_12778(apparent ? Constants.DataTrackers.APPARENT_AFFILIATION : Constants.DataTrackers.AFFILIATION, (Object)affiliation);
    }

    @Override
    public int getMaxSpells() {
        return (Integer)this.field_6011.method_12789(Constants.DataTrackers.MAX_SPELLS);
    }

    @Override
    public void setMaxSpells(int amount) {
        this.field_6011.method_12778(Constants.DataTrackers.MAX_SPELLS, (Object)amount);
    }

    @Override
    public int getPowerPool() {
        return (Integer)this.field_6011.method_12789(Constants.DataTrackers.POWER_POOL);
    }

    @Override
    public void setPowerPool(int amount) {
        this.field_6011.method_12778(Constants.DataTrackers.POWER_POOL, (Object)amount);
    }

    @Override
    public List<Spell> getSpells() {
        return this.spells;
    }

    @Override
    public Set<SpellEffect> getLearnedEffects() {
        return this.learnedEffects;
    }

    @Override
    public Set<SpellMedium> getLearnedMediums() {
        return this.learnedMediums;
    }

    @Override
    public void learnEffect(SpellEffect effect) {
        this.learnedEffects.add(effect);
    }

    @Override
    public void learnMedium(SpellMedium medium) {
        this.learnedMediums.add(medium);
    }

    @Override
    public void setSpellCooldown(int ticks) {
        this.field_6011.method_12778(Constants.DataTrackers.SPELL_COOLDOWN, (Object)ticks);
    }

    @Override
    public int getSpellCooldown() {
        return (Integer)this.field_6011.method_12789(Constants.DataTrackers.SPELL_COOLDOWN);
    }

    @Override
    public void syncSpellData() {
        if (!this.field_6002.field_9236) {
            SyncSpellCasterDataPacket.send(false, (class_1657)this, this);
        }
    }

    @Override
    public int getAscensionStage() {
        return (Integer)this.field_6011.method_12789(Constants.DataTrackers.STAGE);
    }

    @Override
    public void setAscensionStage(int level) {
        this.field_6011.method_12778(Constants.DataTrackers.STAGE, (Object)level);
    }

    @Override
    public boolean removeBlessing(Blessing blessing) {
        if (this.blessings.contains(blessing)) {
            blessing.onRemoved(this);
            return this.blessings.remove(blessing);
        }
        return false;
    }

    @Override
    public List<Blessing> getBlessings() {
        return this.blessings;
    }

    @Override
    public void addBlessing(Blessing blessing) {
        if (!this.blessings.contains(blessing) && this.blessings.size() < 3) {
            this.blessings.add(blessing);
            blessing.onAcquired(this);
        }
    }

    @Override
    public void syncBlessingData() {
        if (!this.field_6002.field_9236) {
            SyncBlessingsPacket.send((class_1309)((class_1657)this), this);
        }
    }

    @Override
    public void setResonance(float resonance) {
        this.field_6011.method_12778(Constants.DataTrackers.RESONANCE, (Object)Float.valueOf(resonance));
    }

    @Override
    public float getResonance() {
        return ((Float)this.field_6011.method_12789(Constants.DataTrackers.RESONANCE)).floatValue();
    }

    @Inject(method={"shouldRenderName"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void shouldRenderName(CallbackInfoReturnable<Boolean> cir) {
        if (!MaskTrinketItem.getMask((class_1657)this).method_7960()) {
            cir.setReturnValue((Object)false);
        }
    }
}

