/*
 * Decompiled with CFR 0.152.
 */
package me.jrm_wrm.mob_gems.items.mob_gem_items;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import me.jrm_wrm.mob_gems.items.MobGemItem;
import me.jrm_wrm.mob_gems.registry.ModPackets;
import me.jrm_wrm.mob_gems.util.WorldUtil;
import me.jrm_wrm.mob_gems.util.mixin.ItemUsageContextMixin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3965;

public class BeeMobGem
extends MobGemItem {
    private int braceletRange = 2;
    private ArrayList<class_1309> movedEntities = new ArrayList();

    public <T extends class_1308> BeeMobGem(class_1299<T> type, int tint) {
        super(type, tint);
    }

    @Override
    public void onAugmenterTick(class_1799 bracelet, class_1799 gemStack, class_1937 world, class_1309 wearer, int slot) {
        this.beeBraceletTick(world, wearer, (class_2394)class_2398.field_20537, (sourcePos, targetPos) -> {
            if (world.field_9229.nextDouble() > 0.004) {
                return;
            }
            this.bonemeal(new class_243(sourcePos.method_10216(), sourcePos.method_10214(), sourcePos.method_10215()), (class_2338)targetPos, world);
        });
    }

    @Override
    public void onDiminisherTick(class_1799 bracelet, class_1799 gemStack, class_1937 world, class_1309 wearer, int slot) {
        this.beeBraceletTick(world, wearer, (class_2394)class_2398.field_22247, (sourcePos, targetPos) -> {
            boolean flower;
            if (world.field_9229.nextDouble() > 0.05) {
                return;
            }
            class_2248 block = world.method_8320(targetPos).method_26204();
            boolean bl = flower = block.method_9525(TagRegistry.block((class_2960)new class_2960("minecraft", "flowers"))) && block != class_2246.field_10606;
            if (flower || this.isGrowable(block) || block == class_2246.field_10479 || block == class_2246.field_10214) {
                world.method_8650(targetPos, false);
                world.method_8408(targetPos, block);
                if (flower && world.field_9229.nextDouble() < 0.1) {
                    world.method_8501(targetPos, class_2246.field_10606.method_9564());
                }
            }
        });
    }

    private void beeBraceletTick(class_1937 world, class_1309 wearer, class_2394 particle, BiConsumer<class_243, class_2338> blockHandler) {
        class_243 pos = wearer.method_19538();
        class_2338 blockPos = wearer.method_24515();
        if (world.field_9236) {
            if (wearer.method_18798().method_10216() == 0.0 && wearer.method_18798().method_10215() == 0.0) {
                if (this.movedEntities.contains(wearer)) {
                    this.movedEntities.remove(wearer);
                    this.sendMovingPacket(false, wearer.method_5628());
                }
            } else {
                if (!this.movedEntities.contains(wearer)) {
                    this.movedEntities.add(wearer);
                    this.sendMovingPacket(true, wearer.method_5628());
                }
                double effectX = pos.method_10216() + (world.field_9229.nextDouble() - 0.5) / 3.0;
                double effectY = wearer.method_23323(0.5);
                double effectZ = pos.method_10215() + (world.field_9229.nextDouble() - 0.5) / 3.0;
                world.method_8406(particle, effectX, effectY, effectZ, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.movedEntities.contains(wearer)) {
            for (int x = blockPos.method_10263() - this.braceletRange; x < blockPos.method_10263() + this.braceletRange; ++x) {
                for (int y = blockPos.method_10264() - this.braceletRange; y < blockPos.method_10264() + this.braceletRange; ++y) {
                    for (int z = blockPos.method_10260() - this.braceletRange; z < blockPos.method_10260() + this.braceletRange; ++z) {
                        class_2338 targetPos = new class_2338(x, y, z);
                        blockHandler.accept(pos, targetPos);
                    }
                }
            }
        }
    }

    @Override
    public void onCageTick(class_1799 stack, class_1937 world, class_2338 pos) {
        class_238 box = WorldUtil.getRangeBox(pos, 10.0);
        int x = (int)box.field_1323;
        while ((double)x <= box.field_1320) {
            int y = (int)box.field_1322;
            while ((double)y <= box.field_1325) {
                int z = (int)box.field_1321;
                while ((double)z <= box.field_1324) {
                    class_2338 blockPos2 = new class_2338(x, y, z);
                    class_2248 block = world.method_8320(blockPos2).method_26204();
                    if (world.field_9229.nextDouble() < 0.003 && this.isGrowable(block)) {
                        this.bonemeal(new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), blockPos2, world);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private boolean isGrowable(class_2248 block) {
        return block.method_9525(TagRegistry.block((class_2960)new class_2960("minecraft", "bee_growables"))) || block.method_9525(TagRegistry.block((class_2960)new class_2960("minecraft", "saplings")));
    }

    private void bonemeal(class_243 sourcePos, class_2338 bonemealPos, class_1937 world) {
        class_1657 closestPlayer = world.method_18459(sourcePos.method_10216(), sourcePos.method_10214(), sourcePos.method_10215(), 128.0, false);
        if (closestPlayer != null) {
            class_3965 hit = new class_3965(sourcePos, class_2350.field_11036, bonemealPos, false);
            class_1838 context = new class_1838(closestPlayer, class_1268.field_5808, hit);
            ((ItemUsageContextMixin)context).setStack(class_1799.field_8037);
            class_1802.field_8324.method_7884(context);
        }
    }

    private void sendMovingPacket(boolean moving, int entityId) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(moving);
        buf.writeInt(entityId);
        ClientPlayNetworking.send((class_2960)ModPackets.SET_MOVING_TAG_PACKET_ID, (class_2540)buf);
    }

    public void receiveMovingPacket(boolean moving, int entityId, class_1657 player) {
        class_1309 entity = (class_1309)player.field_6002.method_8469(entityId);
        System.out.println(moving);
        if (moving) {
            this.movedEntities.add(entity);
        } else {
            this.movedEntities.remove(entity);
        }
    }
}

