/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerModularRouter;
import me.desht.modularrouters.container.handler.BufferHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.event.TickEventHandler;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.upgrade.SecurityUpgrade;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.ItemBeamMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterUpgradesSyncMessage;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import me.desht.modularrouters.util.fake_player.FakeNetHandlerPlayerServer;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ModularRouterBlockEntity
extends BlockEntity
implements ICamouflageable,
MenuProvider {
    public static final GameProfile DEFAULT_FAKEPLAYER_PROFILE = new GameProfile(UUID.nameUUIDFromBytes("modularrouters".getBytes()), "[Modular Routers]");
    private static final int N_MODULE_SLOTS = 9;
    private static final int N_UPGRADE_SLOTS = 5;
    private static final int N_BUFFER_SLOTS = 1;
    public static final int COMPILE_MODULES = 1;
    public static final int COMPILE_UPGRADES = 2;
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_ACTIVE_TIMER = "ActiveTimer";
    private static final String NBT_ECO_MODE = "EcoMode";
    private static final String NBT_BUFFER = "Buffer";
    public static final String NBT_MODULES = "Modules";
    public static final String NBT_UPGRADES = "Upgrades";
    private static final String NBT_EXTRA = "Extra";
    public static final String NBT_REDSTONE_MODE = "Redstone";
    private static final String NBT_ENERGY = "EnergyBuffer";
    private static final String NBT_ENERGY_DIR = "EnergyDirection";
    private static final String NBT_ENERGY_UPGRADES = "EnergyUpgrades";
    private int counter = 0;
    private int pulseCounter = 0;
    private RouterRedstoneBehaviour redstoneBehaviour = RouterRedstoneBehaviour.ALWAYS;
    private final BufferHandler bufferHandler = new BufferHandler(this);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.bufferHandler);
    private final ItemStackHandler modulesHandler = new ModuleHandler();
    private final ItemStackHandler upgradesHandler = new UpgradeHandler();
    private final RouterEnergyBuffer energyStorage = new RouterEnergyBuffer(0);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    public final TrackedEnergy trackedEnergy = new TrackedEnergy();
    private EnergyDirection energyDirection = EnergyDirection.FROM_ROUTER;
    private final List<CompiledIndexedModule> compiledModules = new ArrayList<CompiledIndexedModule>();
    private byte recompileNeeded = (byte)3;
    private int tickRate = MRConfig.Common.Router.baseTickRate;
    private int itemsPerTick = 1;
    private final Map<ResourceLocation, Integer> upgradeCount = new HashMap<ResourceLocation, Integer>();
    private int fluidTransferRate;
    private int fluidTransferRemainingIn = 0;
    private int fluidTransferRemainingOut = 0;
    private final int SIDES = MiscUtil.DIRECTIONS.length;
    private final int[] redstoneLevels = new int[this.SIDES];
    private final int[] newRedstoneLevels = new int[this.SIDES];
    private final DetectorModule.SignalType[] signalType = new DetectorModule.SignalType[this.SIDES];
    private final DetectorModule.SignalType[] newSignalType = new DetectorModule.SignalType[this.SIDES];
    private boolean canEmit;
    private boolean prevCanEmit;
    private int redstonePower = -1;
    private int lastPower;
    private boolean active;
    private int activeTimer = 0;
    private final Set<UUID> permitted = Sets.newHashSet();
    private byte sidesOpen;
    private boolean ecoMode = false;
    private int ecoCounter = MRConfig.Common.Router.ecoTimeout;
    private boolean hasPulsedModules = false;
    private CompoundTag extData;
    private BlockState camouflage = null;
    private int tunedSyncValue = -1;
    private boolean executing;
    private boolean careAboutItemAttributes;
    public final List<BeamData> beams = new ArrayList<BeamData>();
    public final List<BeamData> pendingBeams = new ArrayList<BeamData>();
    private AABB cachedRenderAABB;
    private RouterFakePlayer fakePlayer;

    public ModularRouterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get(), pos, state);
    }

    public IItemHandler getBuffer() {
        return this.bufferHandler;
    }

    public IItemHandler getModules() {
        return this.modulesHandler;
    }

    public IItemHandler getUpgrades() {
        return this.upgradesHandler;
    }

    public CompoundTag m_5995_() {
        int nEnergy;
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("x", this.f_58858_.m_123341_());
        compound.m_128405_("y", this.f_58858_.m_123342_());
        compound.m_128405_("z", this.f_58858_.m_123343_());
        if (this.camouflage != null) {
            compound.m_128365_("BlockStateName", (Tag)NbtUtils.m_129202_((BlockState)this.camouflage));
        }
        if ((nEnergy = this.getUpgradeCount((Item)ModItems.ENERGY_UPGRADE.get())) > 0) {
            compound.m_128405_(NBT_ENERGY_UPGRADES, nEnergy);
        }
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.processClientSync(tag);
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, -1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.processClientSync(pkt.m_131708_());
    }

    private void processClientSync(CompoundTag compound) {
        if (compound.m_128441_("BlockStateName")) {
            this.setCamouflage(NbtUtils.m_129241_((CompoundTag)compound.m_128469_("BlockStateName")));
        } else {
            this.setCamouflage(null);
        }
        this.energyStorage.updateForEnergyUpgrades(compound.m_128451_(NBT_ENERGY_UPGRADES));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.bufferHandler.getFluidCapability().cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return this.bufferHandler.getFluidItemCapability().cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorage.getTransferRate() > 0 ? this.energyCap.cast() : this.bufferHandler.getEnergyCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.bufferHandler.deserializeNBT(nbt.m_128469_(NBT_BUFFER));
        this.modulesHandler.deserializeNBT(nbt.m_128469_(NBT_MODULES));
        this.upgradesHandler.deserializeNBT(nbt.m_128469_(NBT_UPGRADES));
        this.energyStorage.deserializeNBT((Tag)nbt.m_128469_(NBT_ENERGY));
        this.energyDirection = EnergyDirection.forValue(nbt.m_128461_(NBT_ENERGY_DIR));
        this.redstoneBehaviour = RouterRedstoneBehaviour.forValue(nbt.m_128461_(NBT_REDSTONE_MODE));
        this.active = nbt.m_128471_(NBT_ACTIVE);
        this.activeTimer = nbt.m_128451_(NBT_ACTIVE_TIMER);
        this.ecoMode = nbt.m_128471_(NBT_ECO_MODE);
        CompoundTag ext = nbt.m_128469_(NBT_EXTRA);
        CompoundTag ext1 = this.getExtensionData();
        for (String key : ext.m_128431_()) {
            ext1.m_128365_(key, ext.m_128423_(key));
        }
        this.counter = -1;
    }

    @Nonnull
    public CompoundTag m_6945_(CompoundTag nbt) {
        nbt = super.m_6945_(nbt);
        nbt.m_128365_(NBT_BUFFER, (Tag)this.bufferHandler.serializeNBT());
        if (this.hasItems((IItemHandler)this.modulesHandler)) {
            nbt.m_128365_(NBT_MODULES, (Tag)this.modulesHandler.serializeNBT());
        }
        if (this.hasItems((IItemHandler)this.upgradesHandler)) {
            nbt.m_128365_(NBT_UPGRADES, (Tag)this.upgradesHandler.serializeNBT());
        }
        if (this.redstoneBehaviour != RouterRedstoneBehaviour.ALWAYS) {
            nbt.m_128359_(NBT_REDSTONE_MODE, this.redstoneBehaviour.name());
        }
        if (this.energyStorage.getCapacity() > 0) {
            nbt.m_128365_(NBT_ENERGY, this.energyStorage.serializeNBT());
        }
        if (this.energyDirection != EnergyDirection.FROM_ROUTER) {
            nbt.m_128359_(NBT_ENERGY_DIR, this.energyDirection.name());
        }
        nbt.m_128379_(NBT_ACTIVE, this.active);
        nbt.m_128405_(NBT_ACTIVE_TIMER, this.activeTimer);
        nbt.m_128379_(NBT_ECO_MODE, this.ecoMode);
        CompoundTag ext = new CompoundTag();
        CompoundTag ext1 = this.getExtensionData();
        for (String key : ext1.m_128431_()) {
            ext.m_128365_(key, ext1.m_128423_(key));
        }
        nbt.m_128365_(NBT_EXTRA, (Tag)ext);
        return nbt;
    }

    private boolean hasItems(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void clientTick() {
        Iterator<BeamData> iterator = this.beams.iterator();
        while (iterator.hasNext()) {
            BeamData beam = iterator.next();
            beam.tick();
            if (!beam.isExpired()) continue;
            iterator.remove();
            this.cachedRenderAABB = null;
        }
    }

    public void serverTick() {
        if (this.recompileNeeded != 0) {
            this.compile();
        }
        ++this.counter;
        ++this.pulseCounter;
        if (this.fakePlayer != null) {
            this.fakePlayer.m_8119_();
            this.fakePlayer.m_36335_().m_41518_();
        }
        if (this.getRedstoneBehaviour() == RouterRedstoneBehaviour.PULSE) {
            if (this.activeTimer > 0 && --this.activeTimer == 0) {
                this.setActive(false);
            }
        } else if (this.counter >= this.getTickRate()) {
            this.allocateFluidTransfer(this.counter);
            this.executeModules(false);
            this.counter = 0;
        }
        if (this.ecoMode) {
            if (this.active) {
                this.ecoCounter = MRConfig.Common.Router.ecoTimeout;
            } else if (this.ecoCounter > 0) {
                --this.ecoCounter;
            }
        }
        this.maybeDoEnergyTransfer();
    }

    private void maybeDoEnergyTransfer() {
        if (this.getEnergyCapacity() > 0 && !this.getBufferItemStack().m_41619_() && this.redstoneBehaviour.shouldRun(this.getRedstonePower() > 0, false)) {
            switch (this.energyDirection) {
                case FROM_ROUTER: {
                    this.bufferHandler.getEnergyCapability().ifPresent(energyHandler -> {
                        int toExtract = this.getEnergyStorage().extractEnergy(this.getEnergyXferRate(), true);
                        int received = energyHandler.receiveEnergy(toExtract, false);
                        this.getEnergyStorage().extractEnergy(received, false);
                    });
                    break;
                }
                case TO_ROUTER: {
                    this.bufferHandler.getEnergyCapability().ifPresent(energyHandler -> {
                        int toExtract = energyHandler.extractEnergy(this.getEnergyXferRate(), true);
                        int received = this.energyStorage.receiveEnergy(toExtract, false);
                        energyHandler.extractEnergy(received, false);
                    });
                }
            }
        }
    }

    public RouterFakePlayer getFakePlayer() {
        if (!(this.m_58904_() instanceof ServerLevel)) {
            return null;
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = new RouterFakePlayer(this, (ServerLevel)this.m_58904_(), this.getOwner());
            this.fakePlayer.f_8906_ = new FakeNetHandlerPlayerServer(this.f_58857_.m_142572_(), (ServerPlayer)this.fakePlayer);
            this.fakePlayer.f_19853_ = this.f_58857_;
            this.fakePlayer.m_150109_().f_35977_ = 0;
            this.fakePlayer.m_20343_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        return this.fakePlayer;
    }

    private GameProfile getOwner() {
        for (int i = 0; i < this.getUpgrades().getSlots(); ++i) {
            ItemStack stack = this.getUpgrades().getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof SecurityUpgrade)) continue;
            SecurityUpgrade securityUpgrade = (SecurityUpgrade)item;
            String name = securityUpgrade.getOwnerName(stack);
            UUID id = securityUpgrade.getOwnerID(stack);
            if (id == null && name == null) continue;
            return new GameProfile(id, name);
        }
        return DEFAULT_FAKEPLAYER_PROFILE;
    }

    private void executeModules(boolean pulsed) {
        boolean powered;
        this.executing = true;
        boolean newActive = false;
        boolean bl = powered = pulsed || this.getRedstonePower() > 0;
        if (this.redstoneBehaviour.shouldRun(powered, pulsed)) {
            if (this.prevCanEmit || this.canEmit) {
                Arrays.fill(this.newRedstoneLevels, 0);
                Arrays.fill((Object[])this.newSignalType, (Object)DetectorModule.SignalType.NONE);
            }
            for (CompiledIndexedModule cim : this.compiledModules) {
                CompiledModule cm = cim.compiledModule;
                if (cm == null || !cm.hasTarget() || cm.getEnergyCost() > this.getEnergyStorage().getEnergyStored() || !cm.shouldRun(powered, pulsed)) continue;
                if (cm.execute(this)) {
                    cm.getFilter().cycleRoundRobin().ifPresent(counter -> {
                        ItemStack moduleStack = this.modulesHandler.getStackInSlot(cim.index);
                        ModuleHelper.setRoundRobinCounter(moduleStack, counter);
                    });
                    this.getEnergyStorage().extractEnergy(cm.getEnergyCost(), false);
                    newActive = true;
                    if (cm.termination() != ModuleItem.Termination.RAN) continue;
                    break;
                }
                if (cm.termination() != ModuleItem.Termination.NOT_RAN) continue;
                break;
            }
            if (!this.pendingBeams.isEmpty()) {
                PacketHandler.NETWORK.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_58904_().m_46745_(this.m_58899_())), (Object)new ItemBeamMessage(this, this.pendingBeams));
                this.pendingBeams.clear();
            }
            if (this.prevCanEmit || this.canEmit) {
                this.handleRedstoneEmission();
            }
        }
        this.setActive(newActive);
        this.prevCanEmit = this.canEmit;
        this.executing = false;
    }

    public int getTickRate() {
        return this.ecoMode && this.ecoCounter == 0 ? MRConfig.Common.Router.lowPowerTickRate : this.tickRate;
    }

    public RouterRedstoneBehaviour getRedstoneBehaviour() {
        return this.redstoneBehaviour;
    }

    public void setRedstoneBehaviour(RouterRedstoneBehaviour redstoneBehaviour) {
        this.redstoneBehaviour = redstoneBehaviour;
        if (redstoneBehaviour == RouterRedstoneBehaviour.PULSE) {
            this.lastPower = this.getRedstonePower();
        }
        this.handleSync(false);
    }

    private void setActive(boolean newActive) {
        if (this.active != newActive) {
            this.active = newActive;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ModularRouterBlock.ACTIVE, (Comparable)Boolean.valueOf(newActive && this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 3)), 2);
        }
    }

    private void setSidesOpen(byte sidesOpen) {
        if (this.sidesOpen != sidesOpen) {
            this.sidesOpen = sidesOpen;
            this.handleSync(true);
        }
    }

    public void setEcoMode(boolean newEco) {
        if (newEco != this.ecoMode) {
            this.ecoMode = newEco;
            this.ecoCounter = MRConfig.Common.Router.ecoTimeout;
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camouflage;
    }

    @Override
    public void setCamouflage(BlockState newCamouflage) {
        if (newCamouflage != this.camouflage) {
            this.camouflage = newCamouflage;
            this.handleSync(true);
        }
    }

    private void handleSync(boolean renderUpdate) {
        if (!this.m_58904_().f_46443_) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        } else if (this.m_58904_().f_46443_ && renderUpdate) {
            this.requestModelDataUpdate();
            this.m_58904_().m_6550_(this.f_58858_, Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BlockCamo.CAMOUFLAGE_STATE, (Object)this.camouflage).build();
    }

    public boolean caresAboutItemAttributes() {
        return this.careAboutItemAttributes;
    }

    private void compile() {
        this.compileUpgrades();
        this.compileModules();
        if (this.tunedSyncValue >= 0) {
            this.counter = this.calculateSyncCounter();
        } else if (this.counter < 0) {
            this.counter = new Random().nextInt(this.tickRate);
        }
        BlockState state = this.m_58900_();
        this.m_58904_().m_46672_(this.f_58858_, state.m_60734_());
        this.m_6596_();
        this.recompileNeeded = 0;
    }

    private void compileModules() {
        if ((this.recompileNeeded & 1) != 0) {
            this.setHasPulsedModules(false);
            byte newSidesOpen = 0;
            for (CompiledIndexedModule cim : this.compiledModules) {
                cim.compiledModule.cleanup(this);
            }
            this.compiledModules.clear();
            this.careAboutItemAttributes = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.modulesHandler.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof ModuleItem)) continue;
                ModuleItem moduleItem = (ModuleItem)item;
                CompiledModule cms = moduleItem.compile(this, stack);
                this.compiledModules.add(new CompiledIndexedModule(cms, i));
                cms.onCompiled(this);
                newSidesOpen = (byte)(newSidesOpen | cms.getDirection().getMask());
                if (!cms.careAboutItemAttributes()) continue;
                this.careAboutItemAttributes = true;
            }
            this.setSidesOpen(newSidesOpen);
        }
    }

    private void compileUpgrades() {
        if (this.f_58857_.f_46443_ || (this.recompileNeeded & 2) != 0) {
            int prevMufflers = this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get());
            this.upgradeCount.clear();
            this.permitted.clear();
            this.setCamouflage(null);
            this.tunedSyncValue = -1;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = this.upgradesHandler.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof UpgradeItem)) continue;
                UpgradeItem upgradeItem = (UpgradeItem)item;
                this.upgradeCount.put(stack.m_41720_().getRegistryName(), this.getUpgradeCount(stack.m_41720_()) + stack.m_41613_());
                upgradeItem.onCompiled(stack, this);
            }
            this.itemsPerTick = 1 << Math.min(6, this.getUpgradeCount((Item)ModItems.STACK_UPGRADE.get()));
            this.tickRate = Math.max(MRConfig.Common.Router.hardMinTickRate, MRConfig.Common.Router.baseTickRate - MRConfig.Common.Router.ticksPerUpgrade * this.getUpgradeCount((Item)ModItems.SPEED_UPGRADE.get()));
            this.fluidTransferRate = Math.min(MRConfig.Common.Router.fluidMaxTransferRate, MRConfig.Common.Router.fluidBaseTransferRate + this.getUpgradeCount((Item)ModItems.FLUID_UPGRADE.get()) * MRConfig.Common.Router.mBperFluidUpgade);
            this.energyStorage.updateForEnergyUpgrades(this.getUpgradeCount((Item)ModItems.ENERGY_UPGRADE.get()));
            if (!this.f_58857_.f_46443_) {
                this.fakePlayer = null;
                int mufflers = this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get());
                if (prevMufflers != mufflers) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ModularRouterBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active && mufflers < 3)), 2);
                }
                this.notifyWatchingPlayers();
            }
        }
    }

    private void notifyWatchingPlayers() {
        for (Player player : this.f_58857_.m_6907_()) {
            ContainerModularRouter c;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof ContainerModularRouter) || (c = (ContainerModularRouter)abstractContainerMenu).getRouter() != this) continue;
            PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new RouterUpgradesSyncMessage(this));
        }
    }

    public void setTunedSyncValue(int newValue) {
        this.tunedSyncValue = newValue;
    }

    private int calculateSyncCounter() {
        int tuning = this.tunedSyncValue % this.tickRate;
        int compileTime = (int)TickEventHandler.TickCounter % this.tickRate;
        int delta = tuning - compileTime;
        if (delta <= 0) {
            delta += this.tickRate;
        }
        return this.tickRate - delta;
    }

    public void setAllowRedstoneEmission(boolean allow) {
        this.canEmit = allow;
        this.m_58904_().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ModularRouterBlock.CAN_EMIT, (Comparable)Boolean.valueOf(this.canEmit)));
    }

    public int getUpgradeCount(Item type) {
        return this.upgradeCount.getOrDefault(type.getRegistryName(), 0);
    }

    public void recompileNeeded(int what) {
        this.recompileNeeded = (byte)(this.recompileNeeded | what);
    }

    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    private void allocateFluidTransfer(int ticks) {
        int maxTransfer = MRConfig.Common.Router.baseTickRate * this.fluidTransferRate;
        this.fluidTransferRemainingIn = Math.min(this.fluidTransferRemainingIn + ticks * this.fluidTransferRate, maxTransfer);
        this.fluidTransferRemainingOut = Math.min(this.fluidTransferRemainingOut + ticks * this.fluidTransferRate, maxTransfer);
    }

    public int getFluidTransferRate() {
        return this.fluidTransferRate;
    }

    public int getCurrentFluidTransferAllowance(FluidModule1.FluidDirection dir) {
        return dir == FluidModule1.FluidDirection.IN ? this.fluidTransferRemainingIn : this.fluidTransferRemainingOut;
    }

    public void transferredFluid(int amount, FluidModule1.FluidDirection dir) {
        switch (dir) {
            case IN: {
                if (this.fluidTransferRemainingIn < amount) {
                    ModularRouters.LOGGER.warn("fluid transfer: " + this.fluidTransferRemainingIn + " < " + amount);
                }
                this.fluidTransferRemainingIn = Math.max(0, this.fluidTransferRemainingIn - amount);
                break;
            }
            case OUT: {
                if (this.fluidTransferRemainingOut < amount) {
                    ModularRouters.LOGGER.warn("fluid transfer: " + this.fluidTransferRemainingOut + " < " + amount);
                }
                this.fluidTransferRemainingOut = Math.max(0, this.fluidTransferRemainingOut - amount);
                break;
            }
        }
    }

    public Direction getAbsoluteFacing(ModuleItem.RelativeDirection direction) {
        return direction.toAbsolute((Direction)this.m_58900_().m_61143_((Property)ModularRouterBlock.FACING));
    }

    public ItemStack getBufferItemStack() {
        return this.bufferHandler.getStackInSlot(0);
    }

    public void checkForRedstonePulse() {
        this.redstonePower = this.calculateIncomingRedstonePower(this.f_58858_);
        if (this.executing) {
            return;
        }
        if (this.redstoneBehaviour == RouterRedstoneBehaviour.PULSE || this.hasPulsedModules && this.redstoneBehaviour == RouterRedstoneBehaviour.ALWAYS) {
            if (this.redstonePower > this.lastPower && this.pulseCounter >= this.tickRate) {
                this.allocateFluidTransfer(Math.min(this.pulseCounter, MRConfig.Common.Router.baseTickRate));
                this.executeModules(true);
                this.pulseCounter = 0;
                if (this.active) {
                    this.activeTimer = this.tickRate;
                }
            }
            this.lastPower = this.redstonePower;
        }
    }

    public void emitRedstone(ModuleItem.RelativeDirection direction, int power, DetectorModule.SignalType signalType) {
        if (direction == ModuleItem.RelativeDirection.NONE) {
            Arrays.fill(this.newRedstoneLevels, power);
            Arrays.fill((Object[])this.newSignalType, (Object)signalType);
        } else {
            Direction facing = this.getAbsoluteFacing(direction).m_122424_();
            this.newRedstoneLevels[facing.m_122411_()] = power;
            this.newSignalType[facing.m_122411_()] = signalType;
        }
    }

    public int getRedstoneLevel(Direction facing, boolean strong) {
        if (!this.canEmit) {
            return -1;
        }
        int i = facing.m_122411_();
        if (strong) {
            return this.signalType[i] == DetectorModule.SignalType.STRONG ? this.redstoneLevels[i] : 0;
        }
        return this.signalType[i] != DetectorModule.SignalType.NONE ? this.redstoneLevels[i] : 0;
    }

    private void handleRedstoneEmission() {
        boolean notifyOwnNeighbours = false;
        EnumSet<Direction> toNotify = EnumSet.noneOf(Direction.class);
        if (!this.canEmit) {
            notifyOwnNeighbours = true;
            for (Direction dir : MiscUtil.DIRECTIONS) {
                if (this.signalType[dir.m_122411_()] != DetectorModule.SignalType.STRONG) continue;
                toNotify.add(dir.m_122424_());
            }
            Arrays.fill(this.redstoneLevels, 0);
            Arrays.fill((Object[])this.signalType, (Object)DetectorModule.SignalType.NONE);
        } else {
            for (Direction dir : MiscUtil.DIRECTIONS) {
                int i = dir.m_122411_();
                if (this.newSignalType[i] != this.signalType[i]) {
                    toNotify.add(dir.m_122424_());
                    this.signalType[i] = this.newSignalType[i];
                }
                if (this.newRedstoneLevels[i] == this.redstoneLevels[i]) continue;
                notifyOwnNeighbours = true;
                if (this.newSignalType[i] == DetectorModule.SignalType.STRONG) {
                    toNotify.add(dir.m_122424_());
                }
                this.redstoneLevels[i] = this.newRedstoneLevels[i];
            }
        }
        for (Direction f : toNotify) {
            BlockPos pos2 = this.f_58858_.m_142300_(f);
            this.m_58904_().m_46672_(pos2, this.m_58904_().m_8055_(pos2).m_60734_());
        }
        if (notifyOwnNeighbours) {
            this.m_58904_().m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public void addPermittedIds(Set<UUID> permittedIds) {
        this.permitted.addAll(permittedIds);
    }

    public boolean isPermitted(Player player) {
        if (this.permitted.isEmpty() || this.permitted.contains(player.m_142081_())) {
            return true;
        }
        return Arrays.stream(InteractionHand.values()).anyMatch(hand -> player.m_21120_(hand).m_41720_() == ModItems.OVERRIDE_CARD.get());
    }

    public boolean isBufferFull() {
        ItemStack stack = this.bufferHandler.getStackInSlot(0);
        return !stack.m_41619_() && stack.m_41613_() >= stack.m_41741_();
    }

    public boolean isBufferEmpty() {
        return this.bufferHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack peekBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, true);
    }

    public ItemStack extractBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, false);
    }

    public ItemStack insertBuffer(ItemStack stack) {
        return this.bufferHandler.insertItem(0, stack, false);
    }

    public void setBufferItemStack(ItemStack stack) {
        this.bufferHandler.setStackInSlot(0, stack);
    }

    public boolean getEcoMode() {
        return this.ecoMode;
    }

    public void setHasPulsedModules(boolean hasPulsedModules) {
        this.hasPulsedModules = hasPulsedModules;
    }

    public int getRedstonePower() {
        if (this.redstonePower < 0) {
            this.redstonePower = this.calculateIncomingRedstonePower(this.f_58858_);
        }
        return this.redstonePower;
    }

    private int calculateIncomingRedstonePower(BlockPos pos) {
        int power = 0;
        for (Direction facing : MiscUtil.DIRECTIONS) {
            if (this.getExtensionData().m_128451_("ExtruderDist" + facing) > 0) continue;
            int p = this.m_58904_().m_46681_(pos.m_142300_(facing), facing);
            if (p >= 15) {
                return p;
            }
            if (p <= power) continue;
            power = p;
        }
        return power;
    }

    public CompoundTag getExtensionData() {
        if (this.extData == null) {
            this.extData = new CompoundTag();
        }
        return this.extData;
    }

    public void playSound(Player player, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0) {
            this.m_58904_().m_5594_(player, pos, sound, category, volume, pitch);
        }
    }

    public void notifyModules() {
        this.compiledModules.forEach(cim -> cim.compiledModule.onNeighbourChange(this));
    }

    public int getModuleSlotCount() {
        return 9;
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public int getBufferSlotCount() {
        return 1;
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.modularrouters.modular_router");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ContainerModularRouter(windowId, playerInventory, this.m_58899_());
    }

    public GlobalPos getGlobalPos() {
        return MiscUtil.makeGlobalPos(this.f_58857_, this.f_58858_);
    }

    public void setUpgradesFrom(IItemHandler handler) {
        if (handler.getSlots() == this.upgradesHandler.getSlots()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                this.upgradesHandler.setStackInSlot(i, handler.getStackInSlot(i));
            }
        }
        this.compileUpgrades();
    }

    public AABB getRenderBoundingBox() {
        if (this.cachedRenderAABB == null) {
            this.cachedRenderAABB = super.getRenderBoundingBox();
            this.beams.forEach(beam -> {
                this.cachedRenderAABB = this.cachedRenderAABB.m_82367_(beam.getAABB(this.m_58899_()));
            });
        }
        return this.cachedRenderAABB;
    }

    public void addItemBeam(BeamData beamData) {
        if (this.m_58904_().f_46443_) {
            this.beams.add(beamData);
            this.cachedRenderAABB = null;
        } else {
            this.pendingBeams.add(beamData);
        }
    }

    public int getEnergyCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergyXferRate() {
        return this.energyStorage.getTransferRate();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyDirection(EnergyDirection energyDirection) {
        this.energyDirection = energyDirection;
    }

    public EnergyDirection getEnergyDirection() {
        return this.energyDirection;
    }

    class ModuleHandler
    extends RouterItemHandler {
        ModuleHandler() {
            super(1, ModularRouterBlockEntity.this.getModuleSlotCount(), s -> s.m_41720_() instanceof ModuleItem);
        }
    }

    class UpgradeHandler
    extends RouterItemHandler {
        UpgradeHandler() {
            super(2, ModularRouterBlockEntity.this.getUpgradeSlotCount(), s -> s.m_41720_() instanceof UpgradeItem);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (slot == i || stack.m_41720_() != this.getStackInSlot(i).m_41720_()) continue;
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (!(stack.m_41720_() instanceof UpgradeItem)) {
                return 0;
            }
            return ((UpgradeItem)stack.m_41720_()).getStackLimit(slot);
        }
    }

    class RouterEnergyBuffer
    extends EnergyStorage {
        private int excess;

        public RouterEnergyBuffer(int capacity) {
            super(capacity);
            this.excess = 0;
        }

        public boolean canExtract() {
            return super.canExtract() && ModularRouterBlockEntity.this.getRedstoneBehaviour().shouldRun(ModularRouterBlockEntity.this.getRedstonePower() > 0, false);
        }

        public boolean canReceive() {
            return super.canReceive() && ModularRouterBlockEntity.this.getRedstoneBehaviour().shouldRun(ModularRouterBlockEntity.this.getRedstonePower() > 0, false);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int n = super.receiveEnergy(maxReceive, simulate);
            if (n != 0 && !simulate) {
                ModularRouterBlockEntity.this.m_6596_();
            }
            return n;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int n = super.extractEnergy(maxExtract, simulate);
            if (n != 0 && !simulate) {
                ModularRouterBlockEntity.this.m_6596_();
            }
            return n;
        }

        void updateForEnergyUpgrades(int nEnergyUpgrades) {
            int oldCapacity = this.capacity;
            this.capacity = MRConfig.Common.Router.fePerEnergyUpgrade * nEnergyUpgrades;
            if (this.energy > this.capacity) {
                this.excess += this.energy - this.capacity;
                this.energy = this.capacity;
            } else {
                int available = this.capacity - this.energy;
                int toMove = Math.min(available, this.excess);
                this.excess -= toMove;
                this.energy += toMove;
            }
            this.maxExtract = this.maxReceive = MRConfig.Common.Router.feXferPerEnergyUpgrade * nEnergyUpgrades;
            if (oldCapacity == 0 && this.capacity != 0 || oldCapacity != 0 && this.capacity == 0) {
                ModularRouterBlockEntity.this.m_58904_().m_46672_(ModularRouterBlockEntity.this.m_58899_(), (Block)ModBlocks.MODULAR_ROUTER.get());
            }
        }

        public int getTransferRate() {
            return this.maxExtract;
        }

        public Tag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Energy", this.energy);
            tag.m_128405_("Capacity", this.capacity);
            tag.m_128405_("Excess", this.excess);
            return tag;
        }

        public void deserializeNBT(Tag nbt) {
            Tag tag = nbt;
            if (!(tag instanceof CompoundTag)) {
                throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
            }
            CompoundTag compound = (CompoundTag)tag;
            this.energy = compound.m_128451_("Energy");
            this.capacity = compound.m_128451_("Capacity");
            this.excess = compound.m_128451_("Excess");
        }

        public int getCapacity() {
            return this.capacity;
        }

        void setEnergyStored(int energyStored) {
            this.energy = Math.min(energyStored, this.capacity);
        }
    }

    public class TrackedEnergy
    implements ContainerData {
        public int m_6413_(int idx) {
            int res = 0;
            if (idx == 0) {
                res = ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF;
            } else if (idx == 1) {
                res = (ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF0000) >> 16;
            }
            return res;
        }

        public void m_8050_(int idx, int val) {
            if (val < 0) {
                val += 65536;
            }
            if (idx == 0) {
                ModularRouterBlockEntity.this.energyStorage.setEnergyStored(ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF0000 | val);
            } else if (idx == 1) {
                ModularRouterBlockEntity.this.energyStorage.setEnergyStored(ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF | val << 16);
            }
        }

        public int m_6499_() {
            return 2;
        }
    }

    public static enum EnergyDirection implements IHasTranslationKey
    {
        FROM_ROUTER("from_router"),
        TO_ROUTER("to_router"),
        NONE("none");

        private final String text;

        private EnergyDirection(String text) {
            this.text = text;
        }

        public static EnergyDirection forValue(String string) {
            try {
                return EnergyDirection.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                return FROM_ROUTER;
            }
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.tooltip.energy." + this.text;
        }
    }

    private record CompiledIndexedModule(CompiledModule compiledModule, int index) {
    }

    abstract class RouterItemHandler
    extends ItemStackHandler {
        private final Predicate<ItemStack> validator;
        private final int flag;

        private RouterItemHandler(int flag, int size, Predicate<ItemStack> validator) {
            super(size);
            this.validator = validator;
            this.flag = flag;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return super.isItemValid(slot, stack) && this.validator.test(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ModularRouterBlockEntity.this.recompileNeeded(this.flag);
        }
    }
}

