/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client;

import com.mojang.blaze3d.platform.InputConstants;
import me.desht.modularrouters.client.gui.ModularRouterScreen;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.BulkItemFilterScreen;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.client.gui.filter.InspectionFilterScreen;
import me.desht.modularrouters.client.gui.filter.ModFilterScreen;
import me.desht.modularrouters.client.gui.filter.RegexFilterScreen;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.module.ActivatorModuleScreen;
import me.desht.modularrouters.client.gui.module.DetectorModuleScreen;
import me.desht.modularrouters.client.gui.module.DistributorModuleScreen;
import me.desht.modularrouters.client.gui.module.ExtruderModule2Screen;
import me.desht.modularrouters.client.gui.module.FlingerModuleScreen;
import me.desht.modularrouters.client.gui.module.FluidModuleScreen;
import me.desht.modularrouters.client.gui.module.PlayerModuleScreen;
import me.desht.modularrouters.client.gui.module.VacuumModuleScreen;
import me.desht.modularrouters.client.model.ModelBakeEventHandler;
import me.desht.modularrouters.client.render.area.ModuleTargetRenderer;
import me.desht.modularrouters.client.render.blockentity.ModularRouterBER;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.registry.ClientRegistry;

@Mod.EventBusSubscriber(modid="modularrouters", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static KeyMapping keybindConfigure;
    public static KeyMapping keybindModuleInfo;

    public static void initEarly() {
        FMLJavaModLoadingContext.get().getModEventBus().register(ModelBakeEventHandler.class);
        MinecraftForge.EVENT_BUS.register(ModuleTargetRenderer.class);
        MinecraftForge.EVENT_BUS.register(MouseOverHelp.class);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientSetup.setupRenderLayers();
            ClientSetup.registerScreenFactories();
            ClientSetup.registerItemModelOverrides();
        });
        ClientSetup.registerKeyBindings();
        FilterScreenFactory.registerGuiHandler((Item)ModItems.INSPECTION_FILTER.get(), InspectionFilterScreen::new);
        FilterScreenFactory.registerGuiHandler((Item)ModItems.REGEX_FILTER.get(), RegexFilterScreen::new);
    }

    @SubscribeEvent
    public static void init(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get(), ModularRouterBER::new);
    }

    private static void registerItemModelOverrides() {
        ItemProperties.register((Item)((Item)ModItems.DISTRIBUTOR_MODULE.get()), (ResourceLocation)MiscUtil.RL("mode"), (stack, world, entity, n) -> {
            CompoundTag compound;
            if (entity != null && (compound = stack.m_41737_("modularrouters")) != null) {
                return compound.m_128471_("Pulling") ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }

    private static void registerKeyBindings() {
        keybindConfigure = new KeyMapping("key.modularrouters.configure", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.m_84827_((int)67, (int)-1), "key.modularrouters.category");
        keybindModuleInfo = new KeyMapping("key.modularrouters.moduleInfo", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.m_84827_((int)73, (int)-1), "key.modularrouters.category");
        ClientRegistry.registerKeyBinding((KeyMapping)keybindConfigure);
        ClientRegistry.registerKeyBinding((KeyMapping)keybindModuleInfo);
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MODULAR_ROUTER.get()), renderType -> true);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TEMPLATE_FRAME.get()), renderType -> true);
    }

    private static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_ITEM_ROUTER.get()), ModularRouterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_BASIC.get()), AbstractModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_ACTIVATOR.get()), ActivatorModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_DETECTOR.get()), DetectorModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_DISTRIBUTOR.get()), DistributorModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_EXTRUDER2.get()), ExtruderModule2Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_FLINGER.get()), FlingerModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_FLUID.get()), FluidModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_PLAYER.get()), PlayerModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MODULE_VACUUM.get()), VacuumModuleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_BULK_ITEM_FILTER.get()), BulkItemFilterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CONTAINER_MOD_FILTER.get()), ModFilterScreen::new);
    }
}

