/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.logic.compiled.CompiledPlayerModule;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PlayerModuleScreen
extends AbstractModuleScreen {
    private static final ItemStack MAIN_INV_STACK = new ItemStack((ItemLike)Blocks.f_50087_);
    private static final ItemStack MAIN_NO_HOTBAR_INV_STACK = new ItemStack((ItemLike)Blocks.f_50618_);
    private static final ItemStack ARMOUR_STACK = new ItemStack((ItemLike)Items.f_42473_);
    private static final ItemStack OFFHAND_STACK = new ItemStack((ItemLike)Items.f_42740_);
    private static final ItemStack ENDER_STACK = new ItemStack((ItemLike)Blocks.f_50265_);
    private static final ItemStack ROUTER_STACK = new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get());
    private static final ItemStack[] STACKS = new ItemStack[]{MAIN_INV_STACK, MAIN_NO_HOTBAR_INV_STACK, ARMOUR_STACK, OFFHAND_STACK, ENDER_STACK};
    private SectionButton secButton;
    private OperationButton opButton;

    public PlayerModuleScreen(ContainerModule container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        CompiledPlayerModule cpm = new CompiledPlayerModule(null, this.moduleItemStack);
        this.secButton = new SectionButton(this.f_97735_ + 169, this.f_97736_ + 32, 16, 16, true, STACKS, cpm.getSection());
        this.m_142416_((GuiEventListener)this.secButton);
        this.opButton = new OperationButton(this.f_97735_ + 148, this.f_97736_ + 32, cpm.getOperation());
        this.m_142416_((GuiEventListener)this.opButton);
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 127, this.f_97736_ + 29, this.f_97735_ + 187, this.f_97736_ + 50, "modularrouters.guiText.popup.player.control");
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.m_93228_(matrixStack, this.f_97735_ + 167, this.f_97736_ + 31, PlayerModuleScreen.BUTTON_XY.x, PlayerModuleScreen.BUTTON_XY.y, 18, 18);
        GuiUtil.renderItemStack(matrixStack, this.f_96541_, ROUTER_STACK, this.f_97735_ + 128, this.f_97736_ + 32, "");
    }

    @Override
    protected CompoundTag buildMessageData() {
        CompoundTag compound = super.buildMessageData();
        compound.m_128405_("Operation", ((CompiledPlayerModule.Operation)this.opButton.getState()).ordinal());
        compound.m_128405_("Section", ((CompiledPlayerModule.Section)this.secButton.getState()).ordinal());
        return compound;
    }

    private class SectionButton
    extends ItemStackCyclerButton<CompiledPlayerModule.Section> {
        private final List<List<Component>> tips;

        SectionButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, CompiledPlayerModule.Section initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, PlayerModuleScreen.this);
            this.tips = Lists.newArrayList();
            for (CompiledPlayerModule.Section sect : CompiledPlayerModule.Section.values()) {
                this.tips.add(Collections.singletonList(ClientUtil.xlate(sect.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        public List<Component> getTooltip() {
            return this.tips.get(((CompiledPlayerModule.Section)this.getState()).ordinal());
        }
    }

    private class OperationButton
    extends TexturedCyclerButton<CompiledPlayerModule.Operation> {
        private final List<List<Component>> tooltips;

        OperationButton(int x, int y, CompiledPlayerModule.Operation initialVal) {
            super(x, y, 16, 16, initialVal, PlayerModuleScreen.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledPlayerModule.Operation op : CompiledPlayerModule.Operation.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(op.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((CompiledPlayerModule.Operation)this.getState()).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltips.get(((CompiledPlayerModule.Operation)this.getState()).ordinal());
        }
    }
}

