/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import net.minecraft.client.gui.screens.Screen;

public class TextFieldManager {
    private final List<TextFieldWidgetMR> textFields = Lists.newArrayList();
    private int focusedField = -1;
    private final Screen parent;

    public TextFieldManager(Screen parent) {
        this.parent = parent;
    }

    public void drawTextFields(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.m_84519_();
        this.textFields.forEach(tf -> tf.m_6303_(matrixStack, mouseX, mouseY, partialTicks));
    }

    public void tick() {
        if (this.focusedField >= 0) {
            this.textFields.get(this.focusedField).m_94120_();
        }
    }

    public boolean mouseClicked(double x, double y, int btn) {
        for (int i = 0; i < this.textFields.size(); ++i) {
            if (!this.textFields.get(i).m_6375_(x, y, btn)) continue;
            this.focus(i);
            return true;
        }
        this.focus(-1);
        return false;
    }

    public boolean mouseScrolled(double wheel) {
        if (wheel == 0.0) {
            return false;
        }
        if (this.isFocused() && this.textFields.get(this.focusedField).m_94213_()) {
            this.textFields.get(this.focusedField).onMouseWheel(wheel < 0.0 ? -1 : 1);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            boolean wasTextfieldFocused = this.isFocused();
            this.cycleFocus(Screen.m_96638_() ? -1 : 1);
            return wasTextfieldFocused;
        }
        if (this.isFocused() && this.textFields.get(this.focusedField).m_94213_()) {
            return this.textFields.get(this.focusedField).m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char c, int modifiers) {
        return this.isFocused() && this.textFields.get(this.focusedField).m_94213_() && this.textFields.get(this.focusedField).m_5534_(c, modifiers);
    }

    int addTextField(TextFieldWidgetMR textField) {
        this.textFields.add(textField);
        return this.textFields.size() - 1;
    }

    public void focus(int field) {
        if (field != this.focusedField) {
            if (this.focusedField != -1) {
                this.textFields.get(this.focusedField).m_93692_(false);
            }
            this.focusedField = field;
            if (this.focusedField != -1) {
                this.textFields.get(this.focusedField).m_93692_(true);
            }
        }
    }

    private void cycleFocus(int dir) {
        int f = this.focusedField;
        int c = 0;
        int oldF = f;
        do {
            ++c;
            if ((f += dir) < 0) {
                f = this.textFields.size() - 1;
                continue;
            }
            if (f < this.textFields.size()) continue;
            f = 0;
        } while (c < this.textFields.size() && !this.textFields.get(f).m_94213_() && f != this.focusedField);
        if (f != oldF) {
            this.focus(f);
            this.textFields.get(f).m_94201_();
            this.textFields.get(f).m_94208_(0);
            if (oldF >= 0 && oldF < this.textFields.size()) {
                this.textFields.get(oldF).m_94208_(this.textFields.get(oldF).m_94207_());
            }
        }
    }

    public boolean isFocused() {
        return this.focusedField >= 0;
    }

    void onTextFieldFocusChange(int ordinal, boolean newFocus) {
        TextFieldWidgetMR tf = this.textFields.get(ordinal);
        if (newFocus) {
            this.focus(ordinal);
            tf.m_94201_();
            tf.m_94208_(0);
        } else {
            tf.m_94208_(tf.m_94207_());
        }
    }

    public TextFieldManager clear() {
        this.textFields.clear();
        this.focusedField = -1;
        return this;
    }
}

