/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.area;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.render.area.IPositionProvider;
import me.desht.modularrouters.logic.ModuleTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModuleTargetRenderer {
    private static final float BOX_SIZE = 0.5f;
    private static final float BOX_START = 0.25f;
    private static ItemStack lastStack = ItemStack.f_41583_;
    private static CompiledPosition compiledPos = null;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        ItemStack curItem;
        if (event.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91074_ != null && !ItemStack.m_41728_((ItemStack)(curItem = Minecraft.m_91087_().f_91074_.m_21205_()), (ItemStack)lastStack)) {
            CompiledPosition compiledPosition;
            lastStack = curItem.m_41777_();
            Item item = curItem.m_41720_();
            if (item instanceof IPositionProvider) {
                IPositionProvider pp = (IPositionProvider)item;
                compiledPosition = new CompiledPosition(curItem, pp);
            } else {
                compiledPosition = null;
            }
            compiledPos = compiledPosition;
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (compiledPos != null) {
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            PoseStack matrixStack = event.getMatrixStack();
            matrixStack.m_85836_();
            Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            ModuleTargetRenderer.render(buffer, matrixStack, compiledPos);
            matrixStack.m_85849_();
        }
    }

    private static void render(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, CompiledPosition cp) {
        cp.positions.forEach((pos, faceAndColour) -> {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)((float)pos.m_123341_() + 0.25f), (double)((float)pos.m_123342_() + 0.25f), (double)((float)pos.m_123343_() + 0.25f));
            Matrix4f posMat = matrixStack.m_85850_().m_85861_();
            int color = faceAndColour.colour();
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            VertexConsumer faceBuilder = buffer.m_6299_(ModRenderTypes.BLOCK_HILIGHT_FACE);
            int alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.NORTH);
            faceBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.SOUTH);
            faceBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.WEST);
            faceBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.EAST);
            faceBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.DOWN);
            faceBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.UP);
            faceBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.5f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            faceBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
            RenderSystem.m_69465_();
            buffer.m_109912_(ModRenderTypes.BLOCK_HILIGHT_FACE);
            VertexConsumer lineBuilder = buffer.m_6299_(ModRenderTypes.BLOCK_HILIGHT_LINE);
            lineBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.0f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.0f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.5f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.5f, 0.5f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            lineBuilder.m_85982_(posMat, 0.0f, 0.5f, 0.0f).m_6122_(64, 64, 64, 80).m_5752_();
            RenderSystem.m_69465_();
            buffer.m_109912_(ModRenderTypes.BLOCK_HILIGHT_LINE);
            matrixStack.m_85849_();
        });
    }

    private static int getFaceAlpha(CompiledPosition.FaceAndColour fc, Direction face) {
        return fc.faces.get(face.m_122411_()) ? 160 : 40;
    }

    static class CompiledPosition {
        private final Map<BlockPos, FaceAndColour> positions = new HashMap<BlockPos, FaceAndColour>();

        CompiledPosition(ItemStack stack, IPositionProvider provider) {
            List<ModuleTarget> targets = provider.getStoredPositions(stack);
            for (int i = 0; i < targets.size(); ++i) {
                ModuleTarget target = targets.get(i);
                if (!target.isSameWorld((Level)Minecraft.m_91087_().f_91073_)) continue;
                BlockPos pos = target.gPos.m_122646_();
                if (this.positions.containsKey(pos)) {
                    this.positions.get((Object)pos).faces.set(target.face.m_122411_());
                    continue;
                }
                FaceAndColour fc = new FaceAndColour(new BitSet(6), provider.getRenderColor(i));
                fc.faces.set(target.face.m_122411_());
                this.positions.put(pos, fc);
            }
        }

        record FaceAndColour(BitSet faces, int colour) {
        }
    }
}

