/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.handler.GhostItemHandler;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class BaseModuleHandler
extends GhostItemHandler {
    private final ItemStack holderStack;
    private final ModularRouterBlockEntity router;
    private final String tagName;

    public BaseModuleHandler(ItemStack holderStack, ModularRouterBlockEntity router, int size, String tagName) {
        super(size);
        this.holderStack = holderStack;
        this.router = router;
        this.tagName = tagName;
        this.deserializeNBT(holderStack.m_41698_("modularrouters").m_128469_(tagName));
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    protected void onContentsChanged(int slot) {
        this.save();
        if (this.router != null) {
            this.router.recompileNeeded(1);
        }
    }

    public static int getFilterSize(ItemStack holderStack, String tagName) {
        CompoundTag tag = holderStack.m_41737_("modularrouters");
        if (tag != null && tag.m_128441_(tagName)) {
            ModuleFilterHandler handler = new ModuleFilterHandler(holderStack, null);
            int n = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public void save() {
        this.holderStack.m_41698_("modularrouters").m_128365_(this.tagName, (Tag)this.serializeNBT());
    }

    public static class ModuleFilterHandler
    extends BaseModuleHandler {
        public ModuleFilterHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
            super(holderStack, router, 9, "ModuleFilter");
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ((ModuleItem)this.getHolderStack().m_41720_()).isItemValidForFilter(stack);
        }
    }

    public static class BulkFilterHandler
    extends BaseModuleHandler {
        public BulkFilterHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
            super(holderStack, router, 54, "ModuleFilter");
        }
    }
}

