/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.datagen;

import java.util.Arrays;
import java.util.function.Supplier;
import me.desht.modularrouters.ModularRoutersTags;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fmllegacy.RegistryObject;

public class ModItemTagsProvider
extends ItemTagsProvider {
    public ModItemTagsProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, new BlockTagsProvider(generatorIn, "modularrouters", existingFileHelper), "modularrouters", existingFileHelper);
    }

    protected void m_6577_() {
        for (RegistryObject ro : ModItems.ITEMS.getEntries()) {
            if (ro.get() instanceof ModuleItem) {
                this.addItemsToTag(ModularRoutersTags.Items.MODULES, new Supplier[]{ro});
                continue;
            }
            if (ro.get() instanceof UpgradeItem) {
                this.addItemsToTag(ModularRoutersTags.Items.UPGRADES, new Supplier[]{ro});
                continue;
            }
            if (ro.get() instanceof AugmentItem) {
                this.addItemsToTag(ModularRoutersTags.Items.AUGMENTS, new Supplier[]{ro});
                continue;
            }
            if (!(ro.get() instanceof SmartFilterItem)) continue;
            this.addItemsToTag(ModularRoutersTags.Items.FILTERS, new Supplier[]{ro});
        }
    }

    @SafeVarargs
    private void addItemsToTag(Tag.Named<Item> tag, Supplier<? extends ItemLike> ... items) {
        this.m_126548_(tag).m_126584_((Object[])((Item[])Arrays.stream(items).map(Supplier::get).map(ItemLike::m_5456_).toArray(Item[]::new)));
    }

    public String m_6055_() {
        return "Modular Routers Item Tags";
    }
}

