/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.ModularRouterScreen;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ContainerModularRouter;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.MRBaseItem;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.SimpleItemMatcher;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public abstract class ModuleItem
extends MRBaseItem
implements ModItems.ITintable {
    final BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler;

    public ModuleItem(Item.Properties props, BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler) {
        super(props);
        this.compiler = compiler;
    }

    public final CompiledModule compile(ModularRouterBlockEntity router, ItemStack stack) {
        return this.compiler.apply(router, stack);
    }

    @Override
    public abstract TintColor getItemTint();

    public boolean isDirectional() {
        return true;
    }

    public boolean isOmniDirectional() {
        return false;
    }

    public boolean isFluidModule() {
        return false;
    }

    ContainerModule createContainer(int windowId, Inventory invPlayer, MFLocator loc) {
        return new ContainerModule(this.getContainerType(), windowId, invPlayer, loc);
    }

    public MenuType<? extends ContainerModule> getContainerType() {
        return (MenuType)ModContainerTypes.CONTAINER_MODULE_BASIC.get();
    }

    public boolean isItemValidForFilter(ItemStack stack) {
        return true;
    }

    @Nonnull
    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new SimpleItemMatcher(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        ClientUtil.getOpenItemRouter().ifPresent(router -> {
            Slot slot = ((ModularRouterScreen)Minecraft.m_91087_().f_91080_).getSlotUnderMouse();
            if (slot instanceof ContainerModularRouter.InstalledModuleSlot) {
                String s = ClientSetup.keybindConfigure.getKey().m_84874_();
                list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.configureHint", Character.valueOf(s.charAt(s.length() - 1))));
            }
        });
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<Component> list) {
        this.addSettingsInformation(stack, list);
        this.addAugmentInformation(stack, list);
    }

    protected void addSettingsInformation(ItemStack itemstack, List<Component> list) {
        int energy;
        Termination termination;
        Object col;
        if (this.isDirectional()) {
            RelativeDirection dir = ModuleHelper.getRelativeDirection(itemstack);
            MutableComponent itc = ClientUtil.xlate((String)(this.isOmniDirectional() && dir == RelativeDirection.NONE ? "modularrouters.guiText.tooltip.allDirections" : "modularrouters.guiText.tooltip." + dir.toString()), new Object[0]);
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.label.direction", new Object[0]).m_7220_((Component)new TextComponent(": ")).m_7220_((Component)itc.m_130940_(ChatFormatting.AQUA)));
        }
        this.addFilterInformation(itemstack, list);
        list.add((Component)new TextComponent(I18n.m_118938_((String)"modularrouters.itemText.misc.flags", (Object[])new Object[0]) + ": " + String.join((CharSequence)" | ", this.formatFlag("IGNORE_DAMAGE", ModuleHelper.ignoreDamage(itemstack)), this.formatFlag("IGNORE_NBT", ModuleHelper.ignoreNBT(itemstack)), this.formatFlag("IGNORE_TAGS", ModuleHelper.ignoreTags(itemstack)))));
        boolean matchAll = ModuleHelper.isMatchAll(itemstack);
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.match", new Object[0]).m_130946_(": ").m_7220_((Component)ClientUtil.xlate("modularrouters.itemText.misc." + (matchAll ? "matchAll" : "matchAny"), new Object[0]).m_130940_(ChatFormatting.AQUA)));
        ModuleItem moduleItem = this;
        if (moduleItem instanceof IRangedModule) {
            IRangedModule rm = (IRangedModule)((Object)moduleItem);
            int curRange = rm.getCurrentRange(itemstack);
            col = curRange > rm.getBaseRange() ? ChatFormatting.GREEN.toString() : (curRange < rm.getBaseRange() ? ChatFormatting.RED.toString() : ChatFormatting.AQUA.toString());
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.rangeInfo", col, rm.getCurrentRange(itemstack), rm.getBaseRange(), rm.getHardMaxRange()));
        }
        if ((termination = ModuleHelper.getTermination(itemstack)) != Termination.NONE) {
            list.add((Component)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
        if ((col = this) instanceof IPickaxeUser) {
            IPickaxeUser pickaxeUser = (IPickaxeUser)col;
            ItemStack pick = pickaxeUser.getPickaxe(itemstack);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.breakerPick", new Object[0]).m_7220_((Component)pick.m_41786_().m_6879_().m_130940_(ChatFormatting.AQUA)));
            EnchantmentHelper.m_44831_((ItemStack)pick).forEach((ench, level) -> list.add((Component)new TextComponent("\u25b6 ").m_7220_((Component)ench.m_44700_(level.intValue()).m_6879_().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.YELLOW)));
        }
        if ((energy = this.getEnergyCost(itemstack)) != 0) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.energyUsage", energy));
        }
    }

    public abstract int getEnergyCost(ItemStack var1);

    private void addAugmentInformation(ItemStack stack, List<Component> list) {
        AugmentItem.AugmentCounter c = new AugmentItem.AugmentCounter(stack);
        ArrayList toAdd = Lists.newArrayList();
        for (AugmentItem augment : c.getAugments()) {
            int n = c.getAugmentCount(augment);
            if (n <= 0) continue;
            ItemStack augmentStack = new ItemStack((ItemLike)augment);
            Object s = augmentStack.m_41786_().getString();
            if (n > 1) {
                s = n + " x " + (String)s;
            }
            s = (String)s + ChatFormatting.AQUA + augment.getExtraInfo(n, stack);
            toAdd.add(new TextComponent(" \u2022 " + ChatFormatting.DARK_GREEN + (String)s));
        }
        if (!toAdd.isEmpty()) {
            list.add((Component)new TextComponent(ChatFormatting.GREEN.toString()).m_7220_((Component)ClientUtil.xlate("modularrouters.itemText.augments", new Object[0])));
            list.addAll(toAdd);
        }
    }

    public String getDirectionString(RelativeDirection dir) {
        return this.isOmniDirectional() && dir == RelativeDirection.NONE ? I18n.m_118938_((String)"modularrouters.guiText.tooltip.allDirections", (Object[])new Object[0]) : I18n.m_118938_((String)("modularrouters.guiText.tooltip." + dir.toString()), (Object[])new Object[0]);
    }

    private String formatFlag(String key, boolean flag) {
        String text = I18n.m_118938_((String)("modularrouters.itemText.misc." + key), (Object[])new Object[0]);
        return (flag ? ChatFormatting.DARK_GRAY : ChatFormatting.AQUA) + text + ChatFormatting.RESET;
    }

    protected Component getFilterItemDisplayName(ItemStack stack) {
        return stack.m_41786_();
    }

    protected MutableComponent itemListHeader(ItemStack itemstack) {
        return ClientUtil.xlate("modularrouters.itemText.misc." + (ModuleHelper.isBlacklist(itemstack) ? "blacklist" : "whitelist"), new Object[0]);
    }

    private void addFilterInformation(ItemStack itemstack, List<Component> list) {
        ArrayList<MutableComponent> l2 = new ArrayList<MutableComponent>();
        BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(itemstack, null);
        for (int i = 0; i < filterHandler.getSlots(); ++i) {
            ItemStack s = filterHandler.getStackInSlot(i);
            if (s.m_41720_() instanceof SmartFilterItem) {
                int size = ((SmartFilterItem)s.m_41720_()).getSize(s);
                Object suffix = size > 0 ? " [" + size + "]" : "";
                l2.add(new TextComponent(" \u2022 ").m_7220_((Component)s.m_41786_().m_6879_().m_130946_((String)suffix)).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
                continue;
            }
            if (s.m_41619_()) continue;
            l2.add(new TextComponent(" \u2022 ").m_7220_((Component)this.getFilterItemDisplayName(s).m_6879_().m_130940_(ChatFormatting.AQUA)));
        }
        if (l2.isEmpty()) {
            list.add((Component)this.itemListHeader(itemstack).m_130940_(ChatFormatting.YELLOW).m_130946_(": ").m_7220_((Component)ClientUtil.xlate("modularrouters.itemText.misc.noItems", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})));
        } else {
            list.add((Component)this.itemListHeader(itemstack).m_130940_(ChatFormatting.YELLOW).m_130946_(": "));
            list.addAll(l2);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ModuleHelper.validateNBT(stack);
        if (!player.m_20161_()) {
            if (!world.f_46443_) {
                MFLocator locator = MFLocator.heldModule(hand);
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProvider(player, locator), locator::writeBuf);
            }
        } else {
            return this.onSneakRightClick(stack, world, player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean m_5812_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IPickaxeUser) {
            IPickaxeUser pickaxeUser = (IPickaxeUser)item;
            ItemStack pick = pickaxeUser.getPickaxe(stack);
            return !pick.m_41619_() && !EnchantmentHelper.m_44831_((ItemStack)pick).isEmpty();
        }
        return false;
    }

    public String getRegulatorTranslationKey(ItemStack stack) {
        return "modularrouters.guiText.tooltip.regulator.label";
    }

    public InteractionResultHolder<ItemStack> onSneakRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public static enum RelativeDirection {
        NONE(0, " "),
        DOWN(1, "\u25bc"),
        UP(2, "\u25b2"),
        LEFT(4, "\u25c0"),
        RIGHT(8, "\u25b6"),
        FRONT(16, "\u25a3"),
        BACK(32, "\u25a4");

        private final int mask;
        private final String symbol;

        private RelativeDirection(int mask, String symbol) {
            this.mask = mask;
            this.symbol = symbol;
        }

        public Direction toAbsolute(Direction current) {
            return switch (this) {
                case UP -> Direction.UP;
                case DOWN -> Direction.DOWN;
                case LEFT -> current.m_122427_();
                case BACK -> current.m_122424_();
                case RIGHT -> current.m_122428_();
                default -> current;
            };
        }

        public String getSymbol() {
            return this.symbol;
        }

        public int getMask() {
            return this.mask;
        }

        public int getTextureX(boolean toggled) {
            return this.ordinal() * 32 + (toggled ? 16 : 0);
        }

        public int getTextureY() {
            return 48;
        }
    }

    public static enum Termination implements IHasTranslationKey
    {
        NONE,
        RAN,
        NOT_RAN;


        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.tooltip.terminate." + this;
        }
    }

    public static class ContainerProvider
    implements MenuProvider {
        private final MFLocator loc;
        private final ItemStack moduleStack;

        public ContainerProvider(Player player, MFLocator loc) {
            this.loc = loc;
            this.moduleStack = loc.getModuleStack(player);
        }

        public Component m_5446_() {
            return this.moduleStack.m_41786_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
            return ((ModuleItem)this.moduleStack.m_41720_()).createContainer(windowId, playerInventory, this.loc);
        }
    }

    public static enum ModuleFlags {
        BLACKLIST(true, "F_blacklist", 0),
        IGNORE_DAMAGE(false, "F_ignoreDamage", 32),
        IGNORE_NBT(true, "F_ignoreNBT", 64),
        IGNORE_TAGS(true, "F_ignoreTags", 96);

        private final boolean defaultValue;
        private final String name;
        private final int textureX;

        private ModuleFlags(boolean defaultValue, String name, int textureX) {
            this.defaultValue = defaultValue;
            this.name = name;
            this.textureX = textureX;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public int getTextureX(boolean toggled) {
            return this.textureX + (toggled ? 16 : 0);
        }

        public int getTextureY() {
            return 32;
        }
    }
}

