/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleTarget {
    public final GlobalPos gPos;
    public final Direction face;
    public final String blockTranslationKey;
    private LazyOptional<IItemHandler> cachedItemCap = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> cachedEnergyCap = LazyOptional.empty();

    public ModuleTarget(GlobalPos gPos, Direction face, String blockTranslationKey) {
        this.gPos = gPos;
        this.face = face;
        this.blockTranslationKey = blockTranslationKey;
    }

    public ModuleTarget(GlobalPos gPos, Direction face) {
        this(gPos, face, "");
    }

    public ModuleTarget(GlobalPos gPos) {
        this(gPos, null);
    }

    public CompoundTag toNBT() {
        CompoundTag ext = new CompoundTag();
        ext.m_128365_("Pos", (Tag)MiscUtil.serializeGlobalPos(this.gPos));
        ext.m_128344_("Face", (byte)this.face.m_122411_());
        ext.m_128359_("InvName", this.blockTranslationKey);
        return ext;
    }

    public static ModuleTarget fromNBT(CompoundTag nbt) {
        GlobalPos gPos = MiscUtil.deserializeGlobalPos(nbt.m_128469_("Pos"));
        Direction face = Direction.m_122376_((int)nbt.m_128445_("Face"));
        return new ModuleTarget(gPos, face, nbt.m_128461_("InvName"));
    }

    public boolean isSameWorld(@Nullable Level world) {
        return world != null && this.gPos.m_122640_() == world.m_46472_();
    }

    public boolean isSameWorld(ModuleTarget dst) {
        return this.gPos.m_122640_() == dst.gPos.m_122640_();
    }

    public boolean hasItemHandlerClientSide() {
        Level w = ClientUtil.theClientWorld();
        return this.isSameWorld(w) && this.getItemHandlerFor(w).isPresent();
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.getItemHandlerFor((Level)MiscUtil.getWorldForGlobalPos(this.gPos));
    }

    private LazyOptional<IItemHandler> getItemHandlerFor(Level w) {
        if (!this.cachedItemCap.isPresent()) {
            BlockPos pos = this.gPos.m_122646_();
            if (w == null || !w.m_46749_(pos)) {
                this.cachedItemCap = LazyOptional.empty();
            } else {
                BlockEntity te = w.m_7702_(pos);
                LazyOptional lazyOptional = this.cachedItemCap = te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face);
            }
            if (this.cachedItemCap.isPresent()) {
                this.cachedItemCap.addListener(c -> {
                    this.cachedItemCap = LazyOptional.empty();
                });
            }
        }
        return this.cachedItemCap;
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        if (!this.cachedEnergyCap.isPresent()) {
            BlockPos pos = this.gPos.m_122646_();
            ServerLevel w = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (w == null || !w.m_46749_(pos)) {
                this.cachedEnergyCap = LazyOptional.empty();
            } else {
                BlockEntity te = w.m_7702_(pos);
                LazyOptional lazyOptional = this.cachedEnergyCap = te == null ? LazyOptional.empty() : te.getCapability(CapabilityEnergy.ENERGY, this.face);
            }
            if (this.cachedEnergyCap.isPresent()) {
                this.cachedEnergyCap.addListener(c -> {
                    this.cachedEnergyCap = LazyOptional.empty();
                });
            }
        }
        return this.cachedEnergyCap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Object object = o;
        if (!(object instanceof ModuleTarget)) {
            return false;
        }
        ModuleTarget that = (ModuleTarget)object;
        return this.gPos.equals((Object)that.gPos) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.gPos, this.face);
    }

    public String toString() {
        return MiscUtil.locToString(this.gPos) + " " + this.face;
    }

    public Component getTextComponent() {
        return new TranslatableComponent(this.blockTranslationKey).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(" @ " + this.toString()).m_130940_(ChatFormatting.AQUA));
    }
}

