/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;

public class CompiledActivatorModule
extends CompiledModule {
    public static final String NBT_ACTION_TYPE = "ActionType2";
    public static final String NBT_LOOK_DIRECTION = "LookDirection";
    public static final String NBT_SNEAKING = "Sneaking";
    public static final String NBT_ENTITY_MODE = "EntityMode";
    private final ActionType actionType;
    private final LookDirection lookDirection;
    private final EntityMode entityMode;
    private final boolean sneaking;
    private int entityIdx;
    private final Set<String> BLOCK_METHODS = ImmutableSet.of((Object)"onBlockActivated", (Object)"use");
    private final Set<String> ITEM_METHODS = ImmutableSet.of((Object)"onItemUseFirst", (Object)"onItemUse", (Object)"useOn", (Object)"onItemRightClick", (Object)"use");
    private static final Set<Item> itemBlacklist = new HashSet<Item>();
    private static final Set<Block> blockBlacklist = new HashSet<Block>();

    public CompiledActivatorModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = stack.m_41737_("modularrouters");
        if (compound != null) {
            this.actionType = ActionType.values()[compound.m_128451_(NBT_ACTION_TYPE)];
            this.lookDirection = LookDirection.values()[compound.m_128451_(NBT_LOOK_DIRECTION)];
            this.entityMode = EntityMode.values()[compound.m_128451_(NBT_ENTITY_MODE)];
            this.sneaking = compound.m_128471_(NBT_SNEAKING);
        } else {
            this.actionType = ActionType.ITEM_OR_BLOCK;
            this.lookDirection = LookDirection.LEVEL;
            this.entityMode = EntityMode.NEAREST;
            this.sneaking = false;
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        ItemStack stack = router.getBufferItemStack();
        if (itemBlacklist.contains(stack.m_41720_())) {
            return false;
        }
        if (!stack.m_41619_() && !this.getFilter().test(stack)) {
            return false;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        Vec3 centre = Vec3.m_82512_((Vec3i)router.m_58899_());
        fakePlayer.m_6034_(centre.m_7096_() + (double)this.getFacing().m_122429_() * 0.501, centre.m_7098_() + (double)this.getFacing().m_122430_() * 0.501, centre.m_7094_() + (double)this.getFacing().m_122431_() * 0.501);
        fakePlayer.m_20260_(this.sneaking);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
        boolean didWork = switch (this.actionType) {
            case ActionType.ITEM_OR_BLOCK -> this.doUseItem(router, fakePlayer);
            case ActionType.USE_ITEM_ON_ENTITY -> this.doUseItemOnEntity(router, fakePlayer);
            case ActionType.ATTACK_ENTITY -> this.doAttackEntity(router, fakePlayer);
            default -> throw new IncompatibleClassChangeError();
        };
        if (didWork) {
            router.setBufferItemStack(fakePlayer.m_21205_());
            this.dropExtraItems(router, (Player)fakePlayer);
        }
        return didWork;
    }

    private boolean doUseItem(ModularRouterBlockEntity router, FakePlayer fakePlayer) {
        BlockPos pos = router.m_58899_();
        Level world = router.m_58904_();
        ItemStack stack = router.getBufferItemStack();
        fakePlayer.m_146922_((float)MiscUtil.getYawFromFacing(this.getFacing()));
        fakePlayer.m_146926_(this.getFacing().m_122434_() == Direction.Axis.Y ? (float)(this.getFacing().m_122430_() * -90) : this.lookDirection.pitch);
        BlockHitResult brtr = this.doRayTrace(pos, fakePlayer);
        BlockState state = world.m_8055_(brtr.m_82425_());
        if (brtr.m_6662_() != HitResult.Type.MISS && blockBlacklist.contains(state.m_60734_())) {
            return false;
        }
        try {
            return fakePlayer.f_8941_.m_7179_((ServerPlayer)fakePlayer, world, stack, InteractionHand.MAIN_HAND, brtr).m_19077_() || fakePlayer.f_8941_.m_6261_((ServerPlayer)fakePlayer, world, stack, InteractionHand.MAIN_HAND).m_19077_();
        }
        catch (Exception e) {
            this.handleBlacklisting(stack, state, e);
            return false;
        }
    }

    private void handleBlacklisting(ItemStack stack, BlockState state, Exception e) {
        for (StackTraceElement el : e.getStackTrace()) {
            if (this.ITEM_METHODS.contains(el.getMethodName())) {
                ModularRouters.LOGGER.error("Attempting to use item {} threw an exception. Blacklisting this item for the Activator Module until next server restart!", (Object)stack);
                ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
                itemBlacklist.add(stack.m_41720_());
                return;
            }
            if (!this.BLOCK_METHODS.contains(el.getMethodName())) continue;
            ModularRouters.LOGGER.error("Attempting to use block {} threw an exception. Blacklisting this block for the Activator Module until next server restart!", (Object)state);
            ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
            blockBlacklist.add(state.m_60734_());
            return;
        }
    }

    private BlockHitResult doRayTrace(BlockPos routerPos, FakePlayer fp) {
        Vec3 fpVec = fp.m_20182_();
        int xOff = this.getFacing().m_122429_();
        int yOff = this.getFacing().m_122430_();
        int zOff = this.getFacing().m_122431_();
        BlockPos.MutableBlockPos targetPos = routerPos.m_142300_(this.getFacing()).m_122032_();
        if (this.lookDirection != LookDirection.LEVEL && Block.m_49916_((VoxelShape)fp.f_19853_.m_8055_((BlockPos)targetPos).m_60808_((BlockGetter)fp.f_19853_, (BlockPos)targetPos))) {
            if (this.lookDirection == LookDirection.ABOVE) {
                fpVec = Vec3.m_82512_((Vec3i)targetPos).m_82520_(0.0, 1.0, 0.0);
                yOff = -1;
            } else if (this.lookDirection == LookDirection.BELOW) {
                fpVec = Vec3.m_82512_((Vec3i)targetPos).m_82520_(0.0, -1.0, 0.0);
                yOff = 1;
            }
        } else if (this.lookDirection == LookDirection.ABOVE) {
            targetPos.m_122173_(Direction.UP);
            yOff = 1;
        } else if (this.lookDirection == LookDirection.BELOW) {
            targetPos.m_122173_(Direction.DOWN);
            yOff = -1;
        }
        double reachDist = Math.pow(this.getPlayerReachDistance((Player)fp), 2.0);
        while (targetPos.m_123331_((Vec3i)routerPos) <= reachDist) {
            Vec3 targetVec;
            BlockHitResult res;
            VoxelShape shape;
            if (!fp.f_19853_.m_46859_((BlockPos)targetPos) && !(shape = fp.f_19853_.m_8055_((BlockPos)targetPos).m_60808_((BlockGetter)fp.f_19853_, (BlockPos)targetPos)).m_83281_() && (res = fp.f_19853_.m_45547_(new ClipContext(fpVec, targetVec = ((AABB)shape.m_83299_().get(0)).m_82399_().m_82549_(Vec3.m_82528_((Vec3i)targetPos)), ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, null))).m_6662_() == HitResult.Type.BLOCK) {
                return res;
            }
            targetPos.m_122184_(xOff, yOff, zOff);
        }
        return BlockHitResult.m_82426_((Vec3)fpVec.m_82549_(fp.m_20154_()), (Direction)this.getFacing().m_122424_(), (BlockPos)routerPos.m_142300_(this.getFacing()));
    }

    private double getPlayerReachDistance(Player player) {
        AttributeInstance attr;
        if (player != null && (attr = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            return attr.m_22135_() + 1.0;
        }
        return 4.5;
    }

    private boolean doAttackEntity(ModularRouterBlockEntity router, RouterFakePlayer fakePlayer) {
        LivingEntity entity = this.findEntity(router, LivingEntity.class);
        if (entity == null || entity instanceof Player && router.getUpgradeCount((Item)ModItems.SECURITY_UPGRADE.get()) > 0 && router.isPermitted((Player)entity)) {
            return false;
        }
        fakePlayer.m_7618_(EntityAnchorArgument.Anchor.EYES, entity.m_20182_());
        fakePlayer.m_5706_((Entity)entity);
        return true;
    }

    private boolean doUseItemOnEntity(ModularRouterBlockEntity router, FakePlayer fakePlayer) {
        Entity entity = this.findEntity(router, Entity.class);
        if (entity == null) {
            return false;
        }
        InteractionResult result = fakePlayer.m_36157_(entity, InteractionHand.MAIN_HAND);
        if (result.m_19077_()) {
            router.setBufferItemStack(fakePlayer.m_21205_());
            return true;
        }
        return false;
    }

    private <T extends Entity> T findEntity(ModularRouterBlockEntity router, Class<T> cls) {
        Direction face = this.getFacing();
        BlockPos pos = router.m_58899_();
        Vec3 vec = Vec3.m_82512_((Vec3i)pos);
        AABB box = new AABB(vec, vec).m_82386_((double)face.m_122429_() * 2.5, (double)face.m_122430_() * 2.5, (double)face.m_122431_() * 2.5).m_82400_(2.0);
        List l = router.m_58904_().m_6443_(cls, box, this::passesBlacklist);
        if (l.isEmpty()) {
            return null;
        }
        switch (this.entityMode) {
            case RANDOM: {
                return (T)((Entity)l.get(router.m_58904_().f_46441_.nextInt(l.size())));
            }
            case NEAREST: {
                l.sort(Comparator.comparingDouble(o -> o.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())));
                return (T)((Entity)l.get(0));
            }
            case ROUND_ROBIN: {
                l.sort(Comparator.comparingDouble(o -> o.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())));
                this.entityIdx = (this.entityIdx + 1) % l.size();
                return (T)((Entity)l.get(this.entityIdx));
            }
        }
        return null;
    }

    private boolean passesBlacklist(Entity e) {
        return !MRConfig.Common.Module.activatorEntityBlacklist.contains(e.m_6095_().getRegistryName());
    }

    private void dropExtraItems(ModularRouterBlockEntity router, Player fakePlayer) {
        NonNullList inv = fakePlayer.m_150109_().f_35974_;
        Vec3 where = Vec3.m_82512_((Vec3i)router.m_58899_().m_142300_(this.getFacing()));
        for (int i = 1; i < inv.size() && !((ItemStack)inv.get(i)).m_41619_(); ++i) {
            ItemEntity item = new ItemEntity(router.m_58904_(), where.m_7096_(), where.m_7098_(), where.m_7094_(), (ItemStack)inv.get(i));
            router.m_58904_().m_7967_((Entity)item);
            inv.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LookDirection getLookDirection() {
        return this.lookDirection;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public int getEnergyCost() {
        return this.actionType == ActionType.ATTACK_ENTITY ? MRConfig.Common.EnergyCosts.activatorModuleEnergyCostAttack : MRConfig.Common.EnergyCosts.activatorModuleEnergyCost;
    }

    @Override
    public boolean careAboutItemAttributes() {
        return this.actionType == ActionType.ATTACK_ENTITY;
    }

    public static enum ActionType implements IHasTranslationKey
    {
        ITEM_OR_BLOCK(false),
        USE_ITEM_ON_ENTITY(true),
        ATTACK_ENTITY(true);

        private final boolean entity;

        private ActionType(boolean entity) {
            this.entity = entity;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.action." + this;
        }

        public static ActionType fromOldOrdinal(int ord) {
            return ord == 2 ? USE_ITEM_ON_ENTITY : ITEM_OR_BLOCK;
        }

        public boolean isEntityTarget() {
            return this.entity;
        }
    }

    public static enum LookDirection implements IHasTranslationKey
    {
        LEVEL(0.0f),
        ABOVE(-45.0f),
        BELOW(45.0f);

        private final float pitch;

        private LookDirection(float pitch) {
            this.pitch = pitch;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.direction." + this;
        }
    }

    public static enum EntityMode implements IHasTranslationKey
    {
        NEAREST,
        RANDOM,
        ROUND_ROBIN;


        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.entityMode." + this;
        }
    }
}

