/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CompiledBreakerModule
extends CompiledModule {
    private final ItemStack pickaxe;

    public CompiledBreakerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.pickaxe = ((IPickaxeUser)stack.m_41720_()).getPickaxe(stack);
        if (!EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() && EnchantmentHelper.m_44831_((ItemStack)this.pickaxe).isEmpty()) {
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)stack), (ItemStack)this.pickaxe);
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        if (this.isRegulationOK(router, true)) {
            Level world = router.m_58904_();
            if (!(world instanceof ServerLevel)) {
                return false;
            }
            BlockPos pos = this.getTarget().gPos.m_122646_();
            BlockState oldState = world.m_8055_(pos);
            BlockUtil.BreakResult breakResult = BlockUtil.tryBreakBlock(router, world, pos, this.getFilter(), this.pickaxe);
            if (breakResult.isBlockBroken()) {
                breakResult.processDrops(world, pos, router.getBuffer());
                if (MRConfig.Common.Module.breakerParticles && router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0) {
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)oldState));
                }
                return true;
            }
        }
        return false;
    }
}

