/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BulkItemMatcher
implements IItemMatcher {
    private final SetofItemStack stacks;
    private final Set<ResourceLocation> tags;

    public BulkItemMatcher(SetofItemStack stacks, Filter.Flags flags) {
        this.stacks = stacks;
        this.tags = Sets.newHashSet();
        if (flags.matchTags()) {
            ObjectIterator objectIterator = stacks.iterator();
            while (objectIterator.hasNext()) {
                ItemStack stack = (ItemStack)objectIterator.next();
                this.tags.addAll(stack.m_41720_().getTags());
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        if (this.stacks.contains(stack)) {
            return true;
        }
        return flags.matchTags() && this.matchTags(stack);
    }

    private boolean matchTags(ItemStack stack) {
        return !Sets.intersection((Set)stack.m_41720_().getTags(), this.tags).isEmpty();
    }
}

