/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;

public class FilterSettingsMessage {
    private final Operation op;
    private final CompoundTag payload;
    private final MFLocator locator;

    public FilterSettingsMessage(Operation op, MFLocator locator, CompoundTag payload) {
        this.op = op;
        this.locator = locator;
        this.payload = payload;
    }

    public FilterSettingsMessage(FriendlyByteBuf buf) {
        this.op = (Operation)buf.m_130066_(Operation.class);
        this.locator = MFLocator.fromBuffer(buf);
        this.payload = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.op);
        this.locator.writeBuf(buf);
        buf.m_130079_(this.payload);
    }

    public Operation getOp() {
        return this.op;
    }

    public CompoundTag getPayload() {
        return this.payload;
    }

    public LazyOptional<IItemHandler> getTargetInventory() {
        ModuleTarget target = ModuleTarget.fromNBT(this.payload);
        return target.getItemHandler();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                this.processPacket(player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void processPacket(ServerPlayer player) {
        ItemStack moduleStack = this.locator.getModuleStack((Player)player);
        ItemStack filterStack = this.locator.getTargetItem((Player)player);
        Item item = filterStack.m_41720_();
        if (item instanceof SmartFilterItem) {
            SmartFilterItem sf = (SmartFilterItem)item;
            GuiSyncMessage response = sf.onReceiveSettingsMessage((Player)player, this, filterStack, moduleStack);
            if (!moduleStack.m_41619_()) {
                ModularRouterBlockEntity router = this.locator.getRouter(player.f_19853_).orElse(null);
                BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, router);
                filterHandler.setStackInSlot(this.locator.filterSlot, filterStack);
                filterHandler.save();
                if (this.locator.hand != null) {
                    player.m_21008_(this.locator.hand, filterHandler.getHolderStack());
                } else if (router != null) {
                    router.recompileNeeded(1);
                }
            }
            if (response != null) {
                PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 8.0, player.m_20193_().m_46472_());
                PacketHandler.NETWORK.send(PacketDistributor.NEAR.with(() -> tp), (Object)response);
            }
        }
    }

    public static enum Operation {
        CLEAR_ALL,
        REMOVE_ITEM,
        MERGE,
        LOAD,
        ADD_STRING,
        REMOVE_AT,
        ANY_ALL_FLAG;

    }
}

