/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ModuleSettingsMessage {
    private final MFLocator locator;
    private final CompoundTag payload;

    ModuleSettingsMessage(FriendlyByteBuf buf) {
        this.locator = MFLocator.fromBuffer(buf);
        this.payload = buf.m_130260_();
    }

    public ModuleSettingsMessage(MFLocator locator, CompoundTag payload) {
        this.locator = locator;
        this.payload = payload;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.locator.writeBuf(buf);
        buf.m_130079_(this.payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ItemStack moduleStack = this.locator.getModuleStack((Player)player);
                if (moduleStack.m_41720_() instanceof ModuleItem) {
                    CompoundTag compound = ModuleHelper.validateNBT(moduleStack);
                    for (String key : this.payload.m_128431_()) {
                        compound.m_128365_(key, this.payload.m_128423_(key));
                    }
                    if (this.locator.routerPos != null) {
                        player.m_20193_().m_141902_(this.locator.routerPos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> router.recompileNeeded(1));
                    }
                } else {
                    ModularRouters.LOGGER.warn("ignoring ModuleSettingsMessage for " + player.m_5446_().getString() + " - expected module not found @ " + this.locator.toString());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

